
App.ux.FormPanelLogin = Ext.extend(Ext.form.FormPanel, {

    initComponent: function()
    {
    
        // rendering functions
        //default/alterable configurables 
        var cfg = {
            frame: true,
			layout:'form',
			bodyStyle:'padding:10px',
            defaultType: 'textfield',
            items: [{
                fieldLabel: 'Username',
                name: 'username',
				xtype:'textfield',
				allowBlank:false
            }, {
                fieldLabel: 'Password',
                name: 'password',
                inputType: 'password',
				xtype:'textfield',
						allowBlank:false}],
            buttons: [{
				id:'btnLogin',
                text: 'Login'
            }],
			waitMsgTarget: true,
			errorReader: new Ext.form.XmlErrorReader(),
			keys: {
                key: 13, // or Ext.EventObject.ENTER
                fn: function()
                {
					this.submitData();
            	},
				scope:this
			}
		};
        
        Ext.applyIf(this, cfg);
        Ext.applyIf(this.initialConfig, cfg);
        
        //non-alterable configurables 
        cfg = {
			

		};
        Ext.apply(this, cfg);
        Ext.apply(this.initialConfig, cfg);
        
        
        App.ux.FormPanelLogin.superclass.initComponent.apply(this, arguments);
        
    }, // eo function initComponent 
    onRender: function(container, position)
    {
        App.ux.FormPanelLogin.superclass.onRender.apply(this, arguments);
		
		// button Login
		Ext.get('btnLogin').on('click',function(){
            this.submitData();
		},this);
    }, // end of function onRender
	
	initEvents: function()
    {
        //call parent - be very careful to always call the parent, otherwise you may break the component
        App.ux.FormPanelLogin.superclass.initEvents.apply(this, arguments);
    }, // end of function initEvents
    submitData:function(){
		this.getForm().submit({
                url: '../../xml/auth?action=login',
                method: 'GET',
                waitMsg: 'Validating data...', // 2DO translation
                customSuccessFn:function(xml,scope)
				{
					var dq = Ext.DomQuery;
                        var session = dq.selectValue('session', xml);
                        var module = dq.selectValue('module',xml);
                        
                        switch (module) {
                            case 'wizard':
                                window.location.replace('wizard.html' + "?session=" + session);
                                break;
                            case 'status':
                                window.location.replace('status.html' + "?session=" + session);
                                break;
							// no module found, send user to status
							default:
								window.location.replace('status.html' + "?session=" + session);
                                break;
                        }
				},
				failure:function()
				{
					App.showError('The login data was not correct.'); // 2DO translation / customFailureFn?
				}
            });
	}
}); // end of extend
/*
 * Register xtype
 */
Ext.ComponentMgr.registerType('ux-formpanellogin', App.ux.FormPanelLogin); //convention is to use all lowercase for xtype
