    App.ux.FormPanelSpanPRI = Ext.extend(Ext.form.FormPanel, {
        // private vars
        initComponent: function()
        {
            // rendering functions
            //default/alterable configurables 
            var cfg = {
                //url: '../../xml/Spans?action=view&spanno=1', // 2DO
                method:'GET',
                border:false,
                trackResetOnLoad: true,
                // configure how to read the XML Data
				errorReader:new Ext.form.XmlErrorReader(),
                reader: new Ext.data.XmlReader({
                    record:'span',
                    success:'@success'
                }, ['configurable', 'channels', 'trunkgroup', 'pin', 'country', 'echocancel', 'active', 'signalling', 'mobilenumber', 'name', 'description', 'spanno','debug','clir']),
                waitMsg:'load data',
                waitMsgTarget:true,
                waitMsgTarget:true,
                bodyStyle:'padding:3px;',
                layout:'anchor',
                labelAlign:'left',
				hideMode:'offsets',
				defaults:{
					width:120
				},
                buttons: [
				{
                    xtype: 'button',
                    text: 'Save settings',
					iconCls:'icon-disk',
                    id: 'btnSubmitSpanGSM',
                    handler: function()
                    {
                        this.saveSettings();
                    },
                    scope: this
                },{
                 	xtype: 'button',
                 	text: 'Discard change',
					iconCls:'icon-cross',
                	handler: function()
                 	{
						// try to switch activeItem
						console.log(this.ownerCt);
						this.getForm().reset();
						if(this.ownerCt.getLayout() !== undefined)
						{
							this.ownerCt.getLayout().setActiveItem(0);
						}
                 		var rec = Ext.getCmp('gridSpans').getSelectionModel().clearSelections();
                 	},
                 	scope: this
                }],
                items:[{
                    xtype: 'ux-checkbox',
                    name: 'active',
                    fieldLabel: 'Active',
                    inputValue: 1
                },{
                    xtype: 'ux-comboboxcountries',
					width:120,
					hideMode:'offsets',
					editable:false
                },{
                    xtype: 'combo',
                    fieldLabel: 'Signalling',
                    name: 'spanSignalling',
                    hiddenName: 'signalling',
                    valueField: 'val',
                    store: new Ext.data.SimpleStore({
                        fields: ['val', 'desc'],
                        data: [[2, 'pri_cpe'], [3, 'pri_net'],[0,'auto']]
                    }),
                    displayField: 'desc',
                    editable: false,
                    mode: 'local',
                    forceSelection: true,
                    triggerAction: 'all',
                    emptyText: '-',
                    disableKeyFilter: true,
                    selectOnFocus: true
                },{
                    xtype: 'textfield',
                    fieldLabel: 'Group',
                    name: 'trunkgroup'
                },{
                    xtype: 'combo',
                    fieldLabel: 'Echocancel',
                    //id: 'comboboxSpanEchoCancel',
                    name: 'spanEchoCancel',
                    hiddenName: 'echocancel',
                    valueField: 'val',
                    store: new Ext.data.SimpleStore({
                        fields: ['val', 'desc'],
                        data: [[256, "yes"], [0, 'no']]
                    }),
                    displayField: 'desc',
                    editable: false,
                    mode: 'local',
                    forceSelection: true,
                    triggerAction: 'all',
                    emptyText: '-',
                    disableKeyFilter: true,
                    selectOnFocus: true
                },{
                    xtype: 'combo',
                    fieldLabel: 'Debug',
                    name: 'spanEchoCancel',
                    hiddenName: 'debug',
                    valueField: 'val',
                    store: new Ext.data.SimpleStore({
                        fields: ['val', 'desc'],
                        data: [[0, "no debug"], [1, 'XML trace'],[2,'console debug']]
                    }),
                    displayField: 'desc',
                    editable: false,
                    mode: 'local',
                    forceSelection: true,
                    triggerAction: 'all',
                    emptyText: '-',
                    disableKeyFilter: true,
                    selectOnFocus: true
                },{
					xtype:'ux-checkbox',
					name:"clir",
					fieldLabel:'CLIR'
				}]
            };
            
            Ext.applyIf(this, cfg);
            Ext.applyIf(this.initialConfig, cfg);
            
            //non-alterable configurables 
            cfg = {};
            Ext.apply(this, cfg);
            Ext.apply(this.initialConfig, cfg);
            
            App.ux.FormPanelSpanPRI.superclass.initComponent.apply(this, arguments);
            
        }, // eo function initComponent 
        onRender: function(container, position)
        {
            App.ux.FormPanelSpanPRI.superclass.onRender.apply(this, arguments);
            // after parent code
            // bind a few useful events to handle row selection, and context menu
            //this.on('contextmenu', this.showContextMenu, this);
            // general buttons
        },
        discardSettings: function()
        {
            this.getForm().reset();
        },
        saveSettings: function()
        {
            var rec = Ext.getCmp('gridSpans').getSelectionModel().getSelected();
            var id = rec.get('spanno');
            this.getForm().submit({
                url: '../../xml/Spans?action=update&spanno=' + id + '',
                scope: this,
				customSuccessFn:function(){
					  Ext.StoreMgr.lookup('storeSpans').load();
                        Ext.getCmp('spanSettings').getLayout().setActiveItem(0);
						 App.showMessage('Span settings were saved successfully.');
				}
            });
        }
    });
    /*
     * Register xtype
     */
    Ext.ComponentMgr.registerType('ux-formpanelspanpri', App.ux.FormPanelSpanPRI); //convention is to use all lowercase for xtype
