App.ux.FormPanelVOIP = Ext.extend(Ext.form.FormPanel, {
    // private vars
    initComponent: function()
    {
        // rendering functions
        //default/alterable configurables 
        var cfg = {
            url: '../../xml/configuration?action=list',
            method: 'GET',
            trackResetOnLoad: true, // reset isDirty state when loading
            // configure how to read the XML Data
            reader: new Ext.data.XmlReader({
                record: 'configuration',
                success: '@success'
            }, ['sip_bind_port', 'iax2_bind_addr', 'sip_from_domain', 'iax2_bind_port', 'http_bind_port', 'config_mode', 'sip_bind_addr', 'gw_voip_proto', 'gw_voip_host', 'gw_voip_port', 'gw_voip_username', 'gw_voip_password', 'gw_voip_register']),
            waitMsg: 'load data',
            waitMsgTarget: true,
            //errorReader: new Ext.form.XmlErrorReader(),
            style: 'margin-top:10px',
            border: false,
            buttons: [{
                xtype: 'button',
                text: 'Save settings',
                id: 'btnSubmitInterfaceSettings',
                handler: this.saveSettings,
                scope: this
            }],
            items: [{
                xtype: 'combo',
                id: 'comboInterfaceMode',
                name: 'comboInterface',
                hiddenName: 'gw_voip_proto',
                valueField: 'mode',
                store: new Ext.data.SimpleStore({
                    fields: ['mode', 'desc'],
                    data: [['SIP', 'SIP-Interface'], ['IAX2', 'IAX2-Interface']]
                }),
                displayField: 'desc',
                fieldLabel: 'Interface',
                editable: false,
                mode: 'local',
                forceSelection: true,
                triggerAction: 'all',
                emptyText: 'Select SIP/IAX Interface',
                disableKeyFilter: true,
				hideMode:'offsets',
                selectOnFocus: true
            }, {
                xtype: 'panel',
                id: 'formInterfaceSettingsPanel',
                layout: 'card',
                border: false,
                autoHeight: true,
                style: 'margin-top:10px;',
                activeItem: 0,
                items: [ // item 0
                {
                    xtype: 'panel',
                    html: '',
                    border: false
                }, // item 1 - SIP Settings
                {
                    xtype: 'panel',
                    border: false,
                    layout: 'fit',
                    items: [{
                        xtype: 'fieldset',
                        autoHeight: true,
                        title: 'Local settings',
                        items: [{
                            xtype: 'textfield',
                            fieldLabel: 'SIP address',
                            name: 'sip_bind_addr'
                        }, {
                            xtype: 'textfield',
                            fieldLabel: 'SIP port',
                            name: 'sip_bind_port'
                        }, {
                            xtype: 'textfield',
                            fieldLabel: 'SIP from-domain',
                            name: 'sip_from_domain'
                        }]
                    }]
                }, // eo item 2
                //iax2
                {
                    xtype: 'panel',
                    border: false,
                    layout: 'fit',
                    items: [{
                        xtype: 'fieldset',
                        autoHeight: true,
                        title: 'Local settings',
                        items: [{
                            xtype: 'textfield',
                            fieldLabel: 'IAX2 address',
                            name: 'iax2_bind_addr'
                        }, {
                            xtype: 'textfield',
                            fieldLabel: 'IAX2 port',
                            name: 'iax2_bind_port'
                        }]
                    }]
                } // eo item 2
]
            }, {
                id: 'fieldsetFormInterfaceSIP',
                xtype: 'fieldset',
                autoHeight: true,
                title: 'PBX server',
                items: [{
                    xtype: 'textfield',
                    name: 'gw_voip_host',
                    fieldLabel: 'Hostname'
                }, {
                    xtype: 'textfield',
                    name: 'gw_voip_port',
                    fieldLabel: 'Port'
                }, {
                    xtype: 'textfield',
                    name: 'gw_voip_username',
                    fieldLabel: 'Username'
                }, {
                    xtype: 'textfield',
                    name: 'gw_voip_password',
                    fieldLabel: 'Password',
					inputType: 'password'
                }, {
                    xtype: 'checkbox',
                    name: 'gw_voip_register',
                    hideLabel: true,
                    boxLabel: 'Registration required',
                    inputValue: 1
                }]            
            }]
        };
        
        Ext.applyIf(this, cfg);
        Ext.applyIf(this.initialConfig, cfg);
        
        //non-alterable configurables 
        cfg = {};
        Ext.apply(this, cfg);
        Ext.apply(this.initialConfig, cfg);
        
        App.ux.FormPanelVOIP.superclass.initComponent.apply(this, arguments);
        
    }, // eo function initComponent 
    onRender: function(container, position)
    {
        App.ux.FormPanelVOIP.superclass.onRender.apply(this, arguments);
        // after parent code
        // bind a few useful events to handle row selection, and context menu
        //this.on('contextmenu', this.showContextMenu, this);
        // general buttons
        
        // listener for comboInterfaceMode
        
        this.getForm().on('actioncomplete', function(form, action)
        {
            if (action.type == "load") 
            {
                var mode = Ext.getCmp('comboInterfaceMode').getValue();
                switch (mode) {
                    case 'SIP':
                        Ext.getCmp('formInterfaceSettingsPanel').getLayout().setActiveItem(1);
                        break;
                    case 'IAX2':
                        Ext.getCmp('formInterfaceSettingsPanel').getLayout().setActiveItem(2);
                        break;
                }
            }
        }, this);
        
        Ext.getCmp('comboInterfaceMode').on('select', function(combo, record)
        {
            var mode = record.data.mode; // 1 = SIP 2 = IAX				
            switch (mode) {
                case 'SIP':
                    Ext.getCmp('formInterfaceSettingsPanel').getLayout().setActiveItem(1);
                    break;
                case 'IAX2':
                    Ext.getCmp('formInterfaceSettingsPanel').getLayout().setActiveItem(2);
                    break;
            }
        }, this);
    },
    discardSettings: function()
    {
        this.getForm().reset();
    },
    saveSettings: function()
    {
        if (!this.getForm().isDirty()) 
        {
            console.log('nothing has changed');
            App.showMessage("VoIP Settings were saved successfull.");
            return true; //nothing has changed
        }
        var f = this.getForm();
        var invalidFlag = false;
        var gw_voip_proto = Ext.getCmp('comboInterfaceMode').getValue();
        switch (gw_voip_proto) {
            case 'SIP':
                // sip validation (required fields)
                var requiredFields = Array('sip_bind_addr', 'sip_bind_port', 'gw_voip_proto', 'gw_voip_host', 'gw_voip_port','gw_voip_register');
                var dataFields = Array('sip_bind_addr', 'sip_bind_port', 'sip_from_domain', 'gw_voip_proto', 'gw_voip_host', 'gw_voip_port', 'gw_voip_username', 'gw_voip_password', 'gw_voip_register');
                
                break;
            case 'IAX2':
                // validation
                var requiredFields = Array('iax2_bind_addr', 'iax2_bind_port', 'gw_voip_proto', 'gw_voip_host', 'gw_voip_port', 'gw_voip_register');
                var dataFields = Array('iax2_bind_addr', 'iax2_bind_port', 'gw_voip_proto', 'gw_voip_host', 'gw_voip_port', 'gw_voip_username', 'gw_voip_password', 'gw_voip_register');
                break;
        }
		
		// if "registration required" checkbox is checked, username is required
		var registrationRequired = f.findField('gw_voip_register').getValue();
		if(registrationRequired == true)
		{
			requiredFields.push('gw_voip_username');	
		}
		// eo registration required
		
        for (var i = 0; i < requiredFields.length; i++) 
        {
            // workaround for checkbox
            if (requiredFields[i] == 'gw_voip_register') 
                continue;
            var val = f.findField(requiredFields[i]).getValue();
            if (val == "") 
            {
                f.findField(requiredFields[i]).markInvalid('This field is required.'); // 2DO Translation
                invalidFlag = true;
            }
        }
        if (invalidFlag === true) 
        {
            return false;
        }
        var requestArr = new Array();
        for (var i = 0; i < dataFields.length; i++) 
        {
            if (f.findField(dataFields[i]).isDirty() == false) 
            {
                continue; // nothing has changed in this field
            }
            var j = requestArr.length;
            requestArr[j] = {};
            requestArr[j]['key'] = dataFields[i];
            requestArr[j]['value'] = f.findField(dataFields[i]).getValue();
        }
        if (this.sendRequestForInterfaceSettings(requestArr)) 
        {
            return true;
        }
    },
    sendRequestForInterfaceSettings: function(arr)
    {
        // 2DO wait for all calls, then put out message
        for (var i = 0; i < arr.length; i++) 
        {
            Ext.Ajax.request({
                url: '../../xml/configuration?action=update&key=' + arr[i].key + '&value=' + arr[i].value,
                method: 'GET'
            });
        }
        App.showMessage('VoIP settings were saved successfully.');
        this.getForm().load();
        return true;
    }
});
/*
 * Register xtype
 */
Ext.ComponentMgr.registerType('ux-formpanelvoip', App.ux.FormPanelVOIP); //convention is to use all lowercase for xtype
