    App.ux.GridCalls = Ext.extend(Ext.grid.GridPanel, {
        // private vars     
		runner:new Ext.util.TaskRunner(),
		updateTask:{
                run: function()
                {
                    Ext.StoreMgr.lookup('storeCalls').load({method:'GET'});
                },
                interval: 5000,
				scope:this
            },
		runnerFlag:false,
        store: new Ext.data.Store({
            storeId: 'storeCalls',
            // load using HTTP
			  proxy: new Ext.data.HttpProxy({
               url: '../../xml/calls?action=list',
                method: 'GET'
                //success: App.successFn,
                //failure:App.failureFn
            }),
            // the return will be XML, so lets set up a reader
            reader: new Ext.data.XmlReader({
                // records will have an "Item" tag
                record: 'call',
                ID: 'id',
                totalRecords: '@total'
            }, ['id', 'caller', 'callee'])
        }), // eo store
        // renderer functions
        renderActivationStatus: function(data)
        {
            switch (data) {
                case 0:
                    return "Not activated yet.";
                    break;
                case 1:
                    return '<img src="images/icons/accept.png" class="iconCell"> Activated.';
                    break;
                case 2:
                    return "Too many activations. Please contact Junghanns.NET Support!";
                    break;
                case 3:
                    return '<img src="images/icons/error.png" class="iconCell">Calls-Key is not valid.';
                    break;
            }
        },
        renderType: function(data)
        {
            console.log(data);
            if (data == "(null)") 
                return "";
            return data;
        },
        
        initComponent: function()
        {
        
            // rendering functions
            
            //default/alterable configurables 
            var cfg = {
                //title: 'Your Callss',
				 enableCtxMenu: false,
				 enableColumnHide:false,
                hideMode: 'offsets',
                selModel: new Ext.grid.RowSelectionModel({
                    singleSelect: true
                }),
                store: this.store,
                columns: [{
                    header: "call id",
                    width: 50,
                    dataIndex: 'id',
                    sortable: true
                }, {
                    header: "caller",
                    width: 100,
                    dataIndex: 'caller',
                    sortable: true
                }, {
                    header: "caller state",
                    width: 100,
                    dataIndex: 'callerstate',
                    sortable: true
                }, {
                    header: "callee",
                    width: 100,
                    dataIndex: 'callee',
                    sortable: true
                }, {
                    header: "callee state",
                    width: 100,
                    dataIndex: 'calleestate',
                    sortable: true
                }]};
            
            Ext.applyIf(this, cfg);
            Ext.applyIf(this.initialConfig, cfg);
            
            //non-alterable configurables 
            cfg = {enableColumnHide:false};
            Ext.apply(this, cfg);
            Ext.apply(this.initialConfig, cfg);
            
            App.ux.GridCalls.superclass.initComponent.apply(this, arguments);
            
        }, // eo function initComponent 
        onRender: function(container, position)
        {
            App.ux.GridCalls.superclass.onRender.apply(this, arguments);
            // after parent code
            // bind a few useful events to handle row selection, and context menu
            //this.on('contextmenu', this.showContextMenu, this);
        
            // general buttons
                    
            
        
        
        }, // end of function onRenderLayout().setActiveItem(this.step);
        startUpdater:function(){
           if(this.runnerFlag == false)
		   {
		   		this.runner.start(this.updateTask);
				    this.runnerFlag = true;
					
		   }
		},
		stopUpdater:function(){
			if(this.runnerFlag == true)
			{
				this.runner.stop(this.updateTask);
				this.runnerFlag = false;
				
				console.log('we stopped the runner');
			}
		}
		// Add Calls Key window/form
    }); // end of extend
    /*
     * Register xtype
     */
    Ext.ComponentMgr.registerType('ux-gridcalls', App.ux.GridCalls); //convention is to use all lowercase for xtype

