App.ux.GridSpans = Ext.extend(Ext.grid.GridPanel, {
        // private vars    
        
        // ===== STORE =====
        store: new Ext.data.Store({
            storeId: 'storeSpans',
            autoLoad: false,
            proxy: new Ext.data.HttpProxy({
                url: '../../xml/Spans?action=list',
                method: 'GET'
            }),
            /*listeners: {
             'beforeload': {
             fn: function(con, opt)
             {
             Ext.getBody().mask("loading...");
             }
             },
             'load': {
             fn: function(con, opt)
             {
             Ext.getBody().unmask();
             }
             }},*/
            reader: new Ext.data.XmlReader({
                record: 'span',
                id: 'spano'
            }, [{
                name: 'spanno',
                type: 'int'
            }, {
                name: 'type',
                type: 'int'
            }, {
                name: 'name',
                type: 'string'
            }, {
                name: 'description',
                type: 'string'
            }, {
                name: 'configurable',
                type: 'int'
            }, {
                name: 'active',
                type: 'int'
            }, {
                name: 'clir',
                type: 'int'
            }])
        }), // eo store
        // === GridVIEW ====
        /*
         * changes background to grey if not configurable
         */
        gridView: new Ext.grid.GridView({
            forceFit: true,
            getRowClass: function(row, index)
            {                
                var cls = '';
                var data = row.data;
                
                switch (data.configurable) {
                    case 0:
                    	cls = 'gridSpanGrey';
                    break;
                    case 1:
                        cls = 'gridSpanDefault';
                        break;
                }
                return cls;
            }
        }),
        
        // renderer functions
        renderSpanActive: function(data)
        {
            switch (data) {
                case 0:
                    return '<img src="framework/images/icons/cross.png" style="width:12px;height:12px;" class="iconCell">';
                    break;
                case 1:
                    return '<img src="framework/images/icons/accept.png" style="width:12px;height:12px;" class="iconCell">';
                    break;
            }
        },
        renderSpanType: function(data)
        {
            switch (data) {
                case 1:
                    return 'GSM';
                    break;
                case 2:
                    return 'BRI';
                    break;
                case 3:
                    return 'PRI';
                    break;
                default:
                    return '?';
                    break;
            }
        },
        // eo render functions
        
        // ======================================
        
        /*
         * init the component
         */
        initComponent: function()
        {
        
            // rendering functions
            
            //default/alterable configurables 
            var cfg = {
                //title: 'Your licenses',
                hideMode: 'offsets',
				
                selModel: new Ext.grid.RowSelectionModel({
                    singleSelect: true
                }),
                 enableCtxMenu: false,
                enableColumnHide: false,
                enableColumnMove: false,
                enableDragDrop: false,
                enableHdMenu: false,
                store: this.store,
                columns: [{
                    header: 'No.',
                    width: 30,
                    dataIndex: 'spanno',
                    sortable: 'true'
                }, {
                    header: '',
                    width: 30,
                    dataIndex: 'active',
                    renderer: this.renderSpanActive
                }, {
                    header: 'Type',
                    width: 40,
                    dataIndex: 'type',
                    sortable: true,
                    renderer: this.renderSpanType
                }, {
                    header: 'Name',
                    width: 100,
                    dataIndex: 'name',
                    sortable: true
                }, {
                    header: 'Description',
                    width: 290,
                    dataIndex: 'description',
                    sortable: true
                    //renderer:this.renderActivationStatus
                }         
				/*{
                 header: 'Conf.',
                 width: 30,
                 dataIndex: 'configurable'
                 }*/
                ]
            };
            
            Ext.applyIf(this, cfg);
            Ext.applyIf(this.initialConfig, cfg);
            
            //non-alterable configurables 
            cfg = {
                view: this.gridView,
				 enableColumnHide:false
            };
            Ext.apply(this, cfg);
            Ext.apply(this.initialConfig, cfg);
            
            App.ux.GridSpans.superclass.initComponent.apply(this, arguments);
            
        }, // eo function initComponent 
        onRender: function(container, position)
        {
            App.ux.GridSpans.superclass.onRender.apply(this, arguments);
            // after parent code
            // bind a few useful events to handle row selection, and context menu
            //this.on('contextmenu', this.showContextMenu, this);
        
            // this.store.load();
        
            // handler for rowselect
        
        
        
            // general buttons
            /* Ext.get('btnPrev').on('click', function()
             {
             console.log('clicked prev');
             }, this);*/
        }, // end of function onRenderLayout().setActiveItem(this.step);
        showMsgSaveSettings: function(activeItem)
        {
            Ext.MessageBox.show({
                closable: false,
                icon: Ext.MessageBox.QUESTION,
                title: 'Save changes?',
                buttons: {
                    yes: 'save settings',
                    no: 'discard changes'
                },
                msg: 'There are unsaved span settings. Do you wish to save these changes?',
                fn: function(btn)
                {
                    if (btn == 'yes') 
                    {
                        Ext.getCmp(activeItem).saveSettings();
                    }
                    else 
                    {
                        Ext.getCmp(activeItem).discardSettings();
                    }
                }
            });
        }
        
        
    }); // end of extend
    /*
     * Register xtype
     */
    Ext.ComponentMgr.registerType('ux-gridspans', App.ux.GridSpans); //convention is to use all lowercase for xtype
