#!/bin/sh

PATH=/bin:/usr/bin:/sbin:/usr/sbin
. /usr/lib/libmodcgi.sh

SELF='downremover'
TITLE='$(lang de:"Downloader - Aufrumen" en:"Downloader - Removing")'
PKGCGI='/cgi-bin/pkgconf.cgi'
DOWNCGI='downloader'
BACK_BTN='$(lang de:"Zurck" en:"Back")'
NM_REMOVE='$(lang de:"Aufrumen" en:"Removing")'

cmd_button() {
local name=$1 act=$2 cmd=$3 label=$4 method=get
if [ -z $name ]; then
name="cmd"
fi
cat << EOF
<div class="btn">
<form class="btn" action="$act" method="$method">
EOF
if [ $cmd ]; then
cat << EOF
<input name="$name" value="$cmd" type="hidden">
EOF
fi
cat << EOF
<input value="$label" type="submit">
</form>
</div>
EOF
}

cgi_begin "$TITLE" extras
sec_begin "$NM_REMOVE"
if [ "$QUERY_STRING" ]; then
	eval "$QUERY_STRING"
	case $cmd in
		remove)
			echo -n "<pre>"
			/etc/init.d/rc.downloader remove
			echo "</pre>"
			cmd_button "pkg" "$PKGCGI" "$DOWNCGI" "$BACK_BTN"
			;;
		*)
			cat << EOF
<p>
$(lang de:"Falscher Parameter" en:"Wrong parameter") $cmd
</p>
EOF
			;;
		esac
else
cat << EOF
<p>
$(lang de:"Alle vom Downloader heruntergeladenen Dateien vom Zielort lschen.<br>Bitte nicht vergessen vorher die dazugehrigen Dienste zu stoppen!" en:"Removing of all by Downloader downloaded files.<br>Please do not forget to stop before all appropriate services!")
</p>
EOF
	cmd_button "" $SELF "remove" "$NM_REMOVE"
	cmd_button "pkg" "$PKGCGI" "$DOWNCGI" "$BACK_BTN"
fi
sec_end

cgi_end
