/*
   Fritz!Box Remote CAPI implementation for Linux (Fritz!Box Fon Remote CAPI).
   Copyright (C) 2009 Marco Zissen <maz@v3v.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation;

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS.
   IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) AND AUTHOR(S) BE LIABLE FOR ANY
   CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
   WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
   ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

   ALL LIABILITY, INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PATENTS,
   COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS, RELATING TO USE OF THIS
   SOFTWARE IS DISCLAIMED.
*/
#include <linux/types.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/slab.h>
#include <linux/poll.h>
#include <linux/fcntl.h>
#include <linux/skbuff.h>
#include <linux/socket.h>
#include <linux/ioctl.h>
#include <linux/file.h>
#include <linux/wait.h>
#include <linux/init.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/tcp.h>
#include <linux/moduleparam.h>
#include <linux/version.h>
#include <net/sock.h>

#include <linux/isdn/capilli.h>
#include <linux/isdn/capicmd.h>
#include <linux/isdn/capiutil.h>

#define MVERSION "0.3"
#define MCOPYRIGHT "(c) 2009"
#define MAUTHOR "Marco Zissen <maz@v3v.de>"
#define MNAME_LONG "Fritz!Box Remote CAPI over TCP"
#define MNAME "fbrcapi"
 
#define FB_CAPI_MANUF 	"AVM Berlin"
#define FB_CAPI_SERIAL 	"0004711"
#define FB_CAPI_MAJOR	2
#define FB_CAPI_MINOR	0
#define FB_MANU_MAJOR	0
#define FB_MANU_MINOR	3

#define FB_DEFAULT_HOST	"192.168.178.1"
#define FB_DEFAULT_PORT 5031
#define MAX_CONTROLLERS 10			// Normally 5. But for future use, reserve 10!

#define INTERRUPTIBLE_TIMEOUT	(HZ * 5)

struct fbrc_application
{
	struct list_head list;	
	
	__u16 applid;
	__u16 kapplid;
	
	int registered;
};

struct fbrc_session 
{
	char addr[64];
	unsigned port;
	unsigned debug;
	
	struct socket *sock;
	struct sockaddr_in sock_addr;
						
	struct capi_ctr ctrl[MAX_CONTROLLERS];		
	struct capi_profile profile; 
		
	struct list_head applications;
	int controllers;
		
	atomic_t terminate;	
	wait_queue_head_t wq;	
	int thread_id; 			
};

static inline void fbrc_schedule(struct fbrc_session *session)
{
	struct sock *sk = session->sock->sk;
	wake_up_interruptible(sk->sk_sleep);
}

int fbrc_stop_kthread(void);
int fbrc_start_kthread(void);
void fbrc_debug(int level, const char *format, ...);

int fbrc_release_socket(struct fbrc_session *session);
int fbrc_init_socket(struct fbrc_session *session);
int fbrc_send_socket(struct fbrc_session *session, unsigned char *buf, int len);

unsigned fbrc_capi_register(struct fbrc_session *session, __u16 maxb3con, __u16 maxb3blks, __u16 maxb3size, __u16 applid);
unsigned fbrc_capi_release(struct fbrc_session *session, __u16 applid);
unsigned fbrc_capi_get_profile(struct fbrc_session *session, unsigned ctrl);
unsigned fbrc_capi_send_message(struct fbrc_session *session, struct sk_buff *skb);
unsigned fbrc_capi_recv_message(struct fbrc_session *session, struct sk_buff *skb);
