/*
   Fritz!Box Remote CAPI implementation for Linux (Fritz!Box Fon Remote CAPI).
   Copyright (C) 2009 Marco Zissen <maz@v3v.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation;

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS.
   IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) AND AUTHOR(S) BE LIABLE FOR ANY
   CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
   WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
   ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

   ALL LIABILITY, INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PATENTS,
   COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS, RELATING TO USE OF THIS
   SOFTWARE IS DISCLAIMED.
*/
#include <linux/kernel.h>
#include <linux/module.h>

#include "fbrcapi.h"

int fbrc_init_socket(struct fbrc_session *session)
{		
	int ret = 0;
		
	// release socket if exist
	if(session->sock) 		
		fbrc_release_socket(session);		
		
	// create socket
	if(sock_create(AF_INET, SOCK_STREAM, 0, &session->sock) < 0)
	{
		fbrc_debug(1, "Unable to create socket!");
		session->sock = NULL;
		return -EIO;
	}

	// TODO: Hostname resolution (in kernel a little bit tricky...)	
	session->sock_addr.sin_family = AF_INET;	
	session->sock_addr.sin_addr.s_addr = in_aton(session->addr);
	session->sock_addr.sin_port = htons(session->port);	
		
	// connect
	fbrc_debug(1, "Connecting to Fritz!Box CAPI server %s:%d ...", session->addr, session->port);
	ret = session->sock->ops->connect(session->sock, (struct sockaddr*)&session->sock_addr, sizeof(struct sockaddr_in), 0);		
	if(ret < 0) {
		fbrc_debug(1, "Unable to connect (error %d)!", ret);
		fbrc_release_socket(session);
		return -EIO;
	}
	
	fbrc_debug(1, "Connected successfully!");

	// restart kthread
	if(!session->thread_id)	
		return fbrc_start_kthread();
		
	return 0;
}

int fbrc_release_socket(struct fbrc_session *session)
{	
	if(session->thread_id)
		fbrc_stop_kthread();
	
	if(session->sock)
		sock_release(session->sock);
	
	session->sock = NULL;
	
	return 0;
}

int fbrc_send_socket(struct fbrc_session *session, unsigned char *buf, int len)
{
	struct kvec iv = { buf, len };
	struct msghdr msg;
	int send_len = 0;
	
	if(!len)
	  return 0;
	
	if(session->sock == NULL)
	  return -EIO;
		
	memset(&msg, 0, sizeof(msg));
	send_len = kernel_sendmsg(session->sock, &msg, &iv, 1, len);

	if(send_len < 0)	
	{
		fbrc_debug(1, "Error: kernel_sendmsg returned %d", send_len);
		fbrc_release_socket(session);
	}
	
	return send_len;
}
