/*************************************************************************
 *
 * $RCSfile: UnoidlWordDetector.java,v $
 *
 * $Revision: 1.3 $
 *
 * last change: $Author: cedricbosdo $ $Date: 2007/11/25 20:32:26 $
 *
 * The Contents of this file are made available subject to the terms of
 * the GNU Lesser General Public License Version 2.1
 *
 * Sun Microsystems Inc., October, 2000
 *
 *
 * GNU Lesser General Public License Version 2.1
 * =============================================
 * Copyright 2000 by Sun Microsystems, Inc.
 * 901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 * 
 * The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 * Copyright: 2002 by Sun Microsystems, Inc.
 *
 * All Rights Reserved.
 *
 * Contributor(s): Cedric Bosdonnat
 *
 *
 ************************************************************************/
package org.openoffice.ide.eclipse.core.editors.syntax;

import org.eclipse.jface.text.rules.IWordDetector;

/**
 * Basic rule to detect words in the text.
 * 
 * @author cedricbosdo
 */
public class UnoidlWordDetector implements IWordDetector {
    
    /**
     * {@inheritDoc}
     */
    public boolean isWordStart(char pChar) {
        boolean isLower = pChar >= 'a' && pChar <= 'z';
        boolean isUpper = pChar >= 'A' && pChar <= 'Z';
        
        return isLower || isUpper || (pChar == '.') || (pChar == '_');
    }
    
    /**
     * {@inheritDoc}
     */
    public boolean isWordPart(char pChar) {
        return isWordStart(pChar) || (pChar >= '0' && pChar <= '9');
    }
}
