/* 
 * Copyright (C) 2008 chlauber@bnc.ch
 * 
 * GNU General Public License
 */ 
function Ch_Bnc_Asterisk() {

};

Ch_Bnc_Asterisk.prototype = new ZmZimletBase();
Ch_Bnc_Asterisk.prototype.constructor = Ch_Bnc_Asterisk;
Ch_Bnc_Asterisk.prototype.maxSMSMsgLength=158;

Ch_Bnc_Asterisk.prototype.init = function() {
	var l = this.getConfig("maxSMSLength");
	if (l) {
		this.maxSMSMsgLength = l;
		Ch_Bnc_Asterisk.prototype.maxSMSMsgLength = l;
	}
	this.jspUrl = this.getResource('asterisk.jsp');
	this.header = {"Content-Type":"application/x-www-form-urlencoded"};
};

Ch_Bnc_Asterisk.prototype.clicked = function(spanElement, contentObjText, matchContext, canvas) {
	if (this._checkPrefs()) {
		this._originate(contentObjText);
	}
};

Ch_Bnc_Asterisk.prototype.toolTipPoppedUp = function(spanElement, contentObjText, matchContext, canvas) {
	picUrl = this.getResource('phone.png');
	canvas.innerHTML =
		[ "<div style='text-align:center'>",
		  "<img src='",picUrl,"'  style='vertical-align:text-bottom;padding-right:0.4em' />",
		  this.getMessage("clickToDial")," ",
		  "<strong>",
		  contentObjText,
		  "</strong>",
		  "</div>"].join("");
};

Ch_Bnc_Asterisk.prototype.menuItemSelected = function(itemId, spanElement, contentObjText, canvas) {
	switch (itemId) {
    	case "DIALNUMBER":
    		this._createDialForm();
    	break;
    	case "DIAL":
    		this._createDialForm(this._actionSpan.textContent);
    	break;
    	case "SENDSMSTO":
    		this._createSMSForm();
        break;
    	case "SENDSMS":
    		this._createSMSForm(this._actionSpan.textContent);
        break;
    	case "NEWCONTACT":
    		this._newContact(this._actionSpan.textContent);
    	break;
    	case "INFO":
    		AjxRpc.invoke("info", this.jspUrl, this.header, new AjxCallback(this, this._showInfo));
        break;
    	case "PREFERENCES":
    		this._showPrefs();
    	break;
    	case "WEBSEARCH":
    		this._webSearch(this._actionSpan.textContent);
    	break;
    	case "GALSEARCH":
    		this._galSearch(this._actionSpan.textContent);
    	break;
    }
};

Ch_Bnc_Asterisk.prototype._newContact = function(number) {
	var defaultPhone = this.getUserProperty("defaultPhone");
	var newContact = new ZmContact(null);
	newContact.initFromPhone(this._actionObject, defaultPhone);
	AjxDispatcher.run("GetContactController").show(newContact);
};

Ch_Bnc_Asterisk.prototype._webSearch = function(number) {
	number = AjxStringUtil.urlComponentEncode(number);
	var url = this.getConfig("phonebookBaseUrl");
	var commonParams = this.getConfig("phonebookUrlCommonParams");
	var phoneParamName = this.getConfig("phonebookUrlNumberParam");
	if (commonParams != "") {
		url = url + "?" + commonParams + "&" + phoneParamName + "=" + number;
	} else {
		url = url + "?" + phoneParamName + "=" + number;
	}
	window.open(url);
};

Ch_Bnc_Asterisk.prototype._checkSMSMsgLength = function(msgBox) {
	countBox = document.getElementById('countBox');
	var length = msgBox.value.length;
	countBox.value = Math.max( (this.maxSMSMsgLength - length ), 0 );
	if ( length > this.maxSMSMsgLength ) {
		msgBox.value = msgBox.value.substring( 0, this.maxSMSMsgLength );
	}
};

Ch_Bnc_Asterisk.prototype._createSMSForm = function(to,msg) {
	if(this.getConfig("enableSMS")!="true") {
		this.displayErrorMessage(this.getMessage("msgSMSDisabled"));
		return;
	}
	var from = new String();
	if (this._checkPrefs()) {
		from=this.getUserProperty("srcPhone");
	} 
	else {
		return;
	}
	var view = new DwtComposite(this.getShell());
	var el = view.getHtmlElement();
	var div = document.createElement("div");
	var toId = Dwt.getNextId();
	var msgId = Dwt.getNextId();
	div.innerHTML =
		[ "<table><tbody>",
		  "<tr>",
		  "<td align='right'>",
		  "<label for='", toId, "'>",
		  this.getMessage("lbMobileNumber")," :</label>",
		  "<td>",
		  "<input autocomplete='off' style='width:13em' type='text' id='", toId, "' value='", to, "'/>",
		  "</td>",
		  "</tr>",
          "<tr>",
		  "<td colspan='2'>",
		  "<textarea style='width:22em;height:8em' onchange='Ch_Bnc_Asterisk.prototype._checkSMSMsgLength(this)' onblur='Ch_Bnc_Asterisk.prototype._checkSMSMsgLength(this)' onfocus='Ch_Bnc_Asterisk.prototype._checkSMSMsgLength(this)' onkeyup='Ch_Bnc_Asterisk.prototype._checkSMSMsgLength(this)' id='", msgId, "'>", msg,  "</textarea>",
		  "</td>",
		  "</tr>",
		  "<tr>",
		  "<td colspan='2'>",
		  this.getMessage("lbSMSCharsLeft")," :","<input style='width:3em;font-weight:bold;' disabled='true' type='text' id='countBox'/>",
		  "</td>",
		  "</tr></tbody></table>" ].join("");
	el.appendChild(div);

	var dialog_args = {
		title : this.getMessage("titleSendSMS"),
		view  : view
	};
	var dlg = this._createDialog(dialog_args);
	sendButton = dlg.getButton(DwtDialog.OK_BUTTON);
	sendButton.setText(this.getMessage("btnSendSMS"));
	sendButton.setImage("AstSms");
	dlg.getButton(DwtDialog.CANCEL_BUTTON).setImage("cancel");
	dlg.popup();

	if (to) {
		el = document.getElementById(msgId);
		el.select();
		el.focus();
	} else {
		el = document.getElementById(toId);
		el.select();
		el.focus();
	}

	dlg.setButtonListener(DwtDialog.OK_BUTTON,
		      new AjxListener(this, function() {
			      this._sendSMS(document.getElementById(toId).value, document.getElementById(msgId).value);
			      dlg.popdown();
			      dlg.dispose();
		      }));

	dlg.setButtonListener(DwtDialog.CANCEL_BUTTON,
		      new AjxListener(this, function() {
			      dlg.popdown();
			      dlg.dispose();
		      }));
};

Ch_Bnc_Asterisk.prototype._createDialForm = function(number) {
	var caller = new String();
	if (this._checkPrefs()) {
		caller=this.getUserProperty("srcPhone");
	} 
	else {
		return;
	}
	var view = new DwtComposite(this.getShell());
	var el = view.getHtmlElement();
	var div = document.createElement("div");
	var calleeId = Dwt.getNextId();
	var val = new String();
	if(number) {
		val=number;
	}
	div.innerHTML =
		[ "<label for='", calleeId, "'>",this.getMessage("lbNumberToDial")," : </td>",
		  "<input autocomplete='off' style='width:13em' type='text' id='", calleeId, "' value='",val,"'/>"].join("");
	el.appendChild(div);
	var title = this.getMessage("titleDial") + " " + caller;
	var dialog_args = {
		title : title ,
		view  : view
	};
	var dlg = this._createDialog(dialog_args);
	var dialButton = dlg.getButton(DwtDialog.OK_BUTTON);
	dialButton.setText(this.getMessage("btnDial"));
	dialButton.setImage("AstPhone");
	dlg.getButton(DwtDialog.CANCEL_BUTTON).setImage("cancel");
	dlg.popup();
	el = document.getElementById(calleeId);
	el.select();
	el.focus();

	dlg.setButtonListener(DwtDialog.OK_BUTTON,
		      new AjxListener(this, function() {
			      this._originate(document.getElementById(calleeId).value);
			      dlg.popdown();
			      dlg.dispose();
		      }));

	dlg.setButtonListener(DwtDialog.CANCEL_BUTTON,
		      new AjxListener(this, function() {
			      dlg.popdown();
			      dlg.dispose();
		      }));
};

Ch_Bnc_Asterisk.prototype._showInfo = function(result) {
	var obj = eval( '(' + result.text + ')' ); 
	if (obj.error) {
		this.displayErrorMessage(obj.errorMessage);
	}
	else {
		var view = new DwtComposite(this.getShell());
		var el = view.getHtmlElement();
		var div = document.createElement("div");
		var picUrl = this.getResource('asterisk.gif');
		div.innerHTML =
			[ "<div style='text-align:center'><img src='",picUrl,"'  style='vertical-align:text-bottom;padding-right:0.4em' /><strong>Asterisk PBX  Integration Zimlet</strong><br/>",
			  "Version ",obj.version,"</br>",
			  "<small>2008 <a href='http://www.bnc.ch/ch-bnc-asterisk.html'>BNC</a>, christof.lauber@bnc.ch</small><br/>",
			  "released under GPLv3</div>",
			  "<p style='text-align:center'><table style='text-align:left'>",
			  "<tr><th>Server</th>","<td>",obj.astServer,"</td></tr>",
			  "<tr><th>Protocol</th>","<td>",obj.astProtocol,"</td></tr>",
			  "<tr><th>Version</th>","<td><small>",obj.astVersion,"</small></td></tr>",
			  "</table></p>"].join("");
		el.appendChild(div);

		var dialog_args = {
			title : "Asterisk Info",
			view  : view,
			standardButtons : [ DwtDialog.OK_BUTTON ],
			mode: DwtBaseDialog.MODELESS
		};
		var dlg = this._createDialog(dialog_args);
		dlg.popup();
	}
};

Ch_Bnc_Asterisk.prototype._showPrefs = function () {
	if (this._dlg_propertyEditor) {
		this._dlg_propertyEditor.dispose();
	}
	this._dlg_propertyEditor = null;
	this.createPropertyEditor();
};

Ch_Bnc_Asterisk.prototype._checkPrefs = function() {
	var srcPhone=this.getUserProperty("srcPhone");
	if (srcPhone == null) {
		this.displayStatusMessage(this.getMessage("msgSetPhoneExten")); 
		this._showPrefs();
		return false;
	}
	else {
		return true;
	}
};

Ch_Bnc_Asterisk.prototype._fixNumber = function(number) {
	// replace trailing '+' with 'idd' cause it seems that '+' is stripped by zimbra servlet
	// idd is later replaced with correct iddPrefix in jsp
	number = number.replace(/\+/,"idd");
	// remove spaces
	number = number.replace(/\s/g,"");
	return number;
};

Ch_Bnc_Asterisk.prototype._originate = function (callee) {
	callee = new String(callee);
	this.displayStatusMessage(this.getMessage("msgPickUpPhoneToCall") + " " + callee);
	callee = this._fixNumber(callee);
	callee = AjxStringUtil.urlComponentEncode(callee);
	var params = 'callee=' + callee;
	AjxRpc.invoke(params, this.jspUrl, this.header, new AjxCallback(this, this._displayDialResultCallback));
};

Ch_Bnc_Asterisk.prototype._sendSMS = function (to, msg) {
	to = new String(to);
	to = this._fixNumber(to);
	to = AjxStringUtil.urlComponentEncode(to);
	msg = AjxStringUtil.urlComponentEncode(msg);
	var params = 'to=' + to + '&msg=' + msg;
	AjxRpc.invoke(params, this.jspUrl, this.header, new AjxCallback(this, this._displaySMSResultCallback),false);
};

Ch_Bnc_Asterisk.prototype._displaySMSResultCallback = function(result) {
	var obj = eval( '(' + result.text + ')' ); 
	if (obj.error) {
		this.displayErrorMessage(obj.errorMessage);
	}
	else {
		msg=this.getMessage("msgSendingSMSTo") + " "  + obj.smsRecipient;
		this.displayStatusMessage(msg);
	}
};

Ch_Bnc_Asterisk.prototype._displayDialResultCallback = function(result) {
	var obj = eval( '(' + result.text + ')' ); 
	if (obj.error) {
		this.displayErrorMessage(obj.errorMessage);
	}
	else {
		if (obj.originateSuccess) {
			msg=this.getMessage("msgSuccessfullyDialed") + " " + obj.callee;
			this.displayStatusMessage(msg);
		}
		else if(obj.extenStateWarning) {
			msg=this.getMessage("msgFailedToDial") + " " + obj.callee;
			msg=msg +"<br/><em>" + this._getExtenStateMsg(obj.extenState) +"</em>";
			appCtxt.setStatusMsg({ msg: msg, level: ZmStatusView.LEVEL_WARNING});
		}
		else {
			msg=this.getMessage("msgFailedToDial") + " " + obj.callee;
			appCtxt.setStatusMsg({ msg: msg, level: ZmStatusView.LEVEL_WARNING});
		}
	}
};

Ch_Bnc_Asterisk.prototype._getExtenStateMsg = function(extenState) {
	var msg="unknown";
	/* Asterisk Extension States
	 * -1 = Extension not found
	 * 0 = Idle
	 * 1 = In Use
	 * 2 = Busy
	 * 4 = Unavailable
	 * 8 = Ringing
	 * 16 = On Hold
	 * see http://www.voip-info.org/wiki/view/Asterisk+Manager+API+Action+ExtensionState
	 */
	switch(extenState) {
	case -1:
		msg=this.getMessage("msgExtenNotFound");
		break;
	case 0:
		msg="idle";
		break;
	case 1:
		msg=this.getMessage("msgExtenInUse");
		break;
	case 2:
		msg=this.getMessage("msgExtenBusy");
		break;
	case 4:
		msg=this.getMessage("msgExtenUnavailable");
		break;
	case 8:
		msg=this.getMessage("msgExtenRinging");
		break;
	case 16:
		msg=this.getMessage("msgExtenOnHold");
		break;
	}
	return msg;
};
