<%-- 
	Asterisk Zimlet uses Asterisk Manager Interface for easy calling phone numbers out of ZCS
	
	Copyright (C) 2008 chlauber@bnc.ch
	
	This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

 --%>
<%@ taglib prefix="z" uri="/WEB-INF/zimbra.tld"%>
<%@ page language="java" import="java.lang.*,java.io.*,java.util.*,javax.servlet.http .*,java.net.*,java.security.*,javax.mail.*,javax.mail.internet.*"%>
<%@ page language="java" import="org.asteriskjava.*,org.asteriskjava.manager.*,org.asteriskjava.manager.action.*,org.asteriskjava.manager.response.*"%>
<%@ page language="java" import="com.zimbra.common.util.*,com.zimbra.cs.mailbox.*,com.zimbra.cs.mime.*,com.zimbra.cs.account.*,com.zimbra.common.service.*,com.zimbra.cs.service.*,com.zimbra.cs.service.util.*,com.zimbra.cs.util.*"%>
<%@ page language="java" import="org.json.*"%>
<%@ page contentType="text/plain; charset=UTF-8" %>
<%@ page pageEncoding="UTF-8" %>

<%@page import="org.asteriskjava.manager.event.OriginateResponseEvent"%>
<%@page import="org.asteriskjava.manager.event.ResponseEvent"%>

<%@page import="org.asteriskjava.util.AstUtil"%>
<z:zimletconfig var="config" action="list" zimlet="ch_bnc_asterisk"/>
<z:property var="userProperties" action="list" zimlet="ch_bnc_asterisk"/>

<%!
final int MAX_NUMBER_LENGHT=32;
final String VERSION="0.65";

// attribute names used in response JSON object
final String JSONErrorMessage="errorMessage";
final String JSONErrorBool="error";
final String JSONAstProtocol="astProtocol";
final String JSONAstVersion="astVersion";
final String JSONAstServer="astServer";
final String JSONExtenState="extenState";
final String JSONExtenStateWarning="extenStateWarning";
final String JSONOrignateSuccess="originateSuccess";
final String JSONSmsRecipient="smsRecipient";
final String JSONCallee="callee";
final String JSONVersion="version";

// config strings
private String astManagerIp;
private String astManagerPort;
private String astManagerUser;
private String astManagerSecret;
private String astDialContext;
private String astDialChannelType;
private String astActionTimeout;
private String astNoExtenCheck;
private String srcPhonePrefix;
private String calleePrefix;
private String numberCleanRegExp;
private String iddPrefix;
private String enableSMS;
private String astSMSSendContext;
private String astSMSCenterChannel;
private String astSMSVariable;
private String maxSMSLength;
private String srcPhone;
private boolean copySMSSentEmail;

// the object that contains the response JSON attributes for the GUI
private JSONObject responseObj;

// other member vars
private ManagerConnection astManagerConnection;
private Account account;
private Log zimletLog;
private long timeout;

/**
 * Called by JSP container on init. Do some initalization here. We can not get
 * zimlet config here, cause there is no HttpServletRequest yet.
 */
public void jspInit() {
	zimletLog = LogFactory.getLog("zimbra.zimlet");
	this.responseObj = new JSONObject();
}

/**
 * Get the zimlet config values and save them in local vars
 */
private void getZConfig(HttpServletRequest request) {
    Map zConfig = (Map)request.getAttribute("config");
    Map zUserProps = (Map)request.getAttribute("userProperties");
    if(zConfig !=null) {
    	zimletLog.debug("Getting ch_bnc_asterisk host config");
    	zimletLog.debug(zConfig.toString());
		astManagerIp = this.getZConfigAttribute(zConfig,"astManagerIp");
		astManagerPort = this.getZConfigAttribute(zConfig,"astManagerPort");
		astManagerUser = this.getZConfigAttribute(zConfig,"astManagerUser");
		astManagerSecret = this.getZConfigAttribute(zConfig,"astManagerSecret");
		astDialContext = this.getZConfigAttribute(zConfig,"astDialContext");
		astDialChannelType = this.getZConfigAttribute(zConfig,"astDialChannelType");
		astActionTimeout = this.getZConfigAttribute(zConfig,"astActionTimeout");
		astNoExtenCheck = this.getZConfigAttribute(zConfig,"astNoExtenCheck");
		srcPhonePrefix = this.getZConfigAttribute(zConfig,"srcPhonePrefix");
		calleePrefix = this.getZConfigAttribute(zConfig,"calleePrefix");
		numberCleanRegExp = this.getZConfigAttribute(zConfig,"numberCleanRegExp");
		iddPrefix = this.getZConfigAttribute(zConfig,"iddPrefix");
		enableSMS = this.getZConfigAttribute(zConfig,"enableSMS");
		astSMSSendContext = this.getZConfigAttribute(zConfig,"astSMSSendContext");
		astSMSCenterChannel = this.getZConfigAttribute(zConfig,"astSMSCenterChannel");
		astSMSVariable = this.getZConfigAttribute(zConfig,"astSMSVariable");
		maxSMSLength = this.getZConfigAttribute(zConfig,"maxSMSLength");
		
		// user prefs
		srcPhone = (String)zUserProps.get("srcPhone");
		if(astDialContext==null || astDialContext.length()<1) {
			// no global property so get user user pref
			 astDialContext = (String)zUserProps.get("userAstDialContext");
			 zimletLog.info("ch_bnc_asterisk userAstDialContext overwrites global astDialContext value: "+astDialContext);
		}
		copySMSSentEmail = new Boolean((String)zUserProps.get("copySMSSentEmail")).booleanValue();
    }
    else {
    	zimletLog.error("ch_bnc_asterisk could not get global config");
    }
}
/**
 * Get attribute from zConfig Map. Take global or local (host specific) Attribute
 */
private String getZConfigAttribute(Map zConfig, String attributeName) {
	String globalAttribute = (String) ((Map) zConfig.get("global")).get(attributeName);
	String localAttribute = (String) ((Map) zConfig.get("local")).get(attributeName);
	if (globalAttribute != null && globalAttribute.length()>0) {
		zimletLog.debug("Using global config attribute '" + attributeName + "' value '" + globalAttribute + "'");
		return globalAttribute;
	}
	else {
		zimletLog.debug("Using local config attribute '" + attributeName + "' value '" + localAttribute + "'");
		return localAttribute;
	}
}

/**
 * Gets zimbra account data from current user
 *
 * @return account Zimbra account
 * @see com.zimbra.cs.account.Account
 */
private Account fetchAccountData(HttpServletRequest request) throws GeneralSecurityException, ServiceException {
	AuthToken token = null;
    try {
        token = com.zimbra.cs.service.AuthProvider.getAuthToken(request, false);
        if (token == null)
            throw new GeneralSecurityException("no auth cookie");
    } catch (AuthTokenException ate) {
        throw new GeneralSecurityException("cannot parse authtoken");
    }
    if (token.isExpired()) {
        throw new GeneralSecurityException("authtoken expired");
    }
    Provisioning prov = Provisioning.getInstance();
    Account account = prov.get(Provisioning.AccountBy.id, token.getAccountId(), token);
    if (account == null) {
    	throw new GeneralSecurityException("account not found "+token.getAccountId());
    }
	return account;
}

/**
 * Prepare that we can use an Asterisk Manager Connection. Sets private attributes, so call this function early!
 */
private void prepareAstConnection() {
	this.astManagerConnection = null;
	int port;
	try {
			port=Integer.parseInt(astManagerPort);
	}
	catch (NumberFormatException e) {
			port=5038;
			zimletLog.warn("Parse error while getting 'astManagerPort'. Using default " + port);
	}
	zimletLog.debug("astManagerIp:" + astManagerIp + " port:" + port + " user:" + astManagerUser);
	//connect to ast manager
	ManagerConnectionFactory astManagerConnectionFactory= new ManagerConnectionFactory(astManagerIp, port , astManagerUser, astManagerSecret);
	astManagerConnection = astManagerConnectionFactory.createManagerConnection();
	
	if (astActionTimeout==null) {
		zimletLog.error("Zimlet parameter 'astActionTimeout' is null. Check zimlet config! ");
		this.timeout=10;
	}
	else {
		try {
			this.timeout = Long.parseLong(astActionTimeout);
		}
		catch (NumberFormatException e) {
			zimletLog.error("Could not parse zimlet parameter 'astActionTimeout'. Check zimlet config!");
		}
	}
}

/**
 * Logoff AMI if connected and cleanup Asterisk ManagerConnection
 */
private void amiCleanUp() throws IllegalStateException {
	if (astManagerConnection.getState() == ManagerConnectionState.CONNECTED  
			|| astManagerConnection.getState() == ManagerConnectionState.RECONNECTING) {
		    zimletLog.debug("AMI logoff");
			astManagerConnection.logoff();
	}
	else {
			zimletLog.warn("AMI not logged in, so no logoff from asterisk manager.");
	}
	astManagerConnection = null;
}

/**
 * Login to  asterisk manager interface (AMI)
 *
 * @return true if login ok
 */
private boolean amiLogin() throws JSONException {
	String msg;
	boolean amiLoginOk=false;
	try {
		if (this.astManagerConnection==null) {
			msg="ManagerConnection is null";
			zimletLog.error(msg);
			this.responseObj.put(JSONErrorMessage,msg);
			this.responseObj.put(JSONErrorBool,true);
		}
		else {
			if(astManagerConnection.getState() != ManagerConnectionState.CONNECTED) {
				zimletLog.info("Do AMI login.");
				this.astManagerConnection.login("off");
			}
			ManagerConnectionState state=astManagerConnection.getState();
			int wait=0;
			while (state!=ManagerConnectionState.CONNECTED) {
				state=astManagerConnection.getState();
				wait++;
				zimletLog.info("Waiting for AMI login.");
				try {
					Thread.sleep(900);
				}
				catch (java.lang.InterruptedException ie) {
					// nothing to do
				}
				if(wait<this.timeout) {
					break;
				}
			}
			if(astManagerConnection.getState() == ManagerConnectionState.CONNECTED) {
				amiLoginOk=true;
			}
		}
		return amiLoginOk;
	}
	catch (IOException ioe) {
			msg="IO Error while connecting to asterisk server " + astManagerIp;
	}
	catch (org.asteriskjava.manager.AuthenticationFailedException authfe) {
			msg="Authentication error on login to asterisk server for user " + astManagerUser;
	}
	catch (TimeoutException te) {
			msg="Timeout on originating action";
	}
	zimletLog.error(msg);
	this.responseObj.put(JSONErrorMessage,msg);
	this.responseObj.put(JSONErrorBool,true);
	return amiLoginOk;
}

/**
 * Sends an event generation asterisk Action. Thus we are an webapp we cannot have async events.
 * Thus we set a timeout an hope we got all events...
 *
 * @param action org.asteriskjava.manager.action.EventGeneratingAction
 * @return responseEvents ResponseEvents
 * @see org.asteriskjava.manager.ResponseEvents
 */
private ResponseEvents sendEventGenerationAction(EventGeneratingAction action) throws JSONException {
	String msg;
	ResponseEvents responseEvts = null;
	if(!this.amiLogin()) {
		return null;
	}
	try {
		// set timeout action response to save value that we always get the answer from asterisk
		responseEvts = this.astManagerConnection.sendEventGeneratingAction(action,this.timeout+10);
		return responseEvts;
	}
	catch (EventTimeoutException ete) {
		msg="Event Timeout. Response  maybe incomplete";
		zimletLog.debug(msg);
		// return what we have
		responseEvts = ete.getPartialResult();
		if (responseEvts!=null) {
			msg="Got incomplete events";
			zimletLog.debug(msg);
			return responseEvts;
		}
	}
	catch (IOException ioe) {
			msg="IO Error while connecting to asterisk server " + astManagerIp;
	}
	catch (TimeoutException te) {
			msg="Timeout on originating action";
	}
	catch (java.lang.IllegalArgumentException iae) {
			msg="'null' action";
	}
	zimletLog.error(msg);
	this.responseObj.put(JSONErrorMessage,msg);
	this.responseObj.put(JSONErrorBool,true);
	return null;
}

/**
 * Sends an event an asterisk Action and returns the ManagerResponse. 
 * Be aware that not all actions return ManagerResponse. Some need
 *
 * @param action org.asteriskjava.manager.action.ManagerAction
 * @return resonse ManagerResponse
 * @see org.asteriskjava.manager.response.ManagerResponse
 */
private ManagerResponse sendAction(ManagerAction action) throws JSONException {
	String msg;
	ManagerResponse response;
	if(!this.amiLogin()) {
		return null;
	}
	try {
			// set timeout action response to save value that we always get the answer from asterisk
			return this.astManagerConnection.sendAction(action,this.timeout+10);
	}
	catch (IOException ioe) {
			msg="IO Error while connecting to asterisk server " + astManagerIp;
	}
	catch (TimeoutException te) {
			msg="Timeout on originating action";
	}
	catch (java.lang.IllegalStateException ise) {
			msg="Not connected to asterisk server " +astManagerIp;
			zimletLog.debug(ise.getMessage());
	}
	catch (java.lang.IllegalArgumentException iae) {
			msg="'null' action";
	} 
	zimletLog.error(msg);
	this.responseObj.put(JSONErrorMessage,msg);
	this.responseObj.put(JSONErrorBool,true);
	return null;
}

/**
 * General function to send originate action. Sets some stuff common for dial() and sendSMS()
 * Sets error flags and message in response JSONObject
 *
 * @param action org.asteriskjava.manager.action.ManagerAction
 */
private void sendOriginateAction(OriginateAction action) throws JSONException {
	action.setPriority(new Integer(1));
	action.setTimeout(new Long(this.timeout));
	ManagerResponse response = sendAction(action);
	if (response!=null) {
		if (response.getMessage().contains("success")) {
			this.responseObj.put(JSONOrignateSuccess,true);
		}
		else {
			this.responseObj.put(JSONOrignateSuccess,false);
		}
		this.responseObj.put(JSONErrorBool,false);
	}
}

/**
 * Builds OriginateAction for dialing and does save callee 
 * in JSON response object
 *
 * @param callee the number to call for the source phone
 * @see JSONCallee
 */
private void dial(String callee) throws JSONException {
	int extenState = this.state(this.srcPhone);
	switch(extenState) {
	case AstExtenState.NO_CHECK:
	case AstExtenState.IDLE:
		zimletLog.debug("Creating orignate action for dialing");
		OriginateAction originateAction;
		originateAction = new OriginateAction();
		originateAction.setChannel(astDialChannelType+"/"+this.srcPhone);
		originateAction.setContext(astDialContext);
		originateAction.setExten(callee);
		// we tweak the caller id here to show the callee number as text, 
		// but the number part is set to the srcPhonePrefix + caller
		// for some kind of security reasons we also display the uid of the zimbra user
		// so we see who initiated the dialing
		originateAction.setCallerId(this.account.getUid() + "->" + callee + " <" + srcPhonePrefix + this.srcPhone + ">");
		sendOriginateAction(originateAction);
		this.responseObj.put(JSONCallee,callee);
		this.responseObj.put(JSONExtenStateWarning,false);
		break;
		
	case AstExtenState.BUSY:
	case AstExtenState.EXTEN_NOT_FOUND:
	case AstExtenState.IN_USE:
	case AstExtenState.ON_HOLD:
	case AstExtenState.RINGING:
	case AstExtenState.UNAVAILABLE:
		this.responseObj.put(JSONExtenStateWarning,true);
		this.responseObj.put(JSONExtenState,extenState);
		this.responseObj.put(JSONOrignateSuccess,false);
		this.responseObj.put(JSONCallee,callee);
		break;

	default:
		String msg="Unknown ExtenState";
		zimletLog.error(msg);
		this.responseObj.put(JSONErrorMessage,msg);
		this.responseObj.put(JSONErrorBool,true);
	}
}

/**
 * Builds OriginateAction for sending SMS and does save sms recipient
 * in JSON response object
 *
 * @param smsTo number of sms recipient
 * @param smsMsg the message to send
 * @see JSONSmsRecipient
 */
private void sendSMS(String smsTo, String smsMsg) throws JSONException {
	zimletLog.debug("Creating orignate action for SMS");
	OriginateAction originateAction;
	originateAction = new OriginateAction();
	originateAction.setChannel(astSMSCenterChannel);
	originateAction.setContext(astSMSSendContext);
	originateAction.setVariable(astSMSVariable,smsMsg);
	originateAction.setExten(smsTo);
	originateAction.setCallerId(this.srcPhonePrefix + this.srcPhone);
	sendOriginateAction(originateAction);
	this.responseObj.put(JSONSmsRecipient,smsTo);
	if(copySMSSentEmail && !this.responseObj.optBoolean(JSONErrorBool)) {
		this.sendSMSCopy(smsMsg, smsTo);
	}
}

/**
 * Helper method for cleaning phone number. '+' is replaced with 'idd' in asterisk.js
 * to avoid confusion with url param separator. The string 'idd' is replaced here with configured 
 * iddPrefix in zimlet config xml.
 */
private String checkNumber(String number) {
	if(number.length() < MAX_NUMBER_LENGHT && number.length() > 0) {
		// clean number
		if(this.numberCleanRegExp!=null && this.numberCleanRegExp.length()>0) {
			number=number.replaceAll(this.numberCleanRegExp,"");
		}
		// fix iddPrefix added in asterisk.js
		if ( iddPrefix.length() > 0 
				&& number.startsWith("idd")) {
			number=number.replaceFirst("idd",iddPrefix);
		}
		return number;
	}
	else {
		return "";
	}
}

/**
 * We make an action for getting info about asterisk server.
 * There is  no direct asterisk action for this, so we use a 
 * CommandAction that sends "show version" to asterisk
 * Output of "show version" and other info is copied into JSON 
 * resonse so we can display nicely in GUI
 */
private void info() throws JSONException {
	StringBuffer msg = new StringBuffer();
	CommandAction commandAction = new CommandAction("show version");
	ManagerResponse response = sendAction(commandAction);
	StringBuffer versionInfo = new StringBuffer();
	if(response instanceof CommandResponse) {
		Iterator<String> msgLinesIt = ((CommandResponse)response).getResult().iterator();
		while (msgLinesIt.hasNext()) {
			versionInfo.append(msgLinesIt.next());
			versionInfo.append("<br />");
		}
		msg.append(astManagerConnection.getHostname() + ":" + astManagerConnection.getPort());
		this.responseObj.put(JSONAstVersion,versionInfo.toString());
		this.responseObj.put(JSONAstProtocol,astManagerConnection.getProtocolIdentifier());
		this.responseObj.put(JSONAstServer,msg.toString());
		this.responseObj.put(JSONVersion,VERSION);
		this.responseObj.put(JSONErrorBool, false);
	}
}

/**
 * Sends asterisk action for getting phone/extension state. Used to check if phone is busy.
 * 
 * @return state Int of state. class AstExtenState defines constants ints
 * @see AstExtenState
 */
private int state(String exten) throws JSONException {
	 zimletLog.debug("Checking Extension state");
	 if (Boolean.valueOf(astNoExtenCheck).booleanValue()) {
		 zimletLog.debug("Checking Extension state skipped due to global config property 'astNoExtenCheck'");
		 return AstExtenState.NO_CHECK;
	}
	ExtensionStateAction extenStateAction = new ExtensionStateAction();
	extenStateAction.setContext(this.astDialContext);
	extenStateAction.setExten(exten);
	ManagerResponse response = sendAction(extenStateAction);
	if(response instanceof ExtensionStateResponse) {
		ExtensionStateResponse state = (ExtensionStateResponse)response;
		return state.getStatus();
	}
	else {
		return -1;
	}
}

private void sendSMSCopy(String msg, String to)  {
	// set us as rcpt
	try {
		InternetAddress from = new InternetAddress("\"" + this.srcPhonePrefix + this.srcPhone +"\" <" + this.account.getUnicodeName()+ ">");
		InternetAddress rcpt = new InternetAddress("\"Phone " + to  + "\" <" + to + "@" + this.astManagerIp  + ">");
		// create a mimeMessage
		javax.mail.internet.MimeMessage mimeMsg = new javax.mail.internet.MimeMessage(JMSession.getSession());
		mimeMsg.setRecipient(javax.mail.Message.RecipientType.TO, rcpt); 
		mimeMsg.setFrom(from);
		mimeMsg.setSubject("SMS Message to " + to);
		mimeMsg.setText(msg);
		// make it a ParsedMessage
		ParsedMessage pm = new ParsedMessage(mimeMsg,false);
		// sent folder id
		Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(this.account.getId());
		com.zimbra.cs.account.Identity defaultIdentity = Provisioning.getInstance().getDefaultIdentity(this.account);
		int sFolderId=MailSender.getSentFolderId(mbox,defaultIdentity);
		// add msg to sent
		Mailbox.OperationContext ctxt = new Mailbox.OperationContext(mbox);
		mbox.addMessage(ctxt, pm, sFolderId, true, Flag.FLAG_IS_MESSAGE_ONLY , null);
	}
	catch (AddressException ae) {
		zimletLog.debug("sendSMSCopy EmailAdress invalid "+ae.getMessage());
	}
	catch (MessagingException me) {
		zimletLog.debug("Could not send SMSCopy: " + me.getMessage());
	}
	catch (ServiceException se) {
		zimletLog.debug("Could not send SMSCopy: " + se.getMessage());
	}
	catch (IOException ioe) {
		zimletLog.debug("Could not send SMSCopy" + ioe.getMessage());
	}
}

/**
 * Kind of main function that dispaches the request parameters
 *
 * Handles Exceptions and fills error in JSON response object,  so we 
 * can display error box and messaes in GUI.
 */
private void handleRequest(HttpServletRequest request) throws JSONException {
	try {
		// set account
		this.account = this.fetchAccountData(request);

		String msg="handleRequest ok";
		String callee;
		String smsFrom;
		String smsTo;
		String smsMsg;
		String info;
		//handle request params
		callee = request.getParameter("callee");
		smsTo = request.getParameter("to");
		smsMsg = request.getParameter("msg");
		info = request.getParameter("info");
		zimletLog.debug("Encoding: " + request.getCharacterEncoding());
		zimletLog.debug("URL Params:\n"
						+" info: " + info
						+" callee: " + callee
						+" smsTo: " + smsTo
						+" smsMsg:\n " + smsMsg);
		if (callee!=null) {
			if(this.calleePrefix!=null && this.calleePrefix.length()>0) {
				callee = this.calleePrefix.concat(callee);
			}
			callee=checkNumber(callee);
			if( callee.length() > 0 ) {
				zimletLog.info("ch_bnc_asterisk callee:" + callee);
				dial(callee);
			}
			else {
				msg="Phone number empty or too long!";
			}
		}
		else if( smsTo!=null && smsMsg!=null ) {
			if (!Boolean.valueOf(enableSMS).booleanValue()) {
				msg ="SMS function administratively disabled";
				this.responseObj.put(JSONErrorMessage,msg);
				this.responseObj.put(JSONErrorBool,true);
			}
			else {
				zimletLog.debug("Param smsMsg: " + smsMsg);
				smsTo=checkNumber(smsTo);
				if( smsTo.length() > 0) {
					if(smsMsg.length() > 0) {
						int smsMaxLength;
						try {
							smsMaxLength = Integer.parseInt(maxSMSLength);
							if(smsMsg.length() > smsMaxLength) {
								smsMsg=smsMsg.substring(0,smsMaxLength);
								zimletLog.warn("SMS Message too long, shortened to " + smsMaxLength + "chars");
							}
						}
						catch (NumberFormatException e) {
							msg="Could not parse zimlet parameter 'maxSMSLength'. Check zimlet config!";
							zimletLog.error(msg);
							this.responseObj.put(JSONErrorMessage,msg);
							this.responseObj.put(JSONErrorBool,true);
						}
						zimletLog.info("ch_bnc_asterisk SMS from:" + this.srcPhone + "smsTo: " + smsTo + " smsMsg: " + smsMsg);
						sendSMS(smsTo,smsMsg);
					}
				}
				else {
					msg="Phone number empty or too long!";
					this.responseObj.put(JSONErrorMessage,msg);
					this.responseObj.put(JSONErrorBool,true);
				}
			}
		}
		else if (info!=null){
			info();
		}
		else {
			msg="At least one required request param is null";
			this.responseObj.put(JSONErrorMessage,msg);
			this.responseObj.put(JSONErrorBool,true);
		}
		zimletLog.debug(msg);
	}
	catch (GeneralSecurityException gse) {
		zimletLog.error(gse.toString());
		this.responseObj.put(JSONErrorMessage,gse.getMessage());
		this.responseObj.put(JSONErrorBool,true);
	}
	catch (ServiceException se) {
		zimletLog.error(se.toString());
		this.responseObj.put(JSONErrorMessage,se.getMessage());
		this.responseObj.put(JSONErrorBool,true);
		
	}
}
/**
* Simple class that holds constants for ExtenStateAction results
* @see http://www.voip-info.org/wiki/view/Asterisk+Manager+API+Action+ExtensionState
*/
class AstExtenState {
	public static final int  EXTEN_NOT_FOUND = -1;
	public static final int  IDLE = 0;
	public static final int  IN_USE = 1;
	public static final int  BUSY = 2;
	public static final int  UNAVAILABLE = 4;
	public static final int  RINGING = 8;
	public static final int  ON_HOLD = 16;
	public static final int  NO_CHECK = Integer.MAX_VALUE;
}

%>
<%
try {
	// some needed stuff first
	getZConfig(request);
	prepareAstConnection();
	// the main work is done here
	handleRequest(request);
}
catch (Exception e) {
	this.responseObj.put(JSONErrorBool,true);
	this.responseObj.put(JSONErrorMessage,"Exception occured. Check Zimbra maildboxd log for debugging!");
	this.responseObj.write(out);
	out.flush();
	throw e;
}
//after handleRequest() the JSON responseObj should be filled with necessary attributes for the GUI
this.responseObj.write(out);
out.flush();
zimletLog.debug(responseObj);
// cleanup AMI connection
amiCleanUp();
%>