package provide wylib 0.30	;#Oct 2001
#Misc functions grouped here because they require context variables to be
#stored in a namespace, but they don't really justify their own namespace
#------------------------------------------
# Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:
# 
# Free Software Foundation, Inc.
# 51 Franklin Street, Fifth Floor
# Boston, MA  02110-1301, USA

#TODO:
#- Clear scratch has "ati" in it
#- incorporate more of the app main loop in function calls
#- 

namespace eval lib {
    namespace export cwatch cnorm cfig cwait
    variable cursor
    set cursor(lastwin) 	{}
    set cfig(email)     	{/usr/bin/thunderbird -remote 'mailto(%s)'}
    set cfig(phonemap)		{}
}

#Return library configuration information
#------------------------------------------
proc lib::cfig {idx} {
    variable cfig
    if {[info exists cfig($idx)]} {return $cfig($idx)} else {return {}}
}

# Make a dialable phone number considering local prefixes
#------------------------------------------
proc lib::phonemap {num} {
    variable cfig
    if {$cfig(phonemap) != {} && [file exists $cfig(phonemap)]} {return "[exec $cfig(phonemap) $num]"} else {return $num}
}

#Change the cursor to a watch, update & change it back (newer version of cwatch)
#------------------------------------------
proc lib::cwait {w} {
    variable cfig
    if {[catch {set cur_cursor [$w cget cursor]}]} {set cur_cursor top_left_arrow}
#puts "cwatch w:$w"
    $w configure -cursor watch
#puts " mapped $w:[winfo ismapped $w]"
    if {[winfo ismapped $w]} {update idletasks}	;#bad to update before toplevel is constructed (on initial launch)
    $w configure -cursor $cur_cursor
}

#Change the cursor to a watch and save the current cursor (depricated)
#------------------------------------------
proc lib::cwatch {w} {
    variable cursor
    variable cfig
    if {[catch {set cur_cursor [$w cget cursor]}]} {set cur_cursor top_left_arrow}
#puts "cwatch w:$w"
    $w configure -cursor watch
#puts "mapped $w:[winfo ismapped $w]"

#Let's give up on update for now, it also causes dbs to leave a ghost window
#If we need to put this back, we need a way to have dbs/dbp suppress cwatch call
#    if {[winfo ismapped $w]} {update idletasks}	;#bad to update before toplevel is constructed (on initial launch)

    set cursor($w) $cur_cursor
    set cursor(lastwin) $w
    return $cur_cursor
}

#Restore the cursor from a cursor_watch call (depricated)
#------------------------------------------
proc lib::cnorm {{w {}}} {
    variable cursor
    if {$w == {} && [info exists cursor(lastwin)]} {set w $cursor(lastwin)}
    if {$w == {}} return
#puts " cnorm: w:$w $cursor($w)"
    $w configure -cursor $cursor($w)
    return $cursor($w)
}

# Startup the standard interactive email client to send mail to a list of people
#------------------------------------------
proc lib::email {to args} {
    variable cfig
#puts "lib::email to:$to args:$args"
    argproc ca(\$s) $args {{text 0}}
    if {$to == {}} return
    if {$ca(text)} {
        if {[dia::query "Subject:" subject 0 OK Cancel] < 0} {return 0}
        if {![edwin::edwin .email_msg -dest message -abort Cancel -commit {Send Message} -wait yes -insert end -title {Please edit the email message}]} {return 0}
        set fp [open "|/bin/mail -c \"\" -s \"$subject\" $to" r+]
        puts $fp $message
        close $fp
    } else {
        system [format $cfig(email) $to]
    }
}

# Send a text email to someone, possibly with an embedded application launch link
#------------------------------------------
proc lib::mail_to {uname msg args} {
    variable cfig

    argproc ca(\$s) $args {{subject {Auto mail}} {editmsg 0} {copy {}} {launch {}} {ldesc {}} {tdesc {Text Message}}}

    if {$ca(editmsg)} {
        if {![edwin::edwin .mail_to_msg -init yes -dest msg -abort Cancel -commit {Send Message} -wait yes -insert end -title {Please edit the email message}]} {return 0}
    }
    if {$ca(launch) == {}} {		;#if simple mail, send it
#puts "|/bin/mail -c \"$ca(copy)\" -s \"$ca(subject)\" $uname"
        set fp [open "|/bin/mail -c \"$ca(copy)\" -s \"$ca(subject)\" $uname" r+]
        puts $fp $msg
        close $fp
        return 1
    }
    set tfile $cfig(workdir)/tfile.tmp;	write_file $tfile $msg
    set lfile $cfig(workdir)/lfile.tmp;	write_file $lfile $ca(launch)
    if {$ca(ldesc) == {}} {set ca(ldesc) "Execute: [lindex $ca(launch) 0]"}
    set metacmd "/usr/bin/metasend -b -t \"$uname\" -t \"$ca(copy)\" -s \"$ca(subject)\" -S 10000000 -F \"[id user]\" -f $tfile -e 7bit -m text/plain -D \"$ca(tdesc)\" -n -f $lfile -e 7bit -m application/x-applaunch -D \"$ca(ldesc)\""
#puts "metacmd:$metacmd"
    if {[system "$metacmd"]} {dia::err "Sending email: $metacmd"; return 0}
    file delete $tfile $lfile
    return 1
}

if {[info commands locawyze] != {}} {locawyze lib}
