package provide wylib 0.30	;#Oct 2001
#Bring up a listbox with multiple items to choose from
#The choice in process shows up in an entry at the bottom
#------------------------------------------
# Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:
# 
# Free Software Foundation, Inc.
# 51 Franklin Street, Fifth Floor
# Boston, MA  02110-1301, USA

#TODO:
#X- handle either forced or free-form selection menu
#- 

#option add *Scm*Label.font {Helvetica 12 bold} widgetDefault
#option add *Scm*Listbox.font {Courier 12} widgetDefault
#option add *Scm*Mlb.borderWidth 10 widgetDefault
#option add *Scm*Mlb.height 15 widgetDefault
option add *Scm.title {Select:} widgetDefault
option add *Scm.compl 1 widgetDefault

namespace eval scm {
    namespace export scm dia
    variable cfig		;#keep configuration options
    variable v			;#values in process

    set cfig(swar) {{list 2} {eargs 2} {eval 2} {force 2} {title 2} {token 2} {stok 1} {post 2} {initialize 2} {sort 2} {complete 2 compl}}
}

# When a key is pressed, search for matching entries in the list
#------------------------------------------
proc scm::key_proc {w {key {}}} {
    variable cfig
    variable v

    set srch [$w.e get]
#puts "w:$w key:$key: srch:$srch: compl:$cfig(compl$w)"
    if {![string is print -strict $key]} return
    if {!$cfig(compl$w) || $srch == {}} return
    if {$cfig(token$w) == {}} {set ctok [lindex [$w.lb tags] 0]} else {set ctok $cfig(token$w)}
    set len [[set tlb [[set lb $w.lb] column $ctok w]] size]
#puts "  Completion token:$ctok lb:$lb tlb:$tlb"
    $lb selection clear 0 end
    for {set i 0} {$i < $len} {incr i} {
        if {$cfig(token$w) == {}} {set s [$lb get $i]} else {set s [$tlb get $i]}
#puts "  s:$s"
        if {[regexp -nocase -- "^$srch" $s]} {
#puts "  line:$i s:$s e:$srch"
            $w.e set $s
            $w.e entry selection range [string length $srch] end
            $lb mark $i
            $lb see $i
            break  
        }
    }
}

# Get the selected value (usually just the value of the entry)
#------------------------------------------
proc scm::get {w} {
    variable cfig
#puts "get w:$w"
    if {$cfig(force$w)} {
        if {[set i [lindex [$w.lb mark ?] 0]] == {}} {set i 0}
#puts "  i:$i token:$cfig(token$w)"
        if {$cfig(token$w) == {}} {
            set s [$w.lb get $i]
        } else {
            set tlb [$w.lb column $cfig(token$w) w]
#puts "  tlb:$tlb"
            set s [$tlb get $i]
        }
        return $s
    } else {
        return [$w.e get]
    }
}

# Get the appropriate token from a line
#------------------------------------------
proc scm::token {w args} {
    variable cfig
#puts "$w token:$cfig(token$w) args:$args [$w.lb tags]"
    if {$cfig(token$w) == {}} {return $args}
    if {[set idx [lsearch -exact [$w.lb tags] $cfig(token$w)]] < 0} {return {}}
#puts "idx:$idx:$args:[lindex $args $idx]:"
    return [lindex $args $idx]
}

# Get selected item in the listbox and load it into the entry field
#------------------------------------------
proc scm::select {w} {
    variable v
    set rows [$w.lb get]
#puts "select:$w rows:$rows"
    $w.e set [eval token $w [lindex $rows 0]]	;#if multiple select, use first row only
}

# Load the listbox with its values (which may be regenerated by expr)
#------------------------------------------
proc scm::initialize {w} {
    variable cfig
    variable v

    if {$cfig(eval$w) != {}} {		;#get list from a scriptlet
#puts "init:$cfig(eval$w)"
        $w.lb configure -data [eval $cfig(eval$w)]
    }
    $w.lb initialize
}

# Get configuration for widget
#------------------------------------------
proc scm::cget {w option} {
    variable cfig
    argnorm $cfig(swar) option
    set opt [string trimleft $option -]
#puts "cget w:$w option:$option opt:$opt"
    set cfig(title$w) [$w.t cget -text]	;#in case it changed
    if {[lcontain {token eval force title} $opt]} {return $cfig($opt$w)}
    return [eval _$w cget $option]
}

# Configure an existing widget
#------------------------------------------
proc scm::configure {w args} {
    variable cfig
    if {$args == {}} {return [_$w configure]}
    argnorm $cfig(swar) args
    foreach s {token eval force title} {xswitch $s args cfig($s$w)}
    $w.lb column $cfig(token$w) title configure -bg lightblue
    if {$args != {}} {eval _$w configure $args}
    return {}
}

# Make multiple choice select box for choosing from a list of values
#------------------------------------------
proc scm::scm {w args} {
    variable cfig
    variable v

#    argform {} args
    argnorm $cfig(swar) args
#puts "scm::scm $w $args"
    array unset cfig *$w
    array set cfig [list force$w no stok$w 1 eargs$w {}]
    foreach s {expr token eval post sort} {set cfig($s$w) [xswitchs $s args]}
    foreach s {force stok} {xswitchs $s args cfig($s$w)}
    while {[set x [xswitch eargs args]] != {}} {append cfig(eargs$w) { } $x}
    
    catch {destroy $w}
    wframe::_frame $w -class Scm
    widginit $w scm *$w
    swores $w args cfig(%s$w) {title compl}

    eval dew::dew $w.e ent -title \$cfig(title$w) -textv scm::v(result$w) $cfig(eargs$w)
    set cfig(textv$w) [$w.e cget -textv]
    pack $w.e -side top -fill x

    bind [set ent [$w.e ent w]] <Key> "after idle {scm::key_proc $w %A}"	;#so char is entered before key_proc called
#    bindtags $ent "$w Entry $ent all"			;#another way to do it without after, but messes up Ok event below
    bind $w.e <<Ok>> "event generate $w <<Ok>>"
#puts "bindtags:[bindtags $ent]"

    eval mlb::mlb $w.lb -min 200 $args
    pack $w.lb -side top -fill both -exp 1

    $w.lb bind <ButtonRelease-1> "+scm::select $w"
#    $w.lb bind <Double-1> {event generate [winfo parent %W] <Return>}	;#not sure if this is the best way to tell dia we are done.  Hope this is harmless if not used under a dia
    $w.lb bind <Double-1> "event generate $w <<Ok>>"	;#the user says OK
    
    if {$cfig(token$w) != {}} {$w.lb column $cfig(token$w) title configure -bg lightblue}
    if {$cfig(sort$w) != {}} {$w.lb column $cfig(sort$w) sort}
    focus $w.e
}


# Widget command
#------------------------------------------
proc scm::wcmd {w cmd args} {
    variable cfig
    set cmd [unabbrev {{frame 2} {get 1} {set 1} {listbox 2} {entry 1} {cget 2} {initialize 2} {configure 2} {preference 3 pref} {get 1}} $cmd]
    if {[lcontain {initialize cget get configure} $cmd]} {return [eval $cmd $w $args]}
    switch -exact -- $cmd {
        {w}		{return $w}
        {listbox}	{return [eval $w.lb $args]}
        {pref}		{return [eval $w.lb pref $args]}
        {frame}		{return [eval _$w $args]}
        {get}		{return [eval get $w $args]}
        {default}	{return [eval $w.e $cmd $args]}
    }
}

# Ask for an answer in a toplevel dialog box
#------------------------------------------
proc scm::dia {args} {
    argform {message tag} args
    argnorm {{tag 2} {message 4 mess}} args
    set mess [xswitchs mess args]
    set tag scm_dia
    xswitchs tag args tag
    return [eval "dia::dia .$tag -place p -ent scm::scm -title \$mess" $args -uplevel 2]
}
