package provide wylib 0.30	;#Oct 2001
#Track current user ID
#------------------------------------------
# Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:
# 
# Free Software Foundation, Inc.
# 51 Franklin Street, Fifth Floor
# Boston, MA  02110-1301, USA


namespace eval user {
    namespace export init uid name username
    variable cfig
    variable v
    set cfig(idfield)	user_id
    set cfig(nmfield)	casual
    set cfig(usertab)	users_v_pub
}

#Get information about current user
#------------------------------------------
proc user::init {args} {
    variable v
    variable cfig
    argproc ca(\$s) $args {{exit 1}}
    set v(username) [id user]
    set v(uid) [id userid]
    lassign [sql::one "select $cfig(idfield),current_user,$cfig(nmfield) from $cfig(usertab) where $cfig(idfield) = curr_uid()" {}] uid username v(name)
#puts "uid:$uid username:$username name:$v(name)"
    if {$v(uid) != $uid || $v(username) != $username} {
        dia::err "User $v(username) not found in user database"
        if {$ca(exit)} {exit 1} else {return 0}
    }
    return 1
}

#Return information about current user
#------------------------------------------
proc user::uid {}	{if {![info exists user::v(uid)]}	init;	return $user::v(uid)}
proc user::name {}	{if {![info exists user::v(name)]}	init;	return $user::v(name)}
proc user::username {}	{if {![info exists user::v(username)]}	init;	return $user::v(username)}

if {[info commands locawyze] != {}} {locawyze user}
