package provide wylib 0.30	;#Oct 2001
#Wyattized canvas widget
#------------------------------------------
# Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:
# 
# Free Software Foundation, Inc.
# 51 Franklin Street, Fifth Floor
# Boston, MA  02110-1301, USA

#TODO:
#- implement modified function?
#- 

namespace eval ww {
    namespace export canvas
    variable cfig
    set cfig(canvas_swar) {{help 3}}
}

# Get configuration for an canvas
#------------------------------------------
proc ww::canvas_cget {w option} {
    variable cfig
    argnorm $cfig(canvas_swar) option
    switch -exact -- $option {
        -help	{return $cfig(help$w)}
    	default	{return [eval _$w cget $option]}
    }
}

# Configure an existing canvas
#------------------------------------------
proc ww::canvas_configure {w args} {
    variable cfig
    if {$args == {}} {return [_$w configure]}
    argnorm $cfig(canvas_swar) args
    foreach tag {help} {xswitchs $tag args cfig($tag$w)}
    if {$args != {}} {return [eval _$w configure $args]}
    return {}
}

#Create an canvas widget
#------------------------------------------
proc ww::canvas {w args} {
    variable cfig

    argnorm $cfig(canvas_swar) args
    foreach tag {help} {set cfig($tag$w) [xswitchs $tag args]}
    eval _canvas $w $args
    widginit $w ww *$w canvas_wcmd
    return $w
}

# Widget command
#------------------------------------------
proc ww::canvas_wcmd {w cmd args} {
    variable cfig
    switch -exact -- [unabbrev {{cget 2} {configure 4}} $cmd] {
        {w}		{return $w}
        {cget}		{return [eval canvas_cget $w $args]}
        {configure}	{return [eval canvas_configure $w $args]}
        {default}	{return [eval _$w $cmd $args]}
    }
}

rename ::canvas ::ww::_canvas	;#replace standard widget with wrapper
namespace import ww::canvas
