//Other miscellaneous C functions
// -------------------------------
/* Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 * 
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA */


#include <stdlib.h>
#include <string.h>
#include <tcl.h>

#define STRLEN	256

extern int Misc_Init(Tcl_Interp *interp);	/* run when library loaded */
extern Tcl_ObjCmdProc money;				/* actual rpn command */

// Convert a float value to a comma separated dollar amount
int money(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[])
	{
    double value;
    int i, j, len, slen, gotdigit;
    char buf1[STRLEN], buf2[STRLEN], *fmt;

    if (objc < 2 || objc > 3) {
        Tcl_WrongNumArgs(interp, 1, objv, "value <format>");
        return TCL_ERROR;
    }

    if (Tcl_GetDoubleFromObj(interp, objv[1], &value) != TCL_OK) {
        Tcl_AddErrorInfo(interp, "Can't convert numeric value");
        return TCL_ERROR;
    }
    
    if (objc > 2) {			/* if format specified */
        fmt = Tcl_GetStringFromObj(objv[2], &slen);
        snprintf(buf1,STRLEN,fmt,value);
        len = strcspn(buf1,".");	//how many digits before the decimal
    } else {
        fmt = "%#.2f";
        snprintf(buf1,STRLEN,fmt,value);
        len = strlen(buf1) - 3;		//how many digits before decimal
    }
//printf("len:%d\n",len);

    i = j = gotdigit = 0;
    while (buf1[i]) {
        if (isdigit(buf2[j++] = buf1[i++])) {gotdigit++;}
        if (gotdigit && len > 3 && !((len-1) % 3)) {buf2[j++] = ',';}
        len--;
    }
    buf2[j] = '\0';
    
    Tcl_SetObjResult(interp, Tcl_NewStringObj(buf2,-1));
    return TCL_OK;
	}

/* Initialization for this module */
/* ------------------------------------------------------------------------- */
int Misc_Init(Tcl_Interp *interp) {

//printf("Initing 0\n");
    Tcl_CreateObjCommand(interp,"money",money,(ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);

    return TCL_OK;
    }
