/* A collection of handy functions we can add to Tcl */
// -------------------------------
/* Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 * 
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301, USA */

#include <tcl.h>
#include "../Version.h"

extern int Wylib_Init(Tcl_Interp *interp);	/* run when library loaded */
//extern int Wylib_SafeInit(Tcl_Interp *interp);

/* Initialization for this module */
/* ------------------------------------------------------------------------- */
int Wylib_Init(Tcl_Interp *interp) {
    register int r;

    r = Checkline_Init(interp);
    if (r != TCL_OK) {return TCL_ERROR;}
    
    r = Rpn_Init(interp);
    if (r != TCL_OK) {return TCL_ERROR;}
    
    r = Checkpwd_Init(interp);
    if (r != TCL_OK) {return TCL_ERROR;}
    
    r = Misc_Init(interp);
    if (r != TCL_OK) {return TCL_ERROR;}
    
    Tcl_PkgProvide(interp,PACKAGE,VERSION);
    return TCL_OK;
    }

//int Wylib_SafeInit(Tcl_Interp *interp) {return Wylib_Init(interp);}	/* do we need this? */
