#A simple calculator widget
#------------------------------------------
# Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:
# 
# Free Software Foundation, Inc.
# 51 Franklin Street, Fifth Floor
# Boston, MA  02110-1301, USA

package provide wylib 0.30
#TODO:
#X- add PI and some other functions
#- 

namespace eval calc {
    namespace export calc dia
    variable cfig		;#widget configuration
    variable v			;#holds dynamic values

    set cfig(barr) {{{Sto sto {Store current value}}	{Rcl rcl {Recall stored value}}	{C clr {Clear last entry}}		{AC ac {Clear entry and current function}}}
    		    {{PI pi {The constant PI}}	{Sin sin {Sine function}}	{Cos cos {Cosine function}}	{Tan tan {Tangent}}}
    		    {{1/x inv {Compute inverse}}	{Sqrt sqrt {Square root}}	{x^2 sqr {Value squared}}	{+/- pm {Change sign}}}
    		    {{7}	{8}		{9}		{/ dv Divide}}
    		    {{4}	{5}		{6}		{* mu Multiply}}
    		    {{1}	{2}		{3}		{- mi Minus}}
    		    {{0}	{. dot}		{= eq}		{+ pl Plus}}}
}

option add *Calc.d.Entry.width 24 widgetDefault
option add *Calc.d.Entry.bd 2 widgetDefault
option add *Calc.d.Entry.justify right widgetDefault
option add *Calc.d.fill none widgetDefault
option add *Calc.d.f.width 1 widgetDefault
option add *Calc.Frame.Button.width 4 widgetDefault
option add *Calc.Frame.Button.takeFocus 0 widgetDefault
#option add *Calc.Frame.Button.font 24 widgetDefault
option add *Calc.bindret 0 widgetDefault

#Various simple function procedures
#------------------------------------------
proc calc::dot {w} {variable v; keyproc $w "."}
proc calc::pm {w} {variable v; $w set [expr -[$w get]]}
proc calc::pl {w} {func $w +}
proc calc::mi {w} {func $w -}
proc calc::dv {w} {func $w /}
proc calc::mu {w} {func $w *}

proc calc::pi {w}	{variable v; $w set [expr asin(1) * 2];		set v(nxtclr$w) 1}
proc calc::sqr {w}	{variable v; $w set [expr pow([$w get],2)];	set v(nxtclr$w) 1}
proc calc::sqrt {w}	{variable v; $w set [expr sqrt([$w get])];	set v(nxtclr$w) 1}
proc calc::inv {w}	{variable v; $w set [expr 1.00 / [$w get]];	set v(nxtclr$w) 1}
proc calc::sto {w}	{variable v; set v(mem$w) [$w get];		set v(nxtclr$w) 1}
proc calc::rcl {w}	{variable v; $w set $v(mem$w);			set v(nxtclr$w) 1}
proc calc::sin {w}	{variable v; $w set [expr sin([$w get])];	set v(nxtclr$w) 1}
proc calc::cos {w}	{variable v; $w set [expr cos([$w get])];	set v(nxtclr$w) 1}
proc calc::tan {w}	{variable v; $w set [expr tan([$w get])];	set v(nxtclr$w) 1}

#Register a binary function
#------------------------------------------
proc calc::func {w func} {
    variable v
    
    if {$v(func$w) != {} && $v(nxtclr$w) == 0} {	;#if already a function and some entry done
        eq $w			;#compute the function first
    }
    set v(func$w) $func
    set v(alu$w) [$w get]
    set v(nxtclr$w) 1		;#remember to clear on next entry
}

#Equals - compute value
#------------------------------------------
proc calc::eq {w} {
    variable v

#puts "eq func:$v(func$w) val:[$w get]"
    if {$v(func$w) == {/} && [$w get] == 0} {dia::brief {Error: Can not divide by 0}; return}
    if {$v(func$w) != {}} {
        $w set [expr (1.0 * $v(alu$w)) $v(func$w) [$w get]]
    }
    set v(func$w) {}
    set v(alu$w) {}
    set v(nxtclr$w) 1		;#remember to clear on next entry
}

#Full clear
#------------------------------------------
proc calc::ac {w} {
    variable v
    $w set		0	;#clear displayed value
    set v(alu$w)	{}	;#no stored value
    set v(func$w)	{}	;#no current function
    set v(nxtclr$w)	1	;#whether to clear on next entry
}

#Clear entry
#------------------------------------------
proc calc::clr {w} {
    variable v
    $w set [csubstr [$w get] 0 end]		;#kill last char
    if {[$w get] == {}} {$w set 0}
}

#Handle a key or a number input to the calculator
#w:	name of the widget we are updating
#key:	the keystroke
#------------------------------------------
proc calc::keyproc {w key} {
    variable cfig
    variable v
#puts "key:$key"
    if {[string first $key {+-/*}] >= 0} {		;#function keys
        func $w $key
    } elseif {[string is double -strict $key] || [lcontain {. e E} $key]} {	;#numeric keys
        if {!$v(nxtclr$w)} {
            $w append $key
        } elseif {$v(func$w) == {-}} {		;#enter a negative number
            $w set [expr 0.0 - $key]
            set v(func$w) {}
        } else {
            $w set $key
        }
        set v(nxtclr$w) 0
    } elseif {$key == {=}} {				;#equals
        eq $w
    } elseif {$key == "\b"} {				;#little clear
        clr $w
    }
}

# Get configuration 
#------------------------------------------
proc calc::cget {w option} {
    variable cfig
    argnorm $cfig(swar) option
    set opt [string trimleft $option -]
#puts "cget w:$w option:$option opt:$opt"
    if {[lcontain {title} $opt]} {return $cfig($opt$w)}
    return [eval _$w cget $option]
}

# Configure an existing widget
#------------------------------------------
proc calc::configure {w args} {
    variable cfig
    if {$args == {}} {return [_$w configure]}
    argnorm {{title 2}} args
    foreach s {title} {set cfig($s$w) [xswitch $s args]}
    if {$args != {}} {eval _$w configure $args}
    $w.t configure -text $cfig(title$w)
    set cfig(textv$w) [_$w cget -textv]		;#in case we changed it
    return {}
}

#Create an entry with calculator buttons
#------------------------------------------
proc calc::calc {w args} {
    variable cfig
    variable v

    argform {title} args
    argnorm {{frame 2 fr} {title 2} {buttons 2 bu} {bindret 2}} args
    array unset cfig *$w
    foreach s {fr bu} {
        set cfig($s$w) {}
        while {[set x [xswitch $s args]] != {}} {append cfig($s$w) { } $x}
    }
    eval wframe::_frame $w -class Calc $cfig(fr$w)
    widginit $w calc *$w
    swores $w args cfig(%s$w) {title bindret}
    
    if {$cfig(title$w) != {}} {
        label $w.t -text $cfig(title$w)
        pack $w.t -side top -anchor w
    }
    frame $w.d; pack $w.d -side top		;#display
    label $w.d.f -textv calc::v(func$w)
    eval entry $w.d.d $args
    pack $w.d.d $w.d.f -side right

    set r 1
    foreach row $cfig(barr) {
        frame $w.r$r; pack $w.r$r -side top -fill both -exp 1
        foreach but $row {
            lassign $but lab cod help
            if {$cod == {}} {		;#if a numeric key
                set cod $lab
                set cmd "calc::keyproc $w $lab"
            } else {			;#else a function
                set cmd "calc::$cod $w"
            }
            if {$help != {}} {lappend cfig(bu$w) -help $help}
            eval button $w.r$r.$cod $cfig(bu$w) -text \{$lab\} -command \{$cmd\}
            pack $w.r$r.$cod -side left -exp 1 -fill both
        }
        incr r
    }
    bind $w <FocusIn> "focus $w.d.d"
    bind $w.d.d <Key> "calc::keyproc $w %A"
    if {$cfig(bindret$w)} {			;#if binding return to =
        bind $w <Return> "calc::eq $w"
    } else {
        bind $w <Return> "event generate $w <<Ok>>"	;#else pass Ok event to anyone who cares to bind to it
    }
    bindtags $w.d.d "$w.d.d $w all"

    set v(mem$w) 0.0
    ac $w		;#clear all
}

# Widget command
#------------------------------------------
proc calc::wcmd {w cmd args} {
    variable cfig
    set cmd [unabbrev {{frame 2} {get 1} {set 1} {initialize 2 init} {entry 1} {cget 2} {configure 2}} $cmd]
    if {[lcontain {dot pm pl mi dv mu pi sqr sqrt inv sto rcl} $cmd]} {return [eval calc::$cmd $w $args]}
    if {$cmd == {key}} {return [eval keyproc $w $args]}
    switch -exact $cmd {
        {w}		{return $w}
        {get}		{return [$w.d.d get]}
        {set}		{$w.d.d delete 0 end; eval $w append $args}
        {append}	{foreach a $args {$w.d.d insert end $a}}
        {init}		{ac $w}
        {frame}		{return [eval _$w $args]}
        {entry}		{return [eval $w.d.d $args]}
        {cget}		{return [eval cget $w $args]}
        {configure}	{return [eval configure $w $args]}
        {default}	{return [eval $w.d.d $cmd $args]}
    }
}

#Allow user to edit a value using the calculator
#------------------------------------------
proc calc::dia {args} {
    variable defca

    argform {dest title} args
    argnorm {{destination 3 dest}} args

    return [eval dia::dia .calc_dia -ent calc::calc -place p -init 0 $args -uplevel 2]
}
