package provide wylib 0.30
#Database record previewer.
#This is designed to be used with dbe.  It will preview a bunch of records in
#a listbox and allow the user to select one to be edited in the dbe widget.
#------------------------------------------
# Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:
# 
# Free Software Foundation, Inc.
# 51 Franklin Street, Fifth Floor
# Boston, MA  02110-1301, USA

#TODO:
#X- search menu function
#X- old header field functions put into menus
#X- set/clear reexec in menu somewhere
#X- save configuration, geometry in prefs
#X- is pk variable obsolete?
#X- summary fields still working?
#X- do dbp side of aggregate
#X- implement formatting option in mlb
#X- do dbp side of field formatting
#X- set format defaults based on db field types
#- 
#- how to alias selected fields when dbs (multiple tables) used
#- can print function preview in a dbedit before printing?
#-   how wide to make fields?
#- 
#- do we handle multiple tables correctly
#- is canvas resized properly if -bd != 1
#- 
#LATER:
#- keep history list of queries?
#- clone current dbp to a standalone toplevel
#- 

package require [sql::wmd]
package require wyseman
option add *Dbp.*Listbox.width 200 widgetDefault
option add *Dbp.*Listbox.height 100 widgetDefault
option add *Dbp.*Canvas.width 2000 widgetDefault
option add *Dbp.*Canvas.height 2000 widgetDefault
option add *Dbp.relief raised widgetDefault
option add *Dbp.borderWidth 1 widgetDefault

namespace eval dbp {
    namespace export dbp table
    variable cfig		;#config values for each widget
    variable dbs		;#variables for each search widget
    variable v			;#variable values for each widget
    variable lq			;#keep details of latest query

    set cfig(swar) {{table 2} {master 2} {slaves 2} {menu 2} {summary 3} {primarykey 2 pkey} {ewidget 2} {execute 2} {kdelim 2} {see 2} {default 2 def} {count 2} {and 2} {load.pre 5} {exec.pre 6} {exec.pst 6} {reexecute 3 reexec} {load 2} {highlight 5} {remark 3} {selectmode 3} {display 4} {unique 2} {where 2} {preord 4} {order 3} {pstord 3} {scrollbar 3} {minimumheight 3} {map 2}}
    set cfig(sdef) {kdelim {-} menu {?} see 0 count {Count:} reexec 0 load 0 highlight lightblue remark 1 unique 0}
    set cfig(sblk) {pkey ewidget master slaves execute def and load.pre load.pre exec.pre exec.pst where preord order pstord map}
    foreach {sw} $cfig(swar) {
        if {[llength $sw] > 2} {lappend cfig(star) [lindex $sw 2]} else {lappend cfig(star) [lindex $sw 0]}
    }
    set cfig(spas) {selectmode f display summary scrollbar minimumheight}	;#fields to pass to mlb

    set cfig(all) {-text {Load All} -und 0 -com {dbp::load %w} -help {Load all records normally accessible by this preview and sort them in their default order}}
    set cfig(def) {-text {Default Load} -und 0 -com {dbp::dbs %w -auto default} -s {Default -bg orange} -help {Load records according to the program default or user default query}}
    set cfig(lby) {-text {Load Certain Records} -und 0 -com {dbp::dbs %w} -s {Loadby} -help {Open a dialog which allows you to choose certain records from the database to load into the preview}}
    set cfig(clr) {-text {Clear} -und 0 -com {dbp::clear %w} -help {Remove all records from the preview}}
    set cfig(rld) {-text {Reload} -und 0 -com {dbp::reload %w} -s {Reload -bg khaki1} -help {Load the preview again according to the same criteria as were used in the previous load}}
    set cfig(prv) {-text {Previous Record} -und 0 -com {dbp::nxtrec %w -1} -s {< -bg lightgreen -padx 2 -rep 1} -help {Execute on the record before (above) the currently marked record}}
    set cfig(sel) {-text {Current Record} -und 0 -com {dbp::nxtrec %w 0} -s {= -bg grey69 -padx 2} -help {Execute on the currently marked record}}
    set cfig(nxt) {-text {Next Record} -und 0 -com {dbp::nxtrec %w 1} -s {> -bg plum1 -padx 2 -rep 1} -help {Execute on the record after (below) the currently marked record}}
    set cfig(aex) {-text {Auto Execute} -type checkbutton -variable {dbp::cfig(reexec%w)} -s {Auto} -help {Automatically execute the selected line after each new load or reload}}
    set cfig(squ) {-text {Saved Queries:} -type cascade -s {Query -bg {light steel blue}} -post {dbp::fill_ql %w %t} -menu {menu %t.squ -postcommand {dbp::fill_ql %w %t.squ}} -help {List of previously saved queries}}

    image create bitmap cornbut -data "#define dot_width 7\n#define dot_height 7\nstatic unsigned char dot_bits[] = {\n0x08, 0x14, 0x2a, 0x55, 0x2a, 0x14, 0x08};"
}

# Fill the query list with a list of saved queries
#------------------------------------------
proc dbp::fill_ql {w m} {
#puts "fill_ql $w $m"
    variable cfig

    $m delete 1 end

    foreach rec [dbs::saved_queries $cfig(table$w)] {
        lassign $rec share tag desc
        set lab $tag
        if {$share == {pub}} {
            set lab "$tag (Public)"
        }
        $m add command -label $lab -command "dbp::dbs $w -auto \{$share $tag\}" -help $desc
    }
}

#Restore all default settings for next load
#------------------------------------------
proc dbp::setdefs {w {flds {unique table where and reexec remark see preord order pstord}}} {
    foreach sw $flds {set dbp::lq($sw$w) $dbp::cfig($sw$w)}
}

# Delete all entries in the preview
#------------------------------------------
proc dbp::clear {w args} {
    variable cfig
    $w.l init
#    if {$cfig(ewidget$w) != {}} {eval $cfig(ewidget$w) clear -prompt no -focus no}	;#sometimes you want to clear the preview and leave the entries alone?

    foreach sl $cfig(slaves$w) {                ;#clear slaves too
        if {[winfo exists $sl]} {eval $sl clear}
    }
}

#Load according to (most) defaults
#------------------------------------------
proc dbp::load {w args} {
    setdefs $w {unique table where and see reexec remark}
    eval genload $w $args
}

#Load again just like last time
#------------------------------------------
proc dbp::reload {w args} {
#puts "reload args:$args"
    setdefs $w {reexec remark}
    eval genload $w $args
}

#Low level load
#------------------------------------------
proc dbp::genload {w args} {
    variable cfig
    variable lq
    variable v

    foreach {sw} {unique table where and reexec remark see preord pstord} {xswitchs $sw args lq($sw$w)}
    if {[set ord [xswitchs order args]] != {}} {	;#if order explicitly given
        $w order {}					;#clear the widget order buttons
        set lq(order$w) $ord
    } else {
        if {[set ord [$w.l order ?]] != {}} {set lq(order$w) $ord}	;#get order from mlb buttons
    }
#puts "LQ:$lq(where$w):$lq(order$w):reexec:$cfig(reexec$w):$lq(reexec$w):"
    if {$cfig(load.pre$w) != {}} {if {![eval $cfig(load.pre$w)]} return}

#FIXME: retain select markings and yview after a load:
    set marked [$w.l mark ?]
    set selected [$w.l curselection]
#puts "selected:$selected"
    set yview [lindex [$w.l yview] 0]

    if {$lq(where$w) == {} && $lq(and$w) == {}} {
        set lq(whand$w) {}
    } elseif {$lq(where$w) == {} && $lq(and$w) != {}} {
        set lq(whand$w) "where $lq(and$w)"
    } elseif {$lq(where$w) != {} && $lq(and$w) == {}} {
        set lq(whand$w) "where $lq(where$w)"
    } else {
        set lq(whand$w) "where ($lq(and$w)) and ($lq(where$w))"
    }
    set t0 [lindex $lq(table$w) 0]		;#first table
    if {[llength $t0] <= 1} {
        set alias {}
    } else {
        lassign $t0 t0 alias
        append alias .
    }
#puts "alias:$alias"
#puts "pkey:$cfig(pkey$w):"

    lassign {} grpflds aggflds	    #Check for aggregate settings:
    set idx 0
    foreach {tg va} [$w.l aggregate func] {
        if {[set func [sumagfunc $va]] == {}} {
            lappend grpflds $tg
            lappend groupby [incr idx]
        } else {
            lappend aggflds $tg
            set agg($tg) $func
        }
    }
#puts "grpflds:$grpflds aggflds:$aggflds groupby:$groupby"

    set gby {}
    if {$aggflds == {}} {			;#if no aggregates specified
        set lq(fields) $cfig(pkey$w)		;#always query PK fields
        foreach f [$w.l display] {		;#also collect display fields
            if {![lcontain $lq(fields) $f]} {lappend lq(fields) $f}
        }
    } else {
        set lq(fields) [concat $grpflds $aggflds]
        if {[llength $groupby] > 0} {set gby "group by [join $groupby ,]"}
    }
#puts "lq(fields):$lq(fields)"

    set fields {}
    array set map $cfig(map$w)		;#load up map array
    array set fmt [$w.l format]		;#load up formatting array
    foreach tag $lq(fields) {
        set fspec $alias$tag
        if {[info exists map($tag)]} {
            regsub -all %f $map($tag) $fspec fspec
        }
        if {[info exists agg($tag)]} {
            set fspec $agg($tag)($fspec)
        }
        if {[info exists fmt($tag)]} {
            set fspec [fmtfunc $fmt($tag) $fspec]
        }
        lappend fields "$fspec as $tag"
    }
#    set fields {}; foreach tag $lq(fields$w) {lappend fields $cfig(qf$w.$tag)}

#puts "lq(order$w):$lq(order$w)"
    set ordlst {}
    foreach rec $lq(order$w) {
        lassign $rec tag ascdes
        if {![lcontain {asc desc} $ascdes]} {set ascdes {asc}}
        if {[lcontain $lq(fields) $tag]} {
            lappend ordlst [list $alias$tag $ascdes]
        } else {
            lappend ordlst "$tag $ascdes" ;# don't do a list here, it breaks tags that are really commands (called later)
        }
        #lappend ordlst [list $alias$tag $ascdes] ;# NDB - this was in a non-committed version of dbp.tcl
    }
    if {$ordlst != {}} {set order "order by [join $ordlst ,]"} else {set order {}}
#puts "order:$order"
    
    if {$lq(unique$w)} {set selmod { distinct}} else {set selmod {}}
    set lq(command$w) "select$selmod"
    set lq(target$w) "from [join $lq(table$w) {,}]"
    set lq(spec$w) "[subst "$lq(whand$w) $gby$lq(preord$w) $order $lq(pstord$w)"]"
    set query "$lq(command$w) [join $fields {,}] $lq(target$w) $lq(spec$w)"
#puts "query:$query"

    lib::cwatch [winfo toplevel $w]
    $w.l delete 0 end

# Method: list of rows (faster)
    set data [sql::qlist $query]				;#query faster (37 sec)
    eval $w.l insert end -tags \{$lq(fields)\} $data		;#insert slower (11 sec)
    set v(count$w) [llength $data]

# Method: array of columns (slower)
#set secs [clock seconds]
#    set v(count$w) [sql::qlist $query data $lq(fields)]	;#query slower (41 sec)
#    foreach f $lq(fields) {					;#insert (9 sec)
#        eval $w.l column $f insert end $data($f)
#    }
#puts "time:[expr [clock seconds] - $secs]"

    $w.l summary update			;#update summary fields
    lib::cnorm

    if {$lq(remark$w) && $marked != {}} {
        $w.l yview moveto $yview
        $w.l mark $marked		;#mark line(s) we had marked before
        foreach s $selected {$w.l selection set $s}
    } elseif {$lq(reexec$w)} {
        $w.l mark 0
    } elseif {$lq(see$w) != {}} {
        $w.l see $lq(see$w)
    }
    if {$lq(reexec$w)} {execute $w}	;#execute marked lines
    if {[info exists cfig(load.pst$w)]} {eval $cfig(load.pst$w)}

    foreach sl $cfig(slaves$w) {                ;#reload any slaves with related records
#puts "w:$w slave:$sl"                          ;# "w:[eval $sl w]"
        if {![catch {eval $sl w}]} {            ;#if the widget seems to exist
            eval $sl obey $w                    ;#try asking it to obey
        }
    }
}

#Resort data according to mlb sort buttons
#------------------------------------------
proc dbp::sort {w args} {
    variable v
#puts "resort:$w $args count:$v(count$w)"
    if {$v(count$w) <= 0} return		;#nothing to sort
    reload $w
}

#Translate a formatting function tag into a function name
#------------------------------------------
proc dbp::fmtfunc {tag value} {
    switch $tag {
        _	{return $value}
        cur	{return "comma_dollar($value)"}
        fl2	{return "($value)::numeric(14,2)"}
        fl4	{return "($value)::numeric(14,4)"}
        pe0	{return "($value * 100)::numeric(14,0)"}
        pe2	{return "($value * 100)::numeric(14,2)"}
        int	{return "($value)::int4"}
        bol	{return "norm_bool($value)"}
        dat	{return "norm_date($value)"}
        dao	{return "($value - current_date)"}
    }
    return $value
}

#Translate a summary/aggregate tag into a function name
#------------------------------------------
proc dbp::sumagfunc {tag} {
    switch $tag {
        A {return {avg}}
        S {return {sum}}
        X {return {max}}
        N {return {min}}
        C {return {count}}
    }
    return {}
}

#Update the mlb summary fields
#------------------------------------------
proc dbp::summary {w args} {
    variable cfig
    variable lq
#puts "Update:$w $args"
    array set fmt [$w.l format]		;#load up formatting array
    set fields {}
    set tags {}
    foreach {tg va} [eval $w.l summary function $args] {	;#get summary types
        set agg [sumagfunc $va]
        if {$agg == {}} {
            lappend fields {''}
        } else {
            set type [wmdd::type $cfig(table$w) $tg]
            set field "${agg}($tg)"
#puts "  tag:$tg type:$type field:$field"
            if {[info exists fmt($tg)]} {
                lappend fields [fmtfunc $fmt($tg) $field]
            } else {
                lappend fields $field
            }
        }
        lappend tags $tg
    }
    if {$fields == {} || ![info exists lq(command$w)]} {return {}}
    set query "$lq(command$w) [join $fields {,}] $lq(target$w) $lq(whand$w)"
#puts "  query:$query"

    set data [sql::one $query]
    set n 0
    set nvals {}
    foreach tg $tags {
        lappend nvals $tg [string trim [lindex $data $n]]
        incr n
    }
#puts "nvals:$nvals"
    return $nvals
}

#Return a list of selected items in the listbox
#------------------------------------------
proc dbp::keys {w {idx {}}} {
    variable cfig
    variable v

    if {$idx == {}} {			;#no line specified, so get marked lines
        set marked [$w.l mark ?]
        if {$marked == {}} {set idx 0} else {set idx $marked}
    }
    set ids {}
    set size [$w.l size]
    set selectmode [$w.l column cget -selectmode]
#puts "idx:$idx selectmode:$selectmode size:$size"
    if {[lcontain {browse single} $selectmode]} {
        $w.l mark [set idx [$w.l index $idx]]
        if {$idx >= $size} return
        lappend ids [$w.l get $idx -tags $cfig(pkey$w)]
    } else {
        $w.l mark $idx
        foreach i $idx {
            if {$i >= $size} continue
            lappend ids [$w.l get $i -tags $cfig(pkey$w)]
        }
        if {[llength $ids] <= 0} return		;#nothing left to execute
#puts "ids:$ids id:$id"
    }
    return $ids
}

#Load the data for the selected record into the entry widget
#------------------------------------------
proc dbp::execute {w {idx {}}} {
    variable cfig
    variable v

#puts "execute w:$w idx:$idx"
    if {$cfig(exec.pre$w) != {}} {if {![eval $cfig(exec.pre$w)]} return}
    if {$v(count$w) <= 0} {
        foreach ewid $cfig(ewidget$w) {eval $ewid clear -prompt no}
#        if {$cfig(ewidget$w) != {}} {eval $cfig(ewidget$w) clear -prompt no}
        return
    }
    set ids [keys $w $idx]
    set id [lindex $ids 0]
#puts "  id:$id ids:$idx execute:$cfig(execute$w) w:$w"
    regsub -all %w $cfig(execute$w) $w cmd
    if {[llength $ids] > 1} {
        set cmd "$cmd \{$ids\} \{$idx\}"
    } else {
        set cmd "$cmd \{$id\} $idx"
    }
#puts "cmd:$cmd ewidget:$cfig(ewidget$w)"
    if {$cfig(execute$w) != {}} {lib::cwatch $w.l; eval $cmd; lib::cnorm $w.l}
    foreach ewid $cfig(ewidget$w) {
#puts "$ewid load {$id}"
        eval $ewid load \$id
    }
#    if {$cfig(ewidget$w) != {}} {eval $cfig(ewidget$w) load \$id}
    eval $cfig(exec.pst$w)
    event generate $w <<Execute>>
}

#Load the next/prev record after the one selected in the listbox
#------------------------------------------
proc dbp::nxtrec {w {inc 1}} {
    variable cfig
    variable v
    set marked [$w.l mark ?]
#puts "marked:$marked"
    if {$marked == {}} {set line -1} else {set line [lindex $marked 0]}
    incr line $inc
#puts "line:$line end:[$w.l index end]"
    if {$line >= [$w.l index end] || $line < 0} {return 0}
    $w.l selection clear 0 end
    execute $w $line
    return 1
}

#Fill the toplevel dbs widget with stuff (has to be separate call for top::top to be happy)
#------------------------------------------
proc dbp::dbs_build {z dbp args} {
    top::add [eval dbs::dbs $z.f -dbp $dbp $args]
    pack $z.f -fill both -exp 1
    $z.f where bar menu mi z Close "$z close" -help {Close this search window} -hot C-w -s Close
}

#Create a toplevel window to contain the search widget
#------------------------------------------
proc dbp::dbs {w args} {
    variable cfig

    argnorm {{auto 2}} args
    if {[set auto [xswitchs auto args]] != {}} {set restore 0} else {set restore 1}

    set tag dbp_dbs_$cfig(table$w)		;#unique tag for pref saving
    set z [top::top $tag -title {Database Search} -menu 0 -build "dbp::dbs_build %w $w $args -auto {$auto}" -restore $restore -par $w]
#    if {$auto == {}} {dia::place $z}
}

# Yield/restore preferences
#------------------------------------------
proc dbp::pref {w args} {
    variable cfig
    if {[llength $args] > 0} {eval pref::restore $args; return}
    
    set parr {}
    lappend parr [eval list listbox pref [$w.l pref]]
    lappend parr [list configure -reexec $cfig(reexec$w)]
#puts "Dump $w pref:[join $parr "\n"]"
    return $parr
}

#Add an item into the main menu
#------------------------------------------
proc dbp::m_add {w tag args} {
    variable cfig
#puts "M_add w:$w tag:$tag args:$args"
    argform {text command help} args
    if {[lcontain {ord def all rld lby clr prv sel nxt aex squ} $tag]} {set args "$cfig($tag) $args"}
    regsub -all %w $args $w args
    eval $w.t menu mi $tag $args
}

# Reload the preview according to a record in a master dbe
#------------------------------------------
proc dbp::obey {w master {table {}}} {
    variable cfig
    if {$table == {}} {set table [$master cget table]}

#puts "obey table:$cfig(table$w) ftable:$table master:$master pk:[$master pk]"
    if {[$master pk] == {}} return		;#if first element of pk blank, assume no record loaded
    set wlist {}
    foreach rec [wmdd::columns_fk $cfig(table$w) $table] {
        lassign $rec cols fcols
#puts "  cols:$cols fcols:$fcols"
        set flist {}
        set i 0; foreach col $cols {
            lappend flist [list $col = [$master get [lindex $fcols $i]]]
            incr i
        }
        lappend wlist "([join $flist {) and (}])"
    }

    if {[llength $wlist] <= 0} {dia::warn "No key fields found from table $cfig(table$w) to $table"; return}
#puts "  wlist:$wlist"
    reload $w -where [join $wlist { or }]
}

# Get configuration
#------------------------------------------
proc dbp::cget {w option} {
    variable cfig
    argnorm $cfig(swar) option
    set opt [string trimleft $option -]
    if {[lcontain $cfig(star) $opt]} {return $cfig($opt$w)}
    return [eval _$w cget $option]
}

# Configure the dbp
#------------------------------------------
proc dbp::configure {w args} {
    variable cfig
    if {$args == {}} {return [_$w configure]}
    argnorm $cfig(swar) args
    foreach tag $cfig(star) {xswitch $tag args cfig($tag$w)}
    if {$args != {}} {return [eval _$w configure $args]}
    return {}
}

#Create the preview listbox window
#------------------------------------------
proc dbp::dbp {w args} {
    variable cfig
    variable v

#puts "dbp args:$args"
    argform {menu} args
    argnorm $cfig(swar) args
    set cfig(table$w) [xswitchs table args]	;#get table name
    foreach tag $cfig(sblk) {set cfig($tag$w) [xswitchs $tag args]}
    foreach {tag val} $cfig(sdef) {set cfig($tag$w) $val; xswitchs $tag args cfig($tag$w)}
    
    lassign {} margs fargs
    while {[xswitch m args va] != {}} {lappend margs -m $va}
    set gotanf 0				;#have we been given any explicit field definitions
    foreach t $cfig(spas) {			;#save fields to pass to mlb
        while {[xswitch $t args va] != {}} {
            lappend fargs -$t $va
            if {$t == {f}} {set gotanf 1}
        }
    }
#puts "fargs:$fargs"

    set ewidget [lindex $cfig(ewidget$w) 0]
    if {$cfig(table$w) == {}} {if {$ewidget != {}} {set cfig(table$w) [eval $ewidget cget -table]} else {error "No table defined"}}
    if {$cfig(pkey$w) == {}} {
        if {$ewidget != {} && $cfig(table$w) == [eval $ewidget cget -table]} {
            set cfig(pkey$w) [eval $ewidget cget -pkey]
        } elseif {[set cfig(pkey$w) [wmdd::pkey $cfig(table$w)]] == {}} {
            error "No primary key defined"
        }
    }
#puts "table:$cfig(table$w):  pkey:$cfig(pkey$w):"

    if {!$gotanf} {				;#if we didn't get any explicit field specs
        foreach rec [wmdd::columns $cfig(table$w)] {	;#add all of table's columns by default
            lassign $rec tag title help type
#puts "tag:$tag type:$type title:$title"
            set farg [list $tag $title -help "$title ($tag):\n$help"]

            if {[lcontain {date timestamp} $type]} {
                append farg { -fmt dat}
            } elseif {$type == {bool}} {
                append farg { -fmt bol}
            } elseif {$type == {numeric}} {
                append farg { -fmt cur}
            }
            if {[catch {set dargs [[sql::wmd]::$cfig(table$w) $tag]}]} {	;#if we can't get dbe default args for field,
                if {[lcontain {numeric int4 int8 float8} $type]} {		;#Right justify all numbers
                    append farg { -just r -width 40}	
                } elseif {[lcontain {boolean} $type]} {
                    append farg { -width 10}					;#set narrow for booleans
                }
            } else {				;#else use dbe default widths, justification
#puts "tag:$tag dargs:$dargs"
                argnorm {{justify 2} {size 2}} dargs
                if {[set val [xswitchs justify dargs]] != {}} {append farg " -just $val"}
                if {[set val [xswitchs size    dargs]] != {}} {
                    set length [lindex $val 0]
                    if {$length == {} || $length > 25} {set length 25}
                    if {$length < 2} {set length 2}
                    append farg " -width [expr $length * 7]"
                }
#puts "w:$w tag:$tag farg:$farg"
            }

            lappend fargs -f $farg
        }
    }
    if {$cfig(pkey$w) == {oid}} {lappend fargs -f oid}	;#if no real primary key available, use oid
#puts "Fargs:$fargs"

    if {[winfo exists $w]} {eval $w configure -class Dbp $args} else {eval wframe::_frame $w -class Dbp $args}
    widginit $w dbp *$w

    foreach i {marked srchhist tags fields} {set cfig($i$w) {}}

#puts "menu:$cfig(menu$w)"
    if {$cfig(menu$w) == {?}} {
        lassign [wmdd::table $cfig(table$w)] title help
        set cfig(menu$w) [list "$title Preview:" -help "A menu of options for previewing records from table:\n${title},\n$help"]
    }

    set v(count$w) 0				;#no records loaded yet
    set menarg {}
    if {$cfig(menu$w) != {}} {
        mbar::mbar $w.t -mb "menu $cfig(menu$w)" -gmc.bf {-fill x -exp 1}
        pack $w.t -side top -fill x
        if {$cfig(count$w) != {}} {		;#show current record count
            eval dew::dew $w.t.count ent -textv dbp::v(count$w) -just r -help \{How many records currently loaded in the preview\} -width 5 -state readonly $cfig(count$w)
            pack $w.t.count -side right
        }
        foreach {sw va} $margs {eval m_add \$w $va}	;#build menus
        $w.t menu mi sep
        $w.t menu mi find  {Find in Column}  -under 0 -command "$w column %m find" -help {Search (and possibly replace) items in only this column of the list}
        $w.t menu mi print {Print Grab} -command "print::grab $w" -help {View a printable rendering of the preview pane}
        $w.t menu add cascade -label {Column Options} -underline 4 -menu [$w.t menu w].lbm -help {Menu items associated with the display columns (also accessible by right-clicking on a column)}
        $w.t menu mi sep
        $w.t menu mi help {Widget Help}	-command {help::locate dbp.html} -help {Instructions on using the DBP (DataBase Preview) Widget}
        set menarg "-menu [$w.t menu w].lbm"
    }
    eval mlb::mlb $w.l $menarg -resort 0 -sort \"dbp::sort $w\" -calc \"dbp::summary $w\" $fargs
    pack $w.l -side top -fill both -exp 1
    bind $w.l <<Execute>> "lib::cwatch $w; update; dbp::execute $w; lib::cnorm $w"

    setdefs $w
    
#puts "w:$w master:$cfig(master$w)"
    if {$cfig(master$w) != {}} {
        after idle [list dbp::obey $w [eval $cfig(master$w) w]]		;#wait for prefs (sort order) to kick in
    } elseif {$cfig(load$w)} {		;#if you load at this point, you will also get a second load when prefs are restored
        load $w
    }
    return $w
}

#The widget command for the preview box widget
#------------------------------------------
proc dbp::wcmd {w cmd args} {
    set cmd [unabbrev {{listbox 2} {menu 2} {obey 2} {clear 2} {keys 2} {dbsearch 3 dbs} {preferences 4 pref} {previous 4 prev} {next 2} {reload 2} {configure 2} {cget 2}} $cmd]
    if {[lcontain {load dbs pref clear reload obey keys cget configure} $cmd]} {
        return [eval $cmd $w $args]
    }
    switch -exact $cmd {
        {w}		{return $w}
        {menu}		{return [eval $w.t $args]}
        {listbox}	{return [eval $w.l $args]}
        {next}		{return [eval nxtrec $w $args]}
        {prev}		{return [eval nxtrec $w -1]}
        {default}	{return [eval $w.l $cmd $args]}
    }
}

# Launch a toplevel window containing a specified dbp
#------------------------------------------
proc dbp::table {table args} {
    variable cfig
    lassign [wmdd::table $table] title
    top::top dbp_$table -title "Preview $title" -build "dbp::build %w -table $table $args" -reopen 1
}

# Build a toplevel window containing a dbp
#------------------------------------------
proc dbp::build {z args} {
    variable cfig
    top::add [eval dbp::dbp $z.p \
        -m clr -m def -m rld -m all -m prv -m sel -m nxt -m lby -m aex $args\
    ]
    pack $z.p -side top -fill both -expand yes
}

if {[info commands locawyze] != {}} {locawyze dbp}
