package provide wylib 0.30	;#Oct 2001
#A data entry widget consisting of a frame containing a label and one of:
#entry, text, checkbutton, radiobutton, etc.
#------------------------------------------
# Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:
# 
# Free Software Foundation, Inc.
# 51 Franklin Street, Fifth Floor
# Boston, MA  02110-1301, USA

#TODO:
#X- get pdm's to toggle to a value by typing the first character or two of the option
#- Move font/color to different module?
#- test fsm spf type (forced)
#- allow to supply replacement gmc or just add to existing gmc?
#- separate gmc commands for title, entry, button?
#- get widget defaults from resources  (gmc, etc.)
#- how to handle spinner switches?
#- 

namespace eval dew {
    namespace export dew align
    variable cfig
    set cfig(swar) {{spfunction 3 spf} {style 2} {title 2} {textvariable 5 textv} {data 3} {frame 2 fr} {spinner 2 spin} {auto 2}}
#Bitmap for pull-down button
    image create bitmap pull.dn -data "#define down_width 14\n#define down_height 8\nstatic unsigned char down_bits[] = {\n0xff, 0x3f, 0x03, 0x30, 0x06, 0x18, 0x0c, 0x0c, 0x18, 0x06, 0x30, 0x03, 0xe0, 0x01, 0xc0, 0x00};"

    variable scm	;#default values for scmenu widgets
    set scm(state) {-f code -f name -token code -force 1 -data {{{} Blank} {AK Alaska} {AL Alabama} {AR Arkansas} {AZ Arizona} {CA California} {CO Colorado} {CT Connecticut} {DC {Washington DC}} {DE Delaware} {FL Florida} {GA Georgia} {HI Hawaii} {IA Iowa} {ID Idaho} {IL Illinois} {IN Indiana} {KS Kansas} {KY Kentucky} {LA Louisiana} {MA Massachussetts} {MD Maryland} {ME Maine} {MI Michigan} {MN Minnesota} {MO Missouri} {MS Mississippi} {MT Montana} {NC {North Carolina}} {ND {North Dakota}} {NE {}} {NH {New Hamshire}} {NJ {New Jersey}} {NM {New Mexico}} {NV Nevada} {NY {New York}} {OH Ohio} {OK Oklahoma} {OR Oregon} {PA Pennsylvania} {PR {Puerto Rico}} {RI {Rhode Island}} {SC {South Carolina}} {SD {South Dakota}} {TN Tennesse} {TX Texas} {UT Utah} {VA Virgina} {VI {Virgin Islands}} {VT Vermont} {WA {Washington State}} {WI Wisconson} {WV {West Virginia}} {WY Wyoming}}}
    set scm(country) {-f code -f name -token code -force 1 -data {{{} Blank} {A Austria} {AFG Afghanistan} {AG Antigua and Barbuda} {AL Albania} {AND Andorra} {ANG Angola} {ARM Armenia} {AUS Australia} {AZ Azerbaijan} {B Belgium} {BD Bangladesh} {BDS Barbados} {BF Burkina Faso} {BG Bulgaria} {BH Belize} {BHT Bhutan} {BIH Bosnia-Herzegovina} {BM Bermudas} {BOL Bolivia} {BR Brazil} {BRN Bahrain} {BRU Brunei} {BS Bahamas} {BU Burundi} {BY Belarus} {C Cuba} {CAM Cameroon} {CDN Canada} {CH Switzerland} {CI Ivory Coast} {CL Sri Lanka} {CN China} {CO Columbia} {CR Costa Rica} {CV Cape Verde} {CY Cyprus} {CZ Czech Republic} {D Germany} {DJI Djibouti} {DK Denmark} {DOM Dominican Republic} {DZ Algeria} {E Spain} {EAK Kenya} {EAT Tanzania} {EAU Uganda} {EC Ecuador} {EQ Equatorial Guinea} {ER Eritrea} {ES El Salvador} {EST Estonia} {ET Egypt} {ETH Ethiopia} {F France} {FJI Fiji} {FL Lichtenstein} {FR Faroer} {G Gabon} {GB Great Britain} {GBZ Gibraltar} {GCA Guatemala} {GE Georgia} {GH Ghana} {GNB Guinea-Bissau} {GR Greece} {GUY Guyana} {H Hungary} {HA Haiti} {HK Hongkong} {HN Honduras} {HR Croatia} {I Italy} {IL Israel} {IND India} {IR Iran} {IRL Ireland (Republic)} {IRQ Iraq} {IS Iceland} {J Japan} {JA Jamaica} {JOR Jordan} {K Cambodia} {KIR Kiribati} {KO North Korea} {KS Kyrgyzstan} {KWT Kuwait} {KZ Kazakhstan} {L Luxembourg} {LAO Laos} {LAR Libya} {LB Liberia} {LS Lesotho} {LT Lithuania} {LV Lativa} {M Malta} {MA Morocco} {MAL Malaysia} {MC Monaco} {MD Moldova} {MEX Mexico} {MK Macedonia} {MNG Mongolia} {MOC Mozambique} {MS Mauritius} {MW Malawi} {MYA Myanmar} {N Norway} {NA Netherlands Antilles} {NAM Namibia} {NEP Nepal} {NIC Nicaragua} {NL Netherlands} {NZ New Zealand} {OM Oman} {P Portugal} {PA Panama} {PE Peru} {PK Pakistan} {PL Poland} {PNG Papua New Guinea} {PR Puerto Rico} {PY Paraguay} {Q Qatar} {RA Argentina} {RB Botswana} {RC Taiwan} {RCA Central African Republic} {RCB Congo} {RCH Chile} {RG Guinea} {RI Indonesia} {RIM Mauretania} {RL Lebanon} {RM Madagascar} {RMM Mali} {RN Niger} {RO Romania} {ROK South Korea} {ROU Uruguay} {RP Philippines} {RPB Benin} {RSA Republis of South Africa} {RSM San Marino} {RT Togo} {RUS Russia} {RWA Rwanda} {S Sweden} {SA Saudi Arabia} {SD Swaziland} {SF Finland} {SGP Singapore} {SK Slovakia} {SLO Slovenia} {SME Suriname} {SN Senegal} {SP Somalia} {SUD Sudan} {SY Seychelles} {SYR Syria} {THA Thailand} {TJ Tajikistan} {TM Turkmenistan} {TN Tunesia} {TR Turkey} {TT Trinidad & Tobago} {UA Ukraine} {UAE United Arab Emirates} {USA USA} {UZB Uzbekistan} {V Vatican City} {VN Vietnam} {WAG The Gambia} {WAL Sierra Leone} {WAN Nigeria} {WD Dominica} {WG Grenada} {WL St. Lucia} {WS Western Samoa} {WV St. Vincent} {YE Yemen} {YMN Northern Yemen} {YU Yugoslavia (Serbia & Montenegro)} {YV Venezuela} {Z Sambia} {ZA South Africa} {ZRE Zaire} {ZW Zimbabwe}}}
}

option add *Dew.Label.anchor			ne		widgetDefault
option add *Dew.Label.padX			1		widgetDefault
option add *Dew.Label.padY			0		widgetDefault
option add *Dew.t.anchor			ne		widgetDefault
#option add *Dew.t.padY				0		widgetDefault
#option add *Dew.t.background			{#c0c0c0}	widgetDefault
option add *Dew.t.padX				1		widgetDefault
option add *Dew.t.borderWidth			0		widgetDefault
option add *Dew.b.borderWidth			1		widgetDefault
option add *Dew.b.highlightThickness		0		widgetDefault
option add *Dew.b.takeFocus			0		widgetDefault
option add *Dew*Text.relief			sunken		widgetDefault
option add *Dew*Text.borderWidth		1		widgetDefault
option add *Dew.Text.background			{#f0f0f0}	widgetDefault
option add *Dew.Menubutton.takeFocus		1		widgetDefault
option add *Dew.Menubutton.highlightThickness	1		widgetDefault
option add *Dew.Menubutton.relief		raised		widgetDefault
option add *Dew.Menubutton.anchor		w		widgetDefault
option add *Dew.Menubutton.padX			3		widgetDefault
option add *Dew.Menubutton.padY			1		widgetDefault
option add *Dew.Menubutton.indicatorOn		1		widgetDefault
option add *Dew.Menubutton.borderWidth		1		widgetDefault
option add *Dew.Menubutton.background		{#e8e8e8}	widgetDefault
option add *Dew*Entry.width			20		widgetDefault
option add *Dew.Entry.borderWidth		1		widgetDefault
option add *Dew.Checkbutton.anchor		w		widgetDefault
option add *Dew.Checkbutton.padX		5		widgetDefault
option add *Dew.Checkbutton.padY		1		widgetDefault
#option add *Dew.Checkbutton.borderWidth	1		widgetDefault
#option add *Dew.Checkbutton.relief		sunken		widgetDefault
option add *Dew.Stext.xs.width			4		widgetDefault
option add *Dew.Stext.ys.width			4		widgetDefault
option add *Dew.Stext.xs.borderWidth		1		widgetDefault
option add *Dew.Stext.ys.borderWidth		1		widgetDefault

option add *Dew.gmc-t	{pack %t -side left -anchor w}		widgetDefault
option add *Dew.gmc-e	{pack %e -side left -anchor w -fill x -exp 1}	widgetDefault
option add *Dew.gmc-s	{pack %s -side left -anchor w -fill y}	widgetDefault
option add *Dew.gmc-b	{pack %b -side right -anchor s -fill y}	widgetDefault
option add *Dew.style	ent					widgetDefault
option add *Dew.auto	0					widgetDefault
option add *Dew.gmc	{%T; %E; %S; %B}			widgetDefault

#Create new binding class that doesn't allow direct modifications of an entry
foreach e [bind Entry] {
    if {![lcontain {<<Copy>> <Tab> <B2-Motion> <Button-2> <Control-Key-backslash> <Control-Key-slash> <Key-Right> <Key-Left> <ButtonRelease-2> <Control-Button-1> <ButtonRelease-1> <B1-Enter> <B1-Leave> <Triple-Shift-Button-1> <Double-Shift-Button-1> <Shift-Button-1> <Tripple-Button-1> <Double-Button-1> <B1-Motion> <Button-1>} $e]} continue
#puts "bind Fentry $e [bind Entry $e]"
    bind Fentry $e [bind Entry $e]
} 

# Register a frame to keep all its enclosed dew's titles equal
#------------------------------------------
proc dew::align {w} {
    bind $w <Configure> "+ dew::title_align $w %w %h"
}

# Adjust the titles of any dews inside this frame to of be equal length
#------------------------------------------
proc dew::title_align {w W H} {
    if {$W == 1 && $H == 1} return
#puts "frame_align w:$w W:$W H:$H"
    set dews {}
    set max 0
    foreach f [winfo children $w] {
        if {![lcontain {Dew Cdew} [winfo class $f]]} continue
        lappend dews $f
        set len [string length [$f cget -title]]
#puts "  child:$f t:[$f cget -title] len:$len wid:[$f t cget -width]"
        if {$len > $max} {set max $len}
    }
#puts "  max:$max"
    if {[llength $dews] <= 1} return
    foreach f $dews {$f t configure -width $max}
}

# Allow the user to select a color
#------------------------------------------
proc dew::color {vname} {
    upvar $vname v
    if {$v == {}} {set v ivory3}
    set clr [tk_chooseColor -initialcolor $v]   
    if {$clr == {}} {set clr $v}
    if {$clr == {}} {set clr ivory3}
    set v $clr
}

# Update the title font in the getfont widget
#------------------------------------------
proc dew::updfont {w} {
    variable font
#    set font(size) [expr abs($font(size))]	;#causes infinite Changed events
#puts "updfont:$font(size)"
    if {[catch {$w.test e configure -font [set f "$font(fam) $font(meas)$font(size) $font(style)"]}]} {
        error "Invalid font: $f"
        return 0
    }
    return 1
}

# Select a font (only one can exist at a time)
#------------------------------------------
proc dew::getfont {vname {p .}} {
    variable font
    upvar $vname v
    set w .fontsel
    if {[winfo exists $w]} {destroy $w}
    toplevel $w -class Fontsel
    wm transient $w [winfo parent $p]	;#make it a child window
    label $w.t -text {Font Selector} -bd 1 -relief raised -anchor w

    frame $w.buts
    button $w.buts.ok -text OK -command "set dew::font(ok) 1" -borderwidth 4 -pady 1
    button $w.buts.can -text Cancel -command "destroy $w"
    pack $w.buts.ok $w.buts.can -side left -exp 1 -fill x

    lassign $v font(fam) font(size) font(style)
    if {$font(size) < 0} {set font(size) [expr abs($font(size))]; set font(meas) {-}} else { set font(meas) {}}
    if {$font(style) == {}} {set font(style) {normal}}

    set b [frame $w.body]
    dew::dew $b.fam pdm Family: -textv dew::font(fam) -data {Helvetica Courier Times} -width 12
    dew::dew $b.meas pdm Measure: -textv dew::font(meas) -data {{- pixels} {{} points}}
    dew::dew $b.size ent Size: -textv dew::font(size) -width 4 -just r -spin {int {2 24}}
    dew::dew $b.style pdm Style: -textv dew::font(style) -data {normal bold italic {{bold italic}}} -width 10
    pack $b.fam $b.meas $b.size $b.style -side left
    bind [$b.size entry w] <Return> "dew::updfont $w"
    foreach i {fam meas size style} {bind $b.$i <<Changed>> "dew::updfont $w"}

    dew::dew $w.test mle Sample: -width 44 -height 4 -wrap word -gmc {pack %t %e -side top -exp 1 -anchor w}
    $w.test entry insert 0.0 {The quick brown fox jumped over the lazy dog.}

    pack $w.t $b $w.buts -side top -fill x
    pack $w.test -side top -fill both -exp 1
    pack $w.buts -side bottom -fill x

    dia::place $w -xo -40 -yo 20
    set font(ok) 0
    updfont $w
    tkwait variable dew::font(ok)
    if {$font(style) == {normal}} {set font(style) {}}
    if {[updfont $w]} {set v "$font(fam) $font(meas)$font(size) $font(style)"}
    destroy $w
}

# When a key is pressed, search for matching entries in the list
#------------------------------------------
proc dew::key_proc {w {key {}}} {
    variable cfig
    variable v
#puts "w:$w key:$key: data:$cfig(data$w)"
    foreach rec $cfig(data$w) {
        lassign $rec tag title
        set fc [string range $tag 0 0]
        if {$key == $fc} {
            $w set $tag
            return
        }
    }
}

# Perform the special function menu or operation
#------------------------------------------
proc dew::spf {w {key {}}} {
    variable cfig
    variable scm
    if {$cfig(spf$w) == {}} return
    if {[llength $cfig(data$w)] == 1 && [info exists scm($cfig(data$w))]} {set cfig(data$w) $scm($cfig(data$w))}	;#process shortcut for a standard scm type
    focus $w.e
    set textv [$w.e cget -textv]
    set title [$w.t cget -text]
    lib::cwatch $w.e
    set uw dew_spf[translit . _ $w]
#puts "SPF:$cfig(spf$w) tag:$uw data:$cfig(data$w) key:$key"
    if {$cfig(auto$w) && $key != {}} {
        dia::unget $key
    }
    switch $cfig(spf$w) {
        {scm}	{eval scm::dia \$title $uw -dest $textv $cfig(data$w)}
        {clc}	{calc::dia .$uw -dest $textv -parent $w}
        {edw}	{edwin::edwin .$uw -init 1 -dest $textv -wrap word -title "Editing $title"}
        {edi}	{eval exedit::exedit .\$uw \$textv -dest \$textv $cfig(data$w)}
        {tod}	{set $textv [date_today]}
        {cal}	{cal::dia .$uw -dest $textv -prev 3 -weeks 7 -menu {Select Date:}}
        {tim}	{tim::dia .$uw -dest $textv -menu {Select Time:}}
        {dat}	{date::dia .$uw -dest $textv -title {Select Date:}}
        {fil}	{sfile::dia .$uw -dest $textv -title {Select File:}}
        {mdy}	{date::diamd .$uw -dest $textv -title {Select Day/month:}}
        {col}	{color $textv; if {[set c [subst $$textv]] != {}} {$w.e configure -bg $c}}
        {fnt}	{getfont $textv $w}
        {default} {
            regsub -all -- %v $cfig(spf$w) $textv cmd
            regsub -all -- %w $cmd $w cmd
            regsub -all -- %d $cmd $cfig(data$w) cmd
#puts "spf_cmd:$cmd"
            eval $cmd
        }
    }
    lib::cnorm $w.e
}

# Get data from the entry widget
#------------------------------------------
proc dew::getval {w} {
    variable cfig
#puts "getval w:$w textv:cfig(textv$w)"
    if {$cfig(textv$w) != {}} {
        upvar #0 $cfig(textv$w) var
        return $var
    } else {
        error "getval: no textv for $w"
    }
}

# Set data into the entry widget
#------------------------------------------
proc dew::setval {w value} {
    variable cfig
    if {$cfig(textv$w) != {}} {
        upvar #0 $cfig(textv$w) var
        set var $value
    } else {
        error "setval: no textv for $w"
    }
}

# Get configuration for an entry
#------------------------------------------
proc dew::cget {w option} {
    variable cfig
    argnorm $cfig(swar) option
    set opt [string trimleft $option -]
#puts "cget w:$w option:$option opt:$opt"
    set cfig(title$w) [$w.t cget -text]	;#in case it changed
    if {[lcontain {spf data gmc gmc-t gmc-e gmc-s gmc-b t f style title textv} $opt]} {return $cfig($opt$w)}
    return [eval _$w cget $option]
}

# Configure an existing entry
#------------------------------------------
proc dew::configure {w args} {
    variable cfig
    if {$args == {}} {return [_$w configure]}
    argnorm $cfig(swar) args
    foreach s {spf data title} {set cfig($s$w) [xswitch $s args]}
#    foreach s {} {xswitch $s args cfig($s$w)}
    $w.t configure -text $cfig(title$w)
    if {$args != {}} {eval _$w configure $args}
    set cfig(textv$w) [_$w cget -textv]		;#in case we changed it
    return {}
}

#Create an entry widget
#------------------------------------------
proc dew::dew {w args} {
    variable cfig
    variable scm

    argform {style title} args
    argnorm $cfig(swar) args
    array unset cfig *$w
    foreach s {t fr b} {
        set cfig($s$w) {}
        while {[set x [xswitch $s args]] != {}} {append cfig($s$w) { } $x}
    }
    eval wframe::_frame $w -class Dew $cfig(fr$w)
    widginit $w dew *$w

    swores $w args cfig(%s$w) {gmc gmc-t gmc-e gmc-s gmc-b spf style title auto}
    foreach s {textv} {xswitchs $s args cfig($s$w)}
    foreach s {data spin} {set cfig($s$w) [xswitchs $s args]}
    if {![info exists cfig(textv$w)]} {set cfig(textv$w) ::dew::v(val$w)}

    lassign 1 showb sphlp
    set sphk "\n(Also: right-click or Ctrl-m)"
    switch $cfig(spf$w) {
        {fsm}	{set sphlp "-help {Bring up a selector for allowable values for this field $sphk}"}
        {scm}	{set sphlp "-help {Bring up a selector for suggested values for this field $sphk}"}
        {clc}	{set sphlp "-help {Bring up a calculator for computing values for this field $sphk}"}
        {edw}	{set sphlp "-help {Bring up a text editing box to view/modify the contents of this field $sphk}"}
        {edi}	{set sphlp "-help {Launch an external editor on the contents of this field $sphk}"}
        {tod}	{set sphlp "-help {Set the value of this field to today's date $sphk}"}
        {cal}	{set sphlp "-help {Bring up a calendar selector for setting the value of this field $sphk}"}
        {dat}	{set sphlp "-help {Bring up a date selector for selecting the value for this field $sphk}"}
        {mdy}	{set sphlp "-help {Bring up a month/day spinner for selecting the value for this field $sphk}"}
        {col}	{set sphlp "-help {Bring up a color selector for setting the value for this field $sphk}"}
        {fnt}	{set sphlp "-help {Bring up a font selector for setting the value for this field $sphk}"}
        {}	{set showb 0}
    }
    if {[lcontain {scm fsm} $cfig(spf$w)] && [llength $cfig(data$w)] == 1 && [info exists scm($cfig(data$w))]} {set cfig(data$w) $scm($cfig(data$w))}

    if {$showb || $cfig(spf$w) == {}} {
        eval label $w.t -text \$cfig(title$w) $cfig(t$w)
        eval button $w.b -image pull.dn -command \{dew::spf $w\} $sphlp $cfig(b$w)
    } else {
        eval button $w.t -text \$cfig(title$w) -command \{dew::spf $w\} $sphlp $cfig(t$w)
    }
    set en $w.e
    if {$cfig(style$w) == {inf}} {set cfig(style$w) ent; lappend args -relief raised -bd 1}

    if {[lcontain {chk rad pho} $cfig(style$w)]} {	;#these use the -variable switch--not textvariable
        argnorm {{variable 2}} args
        xswitchs variable args cfig(textv$w)
    }
    
    switch $cfig(style$w) {			;#make actual field entry
        {ent} {
            eval entry $en -textv $cfig(textv$w) $args
            if {$cfig(spf$w) == {dat} || $cfig(spf$w) == {cal} } {
#                bind $en <Double-1> "$en set \[date::date\]"	;#kind of annoying
            }
            if {$cfig(auto$w)} {
                bind $en <Key> "dew::spf $w %k"
#puts "bindtags:[bindtags $en] en:$en"
                bindtags $en "$en Fentry . all"
            }
        }
        {mle} {
            eval stext::stext $en -textv $cfig(textv$w) $args
            bind [$en text w] <Tab> {tk::TabToWindow [tk_focusNext %W]; break}
        }
        {pdm} {
            eval menubutton $en -menu $en.m -textv $cfig(textv$w) $args
            bind $en <Key> "dew::key_proc $w %A"
            menu $en.m
            foreach mi $cfig(data$w) {
                lassign $mi mtag mtit mhlp
                if {$mtit == {}} {set mlab $mtag} else {set mlab "$mtag - $mtit"}
                $en.m add command -label $mlab -command [list set $cfig(textv$w) $mtag] -help $mhlp
            }
        }
        {chk} {
            eval checkbutton $en -variable $cfig(textv$w) $args
        }
        {rad} {
            eval radiobutton $en -variable $cfig(textv$w) $args
        }
        {pho} {
            eval photo::photo $en -variable $cfig(textv$w) $args
        }
        {default} {		;#any other kind of entry
            eval $cfig(style$w) $en -textv $cfig(textv$w) $args
        }
    }
    if {$cfig(spin$w) != {}} {
        if {$cfig(style$w) != {ent}} {error "Spinner feature only supported for entry type"}
        eval spin::spin $w.s -entry $w.e $cfig(spin$w)
    }
    
    if {$cfig(spf$w) == {col}} {
        set textv [$en cget -textv]
        if {[set c [subst $$textv]] != {}} {$en configure -bg $c}
        foreach i {<FocusOut> <Leave> <Return>} {bind $en $i "$en configure -bg \[subst \$$textv\]"}
    }
    foreach i [wkeys::k_menu] {bind $w.e $i "dew::spf $w"}
    bind $w <FocusIn> "focus $w.e"

#    bindtags $w.e [concat $w [bindtags $w.e]]		;#pass events in entry up to frame
#puts "bindtags $w.e [bindtags $w.e]"
    bind $w.e <<Modified>> "ww::modgen $w %s"	;#pass up to this widget
    bind $w.e <<Changed>> "ww::chagen $w"
    bind $w.e <<Ok>> "ww::chagen $w"

    set gmc $cfig(gmc$w)
#puts "w:$w title:[$w.t cget -text]"
    foreach {f r} [list %T $cfig(gmc-t$w) %E $cfig(gmc-e$w) %S $cfig(gmc-s$w) %B $cfig(gmc-b$w) %t $w.t %e $w.e %s $w.s %b $w.b] {
        if {$f == {%B} && !$showb} {set r {}}			;#don't pack button
        if {$f == {%S} && $cfig(spin$w) == {}} {set r {}}	;#don't pack spinner
        regsub -all -- $f $gmc $r gmc
    }
#puts "gmc:$gmc"
    eval $gmc				;#pack,place,grid, etc.
    return $w
}

# Widget command
#------------------------------------------
proc dew::wcmd {w cmd args} {
    variable cfig
    set cmd [unabbrev {{frame 2} {get 1} {set 1} {title 1} {spfunction 3} {entry 1} {cget 2} {configure 2}} $cmd]
    switch -exact -- $cmd {
        {w}		{return $w}
        {get}		{return [eval getval $w $args]}
        {set}		{return [eval setval $w $args]}
        {spfunction}	{spf $w}
        {title}		{return [eval $w.t $args]}
        {button}	{return [eval $w.b $args]}
        {frame}		{return [eval _$w $args]}
        {entry}		{return [eval $w.e $args]}
        {cget}		{return [eval cget $w $args]}
        {configure}	{return [eval configure $w $args]}
        {default}	{return [eval $w.e $cmd $args]}
    }
}

if {[info commands locawyze] != {}} {locawyze dew}
