package provide wylib 0.30	;#Oct 2001
#Misc functions that don't really have a good home and are not in a namespace
#------------------------------------------
# Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:
# 
# Free Software Foundation, Inc.
# 51 Franklin Street, Fifth Floor
# Boston, MA  02110-1301, USA

# Do nothing
#------------------------------------------
proc nop {args} {}

#Capitalize the first letter of a word
#------------------------------------------
proc cap_first {s} {
    return [string toupper [string range $s 0 0]][string range $s 1 end]
}

#Create a unique window name by appending an integer onto a base string
#----------------------------------------------------
proc uwin {base} {
    for {set i 0} {[winfo exists $base$i]} {incr i} {}
    return $base$i  
}

#Round to even cents
#------------------------------------------
proc round_dollar {val} {return [expr floor(($val) * 100.00 + 0.5) / 100.00]}

#Return a dollar value in standard form
#------------------------------------------
proc norm_dollar {val} {
    if {$val == {}} {return 0.00}
    return [format {%#.2f} [round_dollar $val]]
}

#Format for dollars, including commas
#------------------------------------------
proc comma_dollar {val} {return [money $val]}

# Make a label from a template
#------------------------------------------
proc labtpt {tpt args} {
    argproc ca(\$s) $args {{strip 1} {* {}}}
    set lb {}
    foreach tptln $tpt {
        set ln {}
        foreach fld $tptln {			;#for field in the line
            lassign $fld tag pre post targ
            if {$targ == {}} {set targ $lasttarg}	;#first target must be specified
#puts "tag:$tag: pre:$pre: post:$post: targ:$targ:"
            set data [$ca($targ) get $tag]	;#fetch the data from the appropriate target
            if {$data != {}} {
                append ln "$pre$data$post"	;#add on each field
            }
            set lasttarg $targ			;#keep using this target
        }
        if {$ca(strip)} {regsub -- {^[, ]+} $ln {} ln}
        if {$ln != {} || $tptln == {}} {append lb "$ln\n"}	;#accumulate line
    }
    return $lb
}

# Insert top and left margins on a block of text
# ----------------------------------------------------------------
proc margins {text {top 4} {left 4}} {
    set linelist {}
    for {set i 0} {$i < $top} {incr i} {lappend linelist {}}
    foreach ln [split $text "\n"] {
        set line {}
        if {$ln != {}} {
            for {set i 0} {$i < $left} {incr i} {append line { }}
        }
        append line $ln
        lappend linelist $line
    }
    return [join $linelist "\n"]
}

# Wrap lines of text at a word boundary if they exceed a width.
# Retain existing newlines
# ----------------------------------------------------------------
proc wrap {text {width 80}} {
    set tl {}		;#list of lines we will send back
    set nln {}		;#current line accumulator
#puts "wrap width:$width"
    if {$width <= 0} {return $text}
    foreach ln [split $text "\n"] {	;#for each line of original text
        while {[string length $ln] > $width} {	;#while line is too long
            set idx [string wordstart $ln $width]	;#where to break line
            if {$idx == 0} break
            set chunk [string range $ln 0 [expr $idx - 1]]
            lappend tl $chunk
            set ln [string range $ln $idx end]
        }
        lappend tl $ln
    }
    return [join $tl "\n"]
}

# Define a procedure which will be executed at the specified stack level
# ----------------------------------
proc uproc {pname p1 {p2 {}}} {
    if {[string is digit -strict $p1]} {
        set level $p1
        set code $p2
    } else {
        set level 1
        set code $p1
    }
    uplevel proc $pname \{\} "{uplevel $level {$code}}"
}

# Traditional "do while" loop
#------------------------------------------
proc dowhile {body condition} {
    uplevel "$body; while {$condition} {$body}"
}

# Remove a named element from a list
#------------------------------------------
proc lremove {list element} {
    if {[set idx [lsearch -exact $list $element]] < 0} {return $list}
    return [lreplace $list $idx $idx]
}

# Do things common to destroying a compound widget
#----------------------------------------------------
proc widgclose {w ns idx} {
#if {$ns == {wmenu}} {
#    puts "w:$w; array unset ${ns}::cfig $idx len:[llength [array get ${ns}::cfig]]"
#    puts "arr:[array get ${ns}::cfig $idx]"
#}
    array unset ${ns}::cfig $idx	;#this can be pretty slow
    catch {rename ::$w {}}
    if {[info commands ::${ns}::_$w] != {}} {
        rename ::${ns}::_$w {}	;#should be deleted automatically (but sometimes isn't)
    }
}

# Do things common to initializing a compound widget
#----------------------------------------------------
proc widginit {w ns idx {wcmd wcmd}} {
    rename ::$w ::${ns}::_$w
    proc ::$w {cmd args} "eval ${ns}::$wcmd $w \$cmd \$args"
#    bind $w <Destroy> "+widgclose $w $ns $idx"
    bind $w <Destroy> "+if {{%W} == {$w}} {widgclose $w $ns $idx}"	;#sometimes the binding can be executed by a parent window
}

# Quote spaces and other strange characters that would be a problem for the shell
#------------------------------------------
proc ::shq {args} {

    set nargs {}
    foreach arg $args {
        if {$arg == {}} {
            set narg {""}
        } else {
            set narg $arg
            regsub -all {[ #$~`()]} $narg "\\\\&" narg
        }
        lappend nargs $narg
    }
#puts "nargs:$nargs:"
    if {[llength $nargs] <= 1} {return [lindex $nargs 0]} else {return $nargs}
}
