package provide wylib 0.30	;#Oct 2001
#Routines that need different handling for different os platforms
#------------------------------------------
# Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:
# 
# Free Software Foundation, Inc.
# 51 Franklin Street, Fifth Floor
# Boston, MA  02110-1301, USA

#TODO:
#- port to windows
#- can we use tcllib for uuencode and zlib for gzip?

namespace eval osdep {
    namespace export cmd_esc filetypes smash_file unsmash_data
}

# Escape spaces or other irregular characters for command line processing
#------------------------------------------
proc osdep::cmd_esc {args} {
    set res {}
    foreach i $args {
        regsub -all { } $i {\ } i
        lappend res $i
    }
    return $res
}

# Determine the type of one or more files
#------------------------------------------
proc osdep::filetypes {files} {
    if {[llength [set files [eval cmd_esc $files]]] <= 0} {return {}}
    set types [eval exec /usr/bin/file -b $files]
    return [split $types "\n"]
}

# Compress file data and then uuencode it, returning the result as a string
#------------------------------------------
proc osdep::smash_file {fname} {
    set fd [open $fname r]		;#open the file
    set data [exec /bin/gzip -c <@$fd | /usr/bin/uuencode -m [file tail $fname]]
    close $fd
    return $data
}

# Expand string data previously compressed with smash_file, write to a file
#------------------------------------------
proc osdep::unsmash_data {data fname} {
    exec /usr/bin/uudecode -o - << $data | /bin/zcat > $fname
}
