package provide wylib 0.30	;#Oct 2001
#Routines to check a person's password.
#There can only be one instance of this per application
#Call passwd_ok to see if the password has been entered recently enough.
#If not, the password will be prompted for and the timeout will be restarted.
#------------------------------------------
# Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:
# 
# Free Software Foundation, Inc.
# 51 Franklin Street, Fifth Floor
# Boston, MA  02110-1301, USA


namespace eval passwd {
    namespace export init ok
    variable cfig
    variable v
    set cfig(timeout)	[expr 1000 * 60 * 60 * 30]	;#30 minutes
    set cfig(pwdfile)	{/etc/passwd}
    set cfig(uname)	{}
    
    set v(pwdok) 0	;#flag for password OK
    set v(aid) {}	;#after id
}

#if {[info commands checkpwd] == {}} {lib::loadlib libtsl.so}

# Initialize this module
#----------------------------------------------------
proc passwd::init {args} {
    variable cfig
    variable v
    argproc cfig(\$s) $args {{timeout $cfig(timeout)} {uname {}}}
    set v(pwdok) 0
    if {$v(aid) != {}} {after cancel $v(aid)}	;#cancel any old timers
    set v(aid) {}
}

# Timeout handler
#----------------------------------------------------
proc passwd::timehand {} {
    variable v
    set v(pwdok) 0
    set v(aid) {}
}

# Call PAM to see if the password has been entered recently enough
#----------------------------------------------------
proc passwd::ok {} {
    variable cfig
    variable v

    if {$v(pwdok)} {return 1}
    if {$cfig(uname) == {}} {set cfig(uname) [id user]}
    if {[checkpwd $cfig(uname) {dia::pquery "Please input %s"}]} {
        set v(pwdok) 1
        if {$v(aid) != {}} {after cancel $v(aid)}
        set v(aid) [after $cfig(timeout) passwd::timehand]
        return 1
    }
    dia::err "Invalid Password"
    return 0
}	
