package provide wylib 0.30	;#Oct 2001
# Access the privilege table.
#------------------------------------------
# Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:
# 
# Free Software Foundation, Inc.
# 51 Franklin Street, Fifth Floor
# Boston, MA  02110-1301, USA

#TODO:
#X- Get rid of dependence on cnf(appname)
#- 

namespace eval priv {
    namespace export haspriv runcheck usercheck alarm me
    variable prc	;#cache of values from privilege table
    variable cfig
    set cfig(su)	{}
    set cfig(idfield)	user_id
    set cfig(privtab)	priv
    set cfig(usertab)	users
}

# Stub for sitelib procedure to customize tablenames based on permissions
#------------------------------------------
proc priv::me {args} {return {}}

# Is the current user privileged at the limited level or above?
#------------------------------------------
proc priv::haspriv {{level user} args} {
    variable prc
    variable cfig

    argproc ca(\$s) $args {{priv {[lib::cfig appname]}} {uid {[user::uid]}} {func =}}

#puts "check: user:$ca(uid) level:$level priv:$ca(priv)"
    if {![info exists prc($ca(priv).$level)]} {
        switch $level {
            {super}	{set lev {alevel = 'super'}}
            {user}	{set lev {alevel in ('super','user')}}
            {limit}	{set lev {alevel in ('super','user','limit')}}
        }
        set prc($ca(priv).$level) [sql::qlist "select $cfig(idfield) from priv where priv $ca(func) '$ca(priv)' and ($lev) order by 1"]
    }
    if {[lsearch -exact $prc($ca(priv).$level) $ca(uid)] >= 0} {return 1}
#puts "su:$cfig(su)"
    if {[lcontain $cfig(su) $ca(uid)]} {return 1}	;#superuser
    return 0
}

# Check for the minimum level of required permission and report any error to the user
#------------------------------------------
proc priv::runcheck {{level limit}} {
    if {![haspriv $level]} {
        dia::err "Insufficient privilege level"
        exit
    }
}

# Check for a level of permission and report any error to the user
#------------------------------------------
proc priv::usercheck {args} {
    if {[eval haspriv $args]} {return 1}
    dia::err "Insufficient privilege level"
    return 0
}

# Return a list of usernames in a level for this application (or privilege)
#------------------------------------------
proc priv::llist {level {priv {}}} {
    variable cfig
    variable prc
    if {$priv == {}} {set priv [lib::cfig appname]}
#puts "priv:$priv"
    haspriv $level -priv $priv		;#make sure cache is OK
    set ulist [sql::qlist "select username from empl_v_pub where $cfig(idfield) in ([join $prc($priv.$level) ,]) and username is not null"]
#puts "ulist:$ulist"
    return $ulist
}

# Send a message to the supervisors for this application
#------------------------------------------
proc priv::alarm {msg args} {
    variable cfig
    argproc ca(\$s) $args {{priv {[lib::cfig appname]}} {level {super}} {idlist {}} {launch {}} {mlist {}} {ldesc {}} {editmsg 0} {subject {}}}
    
    if {$ca(idlist) != {}} {
        set ca(mlist) [concat $ca(mlist) [sql::qlist "select username from $cfig(usertab) where $cfig(idfield) in ([join $ca(idlist) ,])"]]
    } elseif {$ca(priv) != {}} {
        set ca(mlist) [concat $ca(mlist) [llist $ca(level) $ca(priv)]]
    } elseif {$ca(mlist) == {}} {
        error "Can't determine whom to mail to"
    }
    if {$ca(subject) == {}} {set ca(subject) "[cap_first $ca(priv)] Attention:"}
    lib::mail_to [join $ca(mlist) ,] $msg -subject $ca(subject) -launch $ca(launch) -ldesc $ca(ldesc) -editmsg $ca(editmsg)
}

if {[info commands locawyze] != {}} {locawyze priv}
