package provide wylib 0.30	;#Sep 2005
#New and improved DataBase record Editor.
#This is the main editor widget where fields can be veiwed and edited.
#------------------------------------------
# Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:
# 
# Free Software Foundation, Inc.
# 51 Franklin Street, Fifth Floor
# Boston, MA  02110-1301, USA

#TODO:
#X- split this file into mdew (view) and a new dbe (control)
#X- better calls from wmdlib to get table/field defaults
#X- draw titles,helps from meta-db
#X- can we remove f_add now?
#X- show current primary key loader in header (optional)
#X- make custom view for tool
#X- show supervisor/proxy names in widget
#X- get rid of lv()?
#X-  how to handle auxupdate (aux fields in db view only?)
#X- finish "exist call"
#X- make update work
#X- make add work
#X- test templates
#X- make delete work
#X- simpler way to make pre_funcs check/prepare data
#X- zip lookup call
#X- review widget cmds (get rid of old ones)
#X- what does ::setup do?
#X- note when fields changed, ask on clear, ldrec
#X- can/should control calls (pre/post) be specified in wmdlib?
#X- pksep doesn't work
#X- re-instate lv() to check for actual changes? (or change how x::modified works?)
#X- make prefs call do something useful?
#- 
#- When checkfield dialog appears, 'modified 0' at end of ::updrec doesn't seem to take (record shows dirty)
#- Can we do a dia::query on the textvariable for a field that is type mle now?
#- update doc.dbe
#- 
#LATER:
#- how to specify -underline for dbe/dbp menu in a language independent way?
#- make/implement a pixmap dew type (use for the employee's picture)
#- Allow to reference fields more than once on invocation? (make options additive)
#- 

package require [sql::wmd]
package require wyseman
option add *Dbe.relief raised widgetDefault
option add *Dbe.borderWidth 1 widgetDefault

namespace eval dbe {
    namespace export dbe
    variable cfig		;#config values for each widget
    variable v

    array set cfig {adr:und 0	upr:und 0	dlr:und 0	clr:und 0	prv:und 0	rld:und 0	nxt:und 0	ldr:und 0}
    array set cfig {adr:com {dbe::add %w}	upr:com {dbe::updrec %w}	dlr:com {dbe::delete %w}	clr:com {dbe::clear %w}		prv:com {dbe::ldhist %w -1}	rld:com {dbe::ldhist %w 0}	nxt:com {dbe::ldhist %w 1}	ldr:com {dbe::keyload %w}}
    array set cfig {adr:s {Add -bg lightblue -padx 4}	upr:s {Upd -bg khaki1}	dlr:s {}	clr:s {Clear -bg grey95}	prv:s {< -bg lightgreen -padx 2 -rep 1}	rld:s {}	nxt:s {> -bg plum1 -padx 2 -rep 1}	ldr:s {}}
    array set cfig {adr:text {Add New Record}	upr:text {Update Current Record}	dlr:text {Delete Current Record}	clr:text {Clear Entry Fields}	prv:text {Previous Record}	rld:text {Reload Current Record}	nxt:text {Next Record}	ldr:text {Load record}}
    array set cfig {adr:help {Add a new record to the database using the fields currently showing} upr:help {Make changes to the database according to the data currently showing} dlr:help {Remove from the database the record currently showing (can't be undone)} clr:help {Reset the entry fields to a state ready for the entry of a new record (does not affect the database)} prv:help {Move backward through the list of previously loaded records} rld:help {Re-get the current record from the database} nxt:help {Move forward through the list of previously loaded records}	ldr:help {Load a specific record by its primary key (unique identifier) value}}

    set cfig(swar) {{menu 2} {table 2} {primarykey 3 pkey} {record 3} {auto 2} {keyseparator 3 pksep} {preclear 3} {pwidget 2} {master 2} {slaves 2} {focus 2} {help 2} {ldr.pst 5} {ldr.prompt 5} {clr.pre 6} {clr.pst 6} {clr.message 5} {clr.prompt 5} {dlr.pre 5} {dlr.pst 5} {dlr.message 5} {dlr.prompt 5} {adr.pre 5} {adr.pst 5} {adr.reload 5} {adr.message 5} {adr.prompt 5} {upr.pre 5} {upr.pst 5} {upr.reload 5} {upr.message 5} {upr.prompt 5}}
    set cfig(sdef) [list preclear 1 pksep - foid oid auto 1 nulemp 1 adr.reload 1 record {Record: -width 14} ldr.prompt 1 dlr.message $cfig(dlr:text) adr.message $cfig(adr:text) clr.message $cfig(clr:text) upr.message $cfig(upr:text) dlr.prompt 1 adr.prompt 0 clr.prompt 0 upr.prompt 0 upr.reload 1]
    set cfig(sblk) {pkey menu pwidget master slaves focus gmc sargs ldr.pst clr.pre clr.pst dlr.pre dlr.pst adr.pre adr.pst upr.pre upr.pst}
    foreach {sw} $cfig(swar) {if {[llength $sw] > 2} {lappend cfig(star) [lindex $sw 2]} else {lappend cfig(star) [lindex $sw 0]}}

    set cfig(fwar) {{write 2} {read 2} {field 2} {dependency 3 fdep}}
    set cfig(fdef) {write 1 read 1}
    set cfig(fblk) {fdep field}
    set cfig(fshort) {style size sub title help}	;#must agree with mdew.tcl and wyseman
    foreach {sw} $cfig(fwar) {lappend cfig(ftar) [lindex $sw 0]}

    image create bitmap smile -data "#define smiley_width 14\n#define smiley_height 14\nstatic unsigned char smiley_bits[] = {\n0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x02, 0x38, 0x07, 0x00, 0x00,0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x08, 0x04, 0x10, 0x02, 0xe0, 0x01,0x00, 0x00, 0x00, 0x00};"
    image create bitmap frown -data "#define frowny_width 14\n#define frowny_height 14\nstatic unsigned char frowny_bits[] = {\n0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x02, 0x38, 0x07, 0x00, 0x00,0x00, 0x00, 0x00, 0x00, 0xe0, 0x01, 0x10, 0x02, 0x08, 0x04, 0x04, 0x08,0x00, 0x00, 0x00, 0x00};"
}

# Get an entry value and quote it appropriately for the data type
#------------------------------------------
proc dbe::quoted {w tag} {
    variable cfig
    return [sql::quote $cfig(table$w) $tag [$w.d get $tag] 0]
}

# SPF handler to select from all existing values in a DB field
#------------------------------------------
proc dbe::exist {w entry table column} {
#puts "dbe::exist w:$w entry:$entry table:$table column:$column"
    if {[scm::dia {Existing values:} dbexs_${table}_$column -eval "sql::qlist {select distinct $column from $table order by $column}" -dest value -f [list $column [$entry cget -title]] -token $column] >= 0} {
        $w set $column $value
    }
}

# SPF handler for looking city, state up from zip code
#------------------------------------------
proc dbe::zip {w entry zfld cfld sfld} {
#puts "dbe::zip w:$w entry:$entry zfld:$zfld cfld:$cfld sfld:$sfld"
    set zip [$w get $zfld]
    lassign [web::zip $zip] city state
    if {$state != {}}	{$w set $sfld $state}
    if {$city != {}}	{
        $w set $cfld $city
        after idle "focus [$w field $cfld w]"		;#leave focus in city field
    }
}

#Set or return the primary field values for the current record
#------------------------------------------
proc dbe::pk {w {vals {_?_}}} {
    variable cfig; variable v

    if {$vals == {_?_}} {				;#return pk of current record
        return $v(pkvals$w)
    } elseif {$vals == {_!_}} {				;#note primary key from loaded fields
        set v(pkvals$w) {}
        foreach f $cfig(pkey$w) {lappend v(pkvals$w) [$w.d get $f]}
    } else {						;#set pk to the value we specify
        set v(pkvals$w) $vals				;#list version
    }
    set v(recid$w) [join $v(pkvals$w) $cfig(pksep$w)]	;#display version
}

#Return a where clause based on the currently loaded primary key(s)
#------------------------------------------
proc dbe::keywhere {w {prefix {}}} {
    variable cfig
    set wharr {}
    set pkval [pk $w]
    set i 0; foreach tag $cfig(pkey$w) {
        set fval [lindex $pkval $i]
#        if {[set val [sql::quote $cfig(table$w) $tag [lindex $pkval $i]]] == {}} {dia::err "Illegal blank value in primary key field: ($tag)"; return {}}
        if {[set val [sql::quote $cfig(table$w) $tag [lindex $pkval $i]]] == {}} {return {}}
        lappend wharr "$prefix$tag = $val"
        incr i
    }
    return [join $wharr { and }]
}

#Load a record as defined by the primary key the user will enter
#------------------------------------------
proc dbe::keyload {w} {
    variable cfig; variable v
    set strgs {}
    set vnams {}
    set fargs {}
    set fvpair {}
    set i 0; foreach tag $cfig(pkey$w) {
        lassign [wmdd::column $cfig(table$w) $tag] title help
        if {[set data [wmdd::value $cfig(table$w) $tag]] != {}} {set data [list -data $data]}
        set dargs [[sql::wmd]::$cfig(table$w) $tag]
#puts "tag:$tag dargs:$dargs"
        argnorm $cfig(fwar) dargs
        foreach sw $cfig(ftar) {xswitchs $sw dargs}	;#strip dbe arguments (make suitable for mdew)
        foreach sw {hide state sub} {xswitchs $sw dargs}	;#strip disabling arguments
        
        lappend fargs -f [concat $tag $dargs [list -title $title: -help $help] [list -sub "0 $i" -state normal -hide 0] $data]
        lappend fvpair $tag [$w.d get $tag]
        incr i
    }
#puts "fargs:$fargs\nfvpair:$fvpair"
    if {[eval dia::dia .dbepk_$cfig(table$w) -but \{OK Cancel\} -message \{Load what record:\} -def 0 -entry mdew::mdew -dest fvpair -pre 1 $fargs] < 0} return
#puts "Fvpair:$fvpair"
    foreach {sw va} $fvpair {lappend pkval $va}
    ldrec $w $pkval
}

#Load the data for the specified record into the edit widget
#------------------------------------------
proc dbe::ldrec {w args} {
    variable cfig; variable v

    argform {id} args
    argnorm {{oid 1} {history 1 hist} {post 2 pst} {identity 1 id}} args
    array set ca [list oid 0 id {} hist 1 pst $cfig(ldr.pst$w) mod $cfig(ldr.prompt$w)]
    foreach sw {id oid hist pst mod} {xswitchs $sw args ca($sw)}
#puts "ldrec $w chk:$ca(mod) mod:[$w modified]"
    if {$ca(mod) && [$w modified]} {
        if {[dia::ask "Modified fields in \"[$w menu menu cget -text]\" pane not yet saved" 0 {Load New Record Anyway} Cancel] < 0} {return 0}
    }
    if {$ca(id) == {}} {return 0}	;#no record identifier given
    if {$ca(oid)} {			;#if using oid for key
        set where "where $cfig(foid$w) = $ca(id)"
    } else {				;#otherwise use normal primary key
        set where {}
#puts "pkey:$cfig(pkey$w):"
        set i 0; foreach k $cfig(pkey$w) {	;#for each field of the key
#            if {[set qs "[sql::quote $cfig(table$w) $k [lindex $ca(id) $i]]"] == {}} {dia::err "Blank value improperly specified for loading record"; return 0}
            if {[set qs "[sql::quote $cfig(table$w) $k [lindex $ca(id) $i]]"] == {}} {return 0}
            lappend where "$k = $qs"
            incr i
        }
        set where "where [join $where { and }]"
    }
    lassign {} fields ftags
    foreach tag [$w.d tags] {			;#for each field
        set fn $w.$tag
        if {!$cfig(read$fn)} continue		;#ignore if we don't read this field from db
        if {$cfig(field$fn) != {}} {		;#if field spec is different from tag
            lappend fields $cfig(field$fn)	;#use it
        } elseif {[lcontain {date timestamp} [wmdd::type $cfig(table$w) $tag]]} {
            lappend fields "norm_date($tag)"
        } else {
            lappend fields $tag			;#else use tag for field name
        }
        lappend ftags $tag
    }
    set query [subst "select [join $fields ,] from $cfig(table$w) $where"]
#puts "query:$query"
    set pgres [sql::exe $query]
    set cnt [pg_result $pgres -numTuples]	;#how many did we get
    if {$cnt == 1} {set res [pg_result $pgres -getTuple 0]}
    pg_result $pgres -clear
    if {$cnt < 1} {dia::err "No record found in $cfig(title$w)\n(table: $cfig(table$w) key: $ca(id))"; return 0}
    if {$cnt > 1} {error {In dbe ldrec} "Multiple records found: $ca(id) ($cnt)"; return 0}
#puts "res:$res"

    set b [ww::modblock 1]			;#more efficient to block all modified-events
    set f 0; foreach tag $ftags {		;#for each result field
        set val [lindex $res $f]
        $w.d field $tag set $val
        set v(last.$tag$w) $val			;#to remember previous value
#puts "tag:$tag val:$val"
        incr f
    }
    $w.d modified 0		;#mark as clean
    ww::modblock $b		;#unblock modified events
    ww::modgen $w.d 0		;#force a clean event

    pk $w {_!_}					;#note our record ID

    if {$ca(hist)} {				;#save primary key in history stack
        set kfv [pk $w]				;#primary key value
        if {[lindex $cfig(hist$w) end] != $kfv} {lappend cfig(hist$w) $kfv}
        set cfig(hidx$w) [expr [llength $cfig(hist$w)] - 1]
    }

    foreach i {clr adr dlr upr} {m_endis $w $i normal}	;#update button statuses

    eval_pstfunc $w $ca(pst)			;#execute post function

    foreach sl $cfig(slaves$w) {		;#reload any slave dbp's with related records
#puts "w:$w slave:$sl"				;# "w:[eval $sl w]"
        if {![catch {eval $sl w}]} {		;#if the widget seems to exist
            eval $sl obey $w			;#try asking it to obey
        }
    }

    $w modified 0
#puts "done mod:[$w modified]"
    event generate $w <<Execute>>		;#in case anyone is tracking new loads
    return 1
}

#Load the previous record in the history list
#------------------------------------------
proc dbe::ldhist {w off} {
    variable cfig
    set last [expr [llength [set hist $cfig(hist$w)]] - 1]
    set idx [expr $cfig(hidx$w) + $off]
#puts "hist:$cfig(hist$w) hidx:$cfig(hidx$w) off:$off last:$last idx:$idx"
    if {$idx < 0} {
        dia::brief {No previous record} 800
    } elseif {$idx > $last} {
        dia::brief {No next record} 800
    } elseif {$last < 0} {
        dia::brief {No current record} 800
    } else {
#puts "ldrec $w idx:$idx"
#        if {$off == 0} {dia::brief Reloading 200}
        ldrec $w [lindex $hist $idx] -hist 0
        incr cfig(hidx$w) $off
    }
}

# Eval the prefunc if appropriate, return any additional query string given
#------------------------------------------
proc dbe::eval_prefunc {w sql func} {
    proc arg {s v} {uplevel 2 set ca($s) $v}	;#Ugly hack: the prefunc can use this to set command line args in calling routine (like the tuple argument, used in potool)
    if {$sql || $func == {}} {return {}}

    if {[regexp {%w} $func]} {regsub -all %w $func $w func} else {append func { } $w}	;#pass widget variable into pre-function
    while 1 {
        set res [eval $func]
        if {$res == {?}} {
            if {[set res [checkfield $w prompt]] == {?}} continue
        }
        if {![lcontain {0 1 yes no {}} $res]} {		;#function passed back sql
            return $res
        } elseif {[lcontain {0 no {}} $res]} {		;#user data failed
            checkfield $w clear
            return -code return 0
        } else {					;#user data OK
            return {}
        }
    }
}

# Eval the post-function, substituting the widget argument
#------------------------------------------
proc dbe::eval_pstfunc {w func} {
    if {$func == {}} return
    if {[regexp {%w} $func]} {regsub -all %w $func $w func} else {append func { } $w}	;#pass widget variable into function
    return [eval $func]
}

# Build the total query from the primary and the additional query
#------------------------------------------
proc dbe::cat_query {query aquery} {
    if {$aquery == {}} {
        return $query
    } elseif {[regexp -- {%q} $aquery]} {
        regsub -- {%q} $aquery $query query
    } else {
        append query ";\n$aquery"
    }
    return "$query"
}

#Clear all fields
#------------------------------------------
proc dbe::clear {w args} {
    variable cfig; variable v

    argproc ca(\$s) $args {{mod 1} {focus 1} {pre $cfig(clr.pre$w)} {pst $cfig(clr.pst$w)} {msg $cfig(clr.message$w)} {prompt $cfig(clr.prompt$w)}}
    eval_prefunc $w 0 $ca(pre)
    if {$ca(mod) && [$w modified] && $ca(prompt)} {
        if {[dia::ask $ca(msg)? 0 OK Cancel] != 0} {return 0}
    }

    $w.d initialize
    foreach {sw va} [$w.d get] {set v(last.$sw$w) $va}	;#init previous values
    pk $w {}
    checkfield $w clear
    foreach i {dlr upr} {m_endis $w $i disabled}
    eval_pstfunc $w $ca(pst)
    
    foreach sl $cfig(slaves$w) {		;#clear slaves too
        if {[winfo exists $sl]} {eval $sl clear -focus 0}
    }

    if {$ca(focus) && $cfig(focus$w) != {}} {
        after idle "update; focus [$w field $cfig(focus$w) entry w]"	;#we got hangs from slave dbe's without the "after idle" and update, also some hangs after checkfield issued warnings
#        focus [$w field $cfig(focus$w) entry w]				;#fixed now with -focus 0 in dbp::clear (hmm, guess not fixed yet...)
    }
    return 1
}

#Delete the currently showing record
#------------------------------------------
proc dbe::delete {w args} {
    variable cfig; variable v

    argproc ca(\$s) $args {{pre $cfig(dlr.pre$w)} {pst $cfig(dlr.pst$w)} {prompt $cfig(dlr.prompt$w)} {sql 0} {clear 1} {auto $cfig(auto$w)} {msg $cfig(dlr.message$w)}}
    
    set aquery [eval_prefunc $w $ca(sql) $ca(pre)]
    if {[set where [keywhere $w]] == {}} {return 0}
    set query "delete from $cfig(table$w) where $where"
#puts "query:$query aquery:$aquery"
    if {!$ca(sql) && $ca(prompt)} {if {[dia::ask $ca(msg)? 0 OK Cancel] != 0} {return 0}}
    if {$ca(sql)} {return $query}
    set pgres [sql::exe [cat_query $query $aquery] -t 1]
    if {[set cnt [pg_result $pgres -cmdTuples]] != 1} {dia::warn "The command deleted $cnt records"}
    pg_result $pgres -clear

    pk $w {}			;#erase the primary key
    foreach i {del upd} {m_endis $w $i disabled}
    foreach p $cfig(pwidget$w) {if {$ca(auto)} {$p reload}}
    eval_pstfunc $w $ca(pst)
    return 1
}

#Add a new record with the information showing
#------------------------------------------
proc dbe::add {w args} {
    variable cfig; variable v

    argproc ca(\$s) $args {{mod 1} {pre $cfig(adr.pre$w)} {pst $cfig(adr.pst$w)} {prompt $cfig(adr.prompt$w)} {sql 0} {tuple 0} {reload $cfig(adr.reload$w)} {msg $cfig(adr.message$w)} {auto $cfig(auto$w)}}

    foreach ma $cfig(master$w) {		;#set foreign keys for any table(s) we're related to
#puts "master:$ma"
        set tab [eval $ma cget table]		;#master table
#puts " tab:$tab"
        foreach rec [wmdd::columns_fk $cfig(table$w) $tab] {
            lassign $rec cols fcols
#puts "  cols:$cols fcols:$fcols"
            set i 0; foreach col $cols {
                set ftag [lindex $fcols $i]
                $w.d field $col set [eval $ma get $ftag]
                incr i
            }
        }
    }

    set aquery [eval_prefunc $w $ca(sql) $ca(pre)]
#puts "aquery:$aquery"
    if {!$ca(sql)} {
        if {$ca(mod) && ![$w modified]} {
            if {[dia::ask {No fields yet edited} 0 {Add Anyway} Cancel] < 0} {return 0}
        } elseif {$ca(prompt)} {
            if {[dia::ask $ca(msg)? 0 OK Cancel] != 0} {return 0}
        }
    }

    set fields {}			;#holds fieldnames
    set values {}			;#holds values
    foreach {tag val} [$w.d get] {
        set fn $w.$tag
#puts "fn:$fn fname:$fname"

        if {$cfig(field$fn) == {}} {set fname $tag} else {set fname $cfig(field$fn)}
        if {[lcontain {oid _oid} $fname] || !$cfig(write$fn)} continue	;#skip these fields
        if {![$w.d check $tag -rep 1]} {return 0}	;#check field against any templates

        if {$val == {} && ![wmdd::nonull $cfig(table$w) $tag]} continue	;#don't write empty fields (if the column can accept nulls)

        lappend fields $tag			;#keep track of the fields we're writing
#        if {[set val [sql::quote $cfig(table$w) $tag $val]] == {}} {dia::err "Illegal blank value in field: ($tag)"; return 0}
        if {[set val [sql::quote $cfig(table$w) $tag $val]] == {}} {return 0}
        set v(last.$tag$w) $val			;#remember previous value
        lappend values $val
    }
    if {$fields == {} || $values == {}} {dia::warn "Nothing to add"; return 0}
    
    set query "insert into $cfig(table$w) ([join $fields ,]) values ([join $values ,])"
#puts "Query:[cat_query $query $aquery]"
    if {$ca(sql)} {return $query}
    if {[set pgres [sql::exe [cat_query $query $aquery] -t 1]] == 0} {return 0}
    $w modified 0
    if {$ca(reload)} {
        if {$ca(tuple)} {			;#can use if multiple items were added
            ldrec $w -mod 0 [set result [pg_result $pgres -getTuple 0]]
        } elseif {$cfig(foid$w) != {}} {
            if {[set result [pg_result $pgres -oid]] <= 0} {
                dia::warn {The record was not added}
            } else {
#puts "Reload oid:$result"
                ldrec $w -mod 0 $result -oid 1
            }
        } else {
            dia::warn {No oid field found, can't reload new record}
        }
    }
#puts "result:$result auto:$ca(auto)"
    pg_result $pgres -clear
#    foreach i {upr} {m_endis $w $i disabled}
    foreach p $cfig(pwidget$w) {if {$ca(auto)} {$p reload -autoload 0}}
    eval_pstfunc $w $ca(pst)
    return $result
}

#Update the current record with all changes
#------------------------------------------
proc dbe::updrec {w args} {
    variable cfig; variable v

    argproc ca(\$s) $args {{warn 1} {pre $cfig(upr.pre$w)} {pst $cfig(upr.pst$w)} {msg $cfig(upr.message$w)} {prompt $cfig(upr.prompt$w)} {sql 0} {reload $cfig(adr.reload$w)} {auto $cfig(auto$w)}}
    if {[pk $w] == {}} {dia::err "No record loaded"; return 0}
    set aquery [eval_prefunc $w $ca(sql) $ca(pre)]
    if {!$ca(sql) && $ca(prompt)} {if {[dia::ask $ca(msg)? 0 OK Cancel] != 0} {return 0}}
    if {[set where [keywhere $w]] == {}} {return 0}	;#where primary key...

    set updates {}				;#field update clause
    foreach {tag val} [$w.d get] {
        set fn $w.$tag
        if {!$cfig(write$fn)} continue		;#exlude non-writable fields
        if {$val == $v(last.$tag$w)} continue		;#exlude fields that haven't changed (or: ![$w.d $tag modified])
        if {![$w.d check $tag -rep 1]} {return 0}	;#check field against any templates
        set qval [sql::quote $cfig(table$w) $tag $val]
        if {$qval == {}} {return 0}
        lappend updates "$tag = $qval"
    }
    if {[llength $updates] <= 0} {		;#if no updates to do
        set query {}
    } else {
        set query "update $cfig(table$w) set [join $updates ,] where $where"
    }
    if {$ca(sql)} {return $query}
    if {$query == {}} {			;#if no updates to do
        if {$ca(warn)} {dia::warn "Nothing modified"}
        modhand $w 0
        return 0
    }
#puts "Query:[cat_query $query $aquery]"
    if {[set pgres [sql::exe [cat_query $query $aquery] -t 1]] <= 0} return
    set cnt [pg_result $pgres -cmdTuples]
    if {$cnt <= 0} {
        dia::warn "The command did not update any record"
    } elseif {$cnt != 1} {
        dia::warn "Unexpected return code: \"$cnt\""
    }
    pg_result $pgres -clear
    
    pk $w {_!_}				;#in case pk was changed
    if {$ca(reload)} {ldrec $w -mod 0 [pk $w]}		;#if no reload, v(last*) values don't get updated...
#    foreach i {upr} {m_endis $w $i disabled}
    foreach p $cfig(pwidget$w) {if {$ca(auto)} {$p reload}}	;#used to have -reexec 0
    eval_pstfunc $w $ca(pst)
    $w modified 0
    return 1
}

#Return (or set) the previous value for a field
#------------------------------------------
proc dbe::last {w tag args} {
    variable cfig; variable v
    if {$args != {}} {set v(last.$tag$w) $args}
    return $v(last.$tag$w)
}

#Enable/disable a menu item (and its shortcut button)
#------------------------------------------
proc dbe::m_endis {w tag state} {
    catch {$w.t menu entryconfigure $tag -state $state}	;#it might not exist
}

#Check a field to see if the user needs to populate it
#This is typically called from a pre_add or pre_update script
#------------------------------------------
proc dbe::checkfield {w cmd args} {
    variable cf
    
    set cmd [unabbrev {{force 1} {request 1} {verify 1} {prompt 1} {clear 1}} $cmd]
    if {$cmd == {prompt}} {
        set retval {?}
        if {[llength $cf(tags$w)] <= 0} {return 1}		;#everything's OK
        if {[llength $cf(tags$w)] > 1} {set pl {s}} else {set pl {}}	;#use plural in prompt

        set nw .dbe_checkfield
        set strg "Certain data fields should be examined before you can continue:"
        if {[llength $cf(vers$w)] > 0} {append strg "\n\nFields marked with a blue title contain a value but you are asked to verify its accuracy."}
        if {[llength $cf(reqs$w)] > 0} {append strg "\n\nFields marked with a yellow title should be filled in with a valid value if possible."}
        if {[llength $cf(fors$w)] > 0} {
            append strg "\n\nFields marked with a red title must be filled in with a valid value."
            append strg "\n\nPlease correct the marked field${pl}."
            after idle "$nw.msg configure -bg red"
            if {[dia::dia $nw -mess $strg -default 0 -buttons {Recheck Cancel} -place c] < 0} {set retval 0}
        } else {
            append strg "\n\nPlease examine the marked field${pl}."
            after idle "$nw.msg configure -bg yellow"
            set res [dia::dia $nw -mess $strg -default 0 -buttons {Recheck {Continue Anyway} Cancel} -place c]
            if {$res < 0}	{set retval 0}
            if {$res == 1}	{set retval 1}
        }
        checkfield $w clear
        return $retval

    } elseif {$cmd == {clear}} {
        if {[info exists cf(tags$w)]} {
            foreach tag $cf(tags$w) {[$w.d field $tag title w] configure -bg $cf(bg.$tag$w)}
        }
        lassign {} cf(fors$w) cf(reqs$w) cf(vers$w) cf(tags$w)
    }

    foreach tag $args {
        set val [$w.d get $tag]
        if {$val == {} && $cmd == {force}} {
                set color red;		lappend cf(fors$w) $tag
        } elseif {$val == {} && $cmd == {request}} {
                set color yellow;	lappend cf(reqs$w) $tag
        } elseif {$cmd == {verify}} {
                set color blue;		lappend cf(vers$w) $tag
        } else {
            continue			;#field seems OK
        }
        lappend cf(tags$w) $tag
        set cf(bg.$tag$w) [[set fw [$w.d field $tag title w]] cget -bg]
        $fw configure -bg $color
    }
}

#Add a menu item into a dbe widget
#------------------------------------------
proc dbe::m_add {w tag args} {
    variable cfig
#puts "M_add w:$w tag:$tag args:$args"
    argform {text command help} args

    if {[lcontain {adr clr dlr upr prv rld nxt ldr} $tag]} {	;#if a built-in command
        foreach f {s text help com und} {
            if {![regexp -- -$f $args]} {lappend args -$f $cfig($tag:$f)}
        }
    }
    regsub -all %w $args $w args
#puts "BARGS:$args"
    eval $w.t menu mi $tag $args
}

# Yield/restore preferences
#------------------------------------------
proc dbe::pref {w args} {
    variable cfig
    if {[llength $args] > 0} {eval pref::restore $args; return}
    
    set parr {}
    
#    lappend parr [eval list mdew pref [$w.d pref]]	;#restore mdew fields from last save
    set mdew {}
    foreach rec [$w.d pref] {		;#don't save prefs that restore fields (dbe inits these anyway)
        if {[lindex $rec 0] != {set}} {lappend mdew $rec}
    }
    lappend parr [eval list mdew pref $mdew]

    lappend parr [list configure -adr.prompt $cfig(adr.prompt$w) -upr.prompt $cfig(upr.prompt$w) -dlr.prompt $cfig(dlr.prompt$w)]
#puts "Dump $w pref:[join $parr "\n"]"
    return $parr
}

#Update dependent fields when their source field is edited/changed
#------------------------------------------
proc dbe::auxupdate {w {sflds {}} {force 0}} {
    variable cfig
    variable v
#puts "auxupdate w:$w sflds:$sflds dfields:$cfig(dfields$w)"

    if {$sflds == {}} {			;#if no source fields given, find all
        foreach tag [$w.d tags] {	;#for all entries, find the ones referenced by dependent fields
            set val $cfig(fdep$w.$tag)
            if {$val != {} && ![lcontain $sflds $val]} {lappend sflds $val}
        }
    }
    foreach sf $sflds {			;#now find all fields that depend on each source field
        set dfs {}
        foreach df $cfig(dfields$w) {
            if {$cfig(fdep$w.$df) == $sf} {lappend dfs $df}
        }
#puts " sfield:$sf  dfs:$dfs"
        set sval [$w get $sf]
        foreach df $dfs {
#puts "  df:$df sval:$sval"
            if {$sval == {}} {
                set dval {}
            } else {
                lassign [sql::one "select distinct $df from $cfig(table$w) where $sf = [sql::quote $cfig(table$w) $sf $sval] limit 1;"] dval	;#distinct seems to make it faster in some cases
            }
            if {[$w get $df] != $dval} {$w set $df $dval}	;#so we don't mark dirty needlessly
        }
    }
}

# Call when "contents modified" status changes
#------------------------------------------
proc dbe::modhand {w dirty} {
    variable cfig

#puts "dbe::modhand w:$w dirty:$dirty"

#TODO: add appropriate enable/disables here?
#    foreach i {dlr upr} {m_endis $w $i disabled}
    if {$dirty} {
        $w.t.cln configure -image frown -bg pink
        if {[pk $w] != {}} {
            foreach i {upr} {m_endis $w $i normal}
        }
#        set st {normal}
    } else {
        $w.t.cln configure -image smile -bg lightgreen
        foreach i {upr} {m_endis $w $i disabled}
#        set st {disabled}
    }
#    if {$cfig(menu$w) != {}} {
#        $cfig(menu$w) file mi save configure -state $st
#    }
}

# Get configuration
#------------------------------------------
proc dbe::cget {w option} {
    variable cfig
    argnorm $cfig(swar) option
    set opt [string trimleft $option -]
#puts "cget opt:$opt star:$cfig(star)"
    if {[lcontain $cfig(star) $opt]} {return $cfig($opt$w)}
    return [eval _$w cget $option]
}

# Configure the dbe
#------------------------------------------
proc dbe::configure {w args} {
    variable cfig
    if {$args == {}} {return [_$w configure]}
    foreach tag $cfig(star) {xswitch $tag args cfig($tag$w)}
    if {$args != {}} {return [eval _$w configure $args]}
    return {}
}

# Constructor
#------------------------------------------
proc dbe::dbe {w args} {
    variable cfig
    variable v

#puts "args:$args"
    argform {table menu} args
    argnorm $cfig(swar) args
    set cfig(table$w) [xswitchs table args]	;#get table name
    lassign [wmdd::table $cfig(table$w)] cfig(title$w) help tkind
    set args "[[sql::wmd]::$cfig(table$w) {}] -menu {[list -text "$cfig(title$w) Edit:" -help "A menu of options for viewing and editing records from table:\n$cfig(title$w) ($cfig(table$w)):\n$help"]} $args"		;#default table args
#puts "args:$args"
    foreach tag $cfig(sblk) {set cfig($tag$w) [xswitchs $tag args]}
    foreach {tag val} $cfig(sdef) {
        set cfig($tag$w) $val
        xswitchs $tag args cfig($tag$w)
    }
#puts "Args:$args"

#    set cfig(tags$w) {}				;#list of field tags
    lassign {} mvals fvals
    while {[xswitch m args margs] != {}} {	;#for each menu item
        lappend mvals $margs			;#keep specs for menu item
    }

    set zargs {}
    while {[xswitch f args fargs] != {}} {	;#grab all field descriptions
        lappend zargs $fargs
    }
    if {[llength $zargs] <= 0} {		;#if none given
        foreach tag [[sql::wmd]::$cfig(table$w) {_}] {	;#for each tag belonging to table
            lappend zargs $tag			;#grab default args
        }
    }

    set cfig(dfields$w) {}    
    foreach fargs $zargs {			;#for each field description
        set fargs [lassign $fargs tag]		;#strip off field tag
        argform $cfig(fshort) fargs		;#get rid of shortcut args
        argnorm $cfig(fwar) fargs
#puts "field:$tag"
        lassign [wmdd::column $cfig(table$w) $tag] title help
        set data [wmdd::value $cfig(table$w) $tag]

        set dargs [[sql::wmd]::$cfig(table$w) $tag]	;#defaults from data dictionary
        argnorm $cfig(fwar) dargs
        set fargs [concat [list -title $title: -help "$title ($tag):\n$help" -data $data] $dargs $fargs]		;#put defaults first
        if {[set spf [xswitchs spf fargs]] != {}} {
            if {$spf == {exs}} {
                set spf [list dbe::exist $w %w %d $tag]
                lappend fargs -data $cfig(table$w) -b {-help {Allow the user to choose from values already existing in the database for this field}}
            } elseif {$spf == {zip}} {
                if {[set data [xswitchs data fargs]] == {}} {lassign {city state} ct st} else {lappend $data ct st}
                set spf [list dbe::zip $w %w $tag $ct $st]
                lappend fargs -b {-help {Allow the user to enter a zip code, then fill out the city and state fields automatically}}
            }
            lappend fargs -spf $spf
        }
#puts "Fargs:$fargs"
        foreach sw $cfig(fblk) {		;#grab dbe args with no defaults
            set cfig($sw$w.$tag) [xswitchs $sw fargs]
            if {$sw == {fdep} && $cfig($sw$w.$tag) != {}} {
                lappend fargs -state readonly -write 0	;#dependent fields must always be unwritable
                lappend cfig(dfields$w) $tag
                after idle "$w.d field $tag button configure -bg blue"
            }
        }
        foreach {sw va} $cfig(fdef) {		;#grab dbe args having defaults
            set cfig($sw$w.$tag) $va		;#set default
            xswitchs $sw fargs cfig($sw$w.$tag)	;#extract switch if present
        }

        lappend fvals -f "$tag $fargs"		;#keep remaining args for mdew
    }
    
    if {$tkind == {v}} {
        set cfig(foid$w) [wmdd::view_oid $cfig(table$w)]	;#get name of oid field for views
    }
#puts "foid:$cfig(foid$w)"
    if {$cfig(pkey$w) == {}} {			;#if no key given
        set cfig(pkey$w) [wmdd::pkey $cfig(table$w)]	;#get it from database
        if {$cfig(pkey$w) == {}} {		;#if none found, try to use oid
            if {[set cfig(pkey$w) $cfig(foid$w)] == {}} {error "No primary key defined"}
            lappend fvals -f {oid -hide 1}
            foreach {sw va} $cfig(fdef) {set cfig($sw$w.oid) $va}
            foreach sw $cfig(fblk) {set cfig($sw$w.oid) {}}
        }
    }
#puts "w:$w pkey:$cfig(pkey$w): sep:$cfig(pksep$w):"

    if {[winfo exists $w]} {eval $w configure -class Dbe $args} else {eval wframe::_frame $w -class Dbe $args}
    widginit $w dbe *$w

#puts "mdew::mdew $w.d $fvals"
    eval mdew::mdew $w.d $fvals

    if {$cfig(menu$w) != {}} {
        mbar::mbar $w.t -mb "menu $cfig(menu$w)" 	;#-gmc.bf {-fill x -exp 1}
        pack $w.t -side top -fill x

        label $w.t.cln -help "This tells whether any of the data entries have been changed since the last load or initialization"
        pack $w.t.cln -side right
        bind $w.d <<Modified>> "dbe::modhand $w %s"
        modhand $w 0

        if {$cfig(record$w) != {}} {		;#show current record id
            eval dew::dew $w.t.rid ent -textv dbe::v(recid$w) -just r -help \{The identifying ID for the currently loaded record\} -state readonly $cfig(record$w)
            pack $w.t.rid -side right
        }
    }
    pack $w.d -side top -exp 0 -fill both

    foreach val $mvals {eval m_add $w $val}	;#build menu items
    $w.t menu mi sep
    $w.t menu mi clrp {Clear prompt}	-type checkbutton -variable dbe::cfig(clr.prompt$w) -help {Ask for confirmation before clearing the editing pane}
    $w.t menu mi adrp {Add prompt}	-type checkbutton -variable dbe::cfig(adr.prompt$w) -help {Ask for confirmation before adding a new record}
    $w.t menu mi uprp {Update prompt}	-type checkbutton -variable dbe::cfig(upr.prompt$w) -help {Ask for confirmation before updating a record}
    $w.t menu mi dlrp {Delete prompt}	-type checkbutton -variable dbe::cfig(dlr.prompt$w) -help {Ask for confirmation before deleting a record}
    $w.t menu mi ldrp {Load prompt}	-type checkbutton -variable dbe::cfig(ldr.prompt$w) -help {Ask for confirmation before loading a new record when the current editing pane has been modified}
    $w.t menu mi sep
    $w.t menu mi print {Print Grab}	-command "print::grab $w" -help {View a printable rendering of the editing pane}
    $w.t menu mi prev  {Preview Table}	-command "dbp::table $cfig(table$w) -ewidget $w" -help "Launch a toplevel window containing a preview listing for the table: $cfig(title$w)"
    $w.t menu mi sep
    $w.t menu mi help {Widget Help}	-command {help::locate dbe.html} -help {Instructions on using the DBE (DataBase Editing) Widget}

    foreach tag $cfig(dfields$w) {		;#prepare dependent fields to clear/update
        set ent [$w.d field $cfig(fdep$w.$tag) w]
#        bind $ent <<Changed>> "dbe::auxupdate $w $cfig(fdep$w.$tag)"	;#triggers on internal changes :(
        foreach ev {<FocusOut>} {		;#also <leave>?
            bind $ent $ev "dbe::auxupdate $w $cfig(fdep$w.$tag)"
        }
    }

    set cfig(hist$w) {}
    set cfig(hidx$w) 0
    pk $w {}
    if {$cfig(preclear$w)} {
        clear $w -prompt 0 -mod 0
    } else {
        foreach {sw va} [$w.d get] {set v(last.$sw$w) $va}	;#init previous values
    }
    return $w
}

#The widget command
#------------------------------------------
proc dbe::wcmd {w cmd args} {
    variable cfig; variable v
    set cmd [unabbrev {{menu 2} {clear 2} {add 2} {update 2} {delete 2} {last 2} {checkfield 3} {next 2} {reload 3} {previous 4} {load 2} {primarykey 3 pk} {keyload 4} {keywhere 4} {frame 3} {force 3} {request 3} {verify 3} {preference 4 pref} {configure 2} {cget 2} {quoted 1}} $cmd]
    if {[lcontain {pref clear add delete last checkfield keyload pk quoted keywhere cget configure} $cmd]} {
        return [eval $cmd $w $args]
    }
    switch -exact $cmd {
        {w}		{return $w}
        {menu}		{return [eval $w.t $args]}
        {next}		{eval ldhist $w 1}
        {reload}	{eval ldhist $w 0}
        {previous}	{eval ldhist $w -1}
        {load}		{eval ldrec $w $args}
        {update}	{eval updrec $w $args}
        {force}		{eval checkfield $w force $args}
        {verify}	{eval checkfield $w verify $args}
        {request}	{eval checkfield $w request $args}
        {auxupdate}	{eval auxupdate $w $args}
        {frame}		{return [eval _$w $args]}
        {mdew}		{return [eval $w.d $args]}
        {obey}		{}
        {default}	{return [eval $w.d \$cmd $args]}
    }
}

if {[info commands locawyze] != {}} {locawyze dbe}
