package provide wylib 0.30	;#Oct 2001
package require BLT
# Maintain application preferences in an rc file.
#------------------------------------------
# Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:
# 
# Free Software Foundation, Inc.
# 51 Franklin Street, Fifth Floor
# Boston, MA  02110-1301, USA

#------------------------------------------
#TODO:
#X- Special color and font types (implement in dew)
#X- new colors don't show up in global prefs after a restart
#X- reload prefs from rc file for each page in edit
#X- use multiple priority levels
#X- only apply appropriate settings (exclude inapplicable resolutions)
#- change def switch to init?
#- 
#- LATER:
#- allow for multiple pref modules in a single app (like: potool, purchase, apinv)
#- should we have a wyatt wrapper for the tabset (move BLT dependency behind a wyatt widget)
#- 

namespace eval pref {
    namespace export init auto restore clean
    variable cfig
    variable v
    variable font

    #Global preference definitions
    set cfig(all.defs) {
	{g_efont	ent	{Entry Font:}		-res {Entry font}	-help {Default font for entry fields}	-spf fnt -state readonly}
	{g_lbfont	ent	{Listbox Font:}		-res {Listbox font}	-help {Default font for listboxes}	-spf fnt -state readonly}
	{g_tfont	ent	{Textbox Font:}		-res {Text font}	-help {Default font for textboxes}	-spf fnt -state readonly}
	{g_lfont	ent	{Label Font:}		-res {Label font}	-help {Default font for labels}		-spf fnt -state readonly}
	{g_bfont	ent	{Button Font:}		-res {Button font}	-help {Default font for buttons}	-spf fnt -state readonly}
	{g_mbfont	ent	{Menubutton Font:}	-res {Menubutton font}	-help {Default font for menu buttons}	-spf fnt -state readonly}
	{g_mufont	ent	{Menu Font:}		-res {Menu font}	-help {Default font for menu items}	-spf fnt -state readonly}
	{g_ckfont	ent	{Checkbutton Font:}	-res {Checkbutton font}	-help {Default font for check buttons}	-spf fnt -state readonly}
	{g_helpbs	chk	{Enable Help Balloons:}	-textv help::cfig(balloons) -def 1 -help {Pop up these little help messages when available}}
	{g_hbbgnd	ent	{Help Popup Background:} -res {Helpbal.l background Label} -help {Background color for help balloons}	-spf col -state readonly}
	{g_ebgnd	ent	{Entry Background:}	-res {Entry background}   -spf col -help {Default background color for entries}}
	{g_tbgnd	ent	{Textbox Background:}	-res {Text background}    -spf col -help {Default background color for textboxes}}
	{g_lbbgnd	ent	{Listbox Background:}	-res {Listbox background} -spf col -help {Default background color for listboxes}}
    }

    if {[info exists ::env(WYLIB_RESOLUTION)]} {	;# for testing at alternate resolutions
        set cfig(sres)	$::env(WYLIB_RESOLUTION)
    } else {
        set cfig(sres) "[winfo screenwidth .]x[winfo screenheight .]"	;#current screen resolution
    }
    set cfig(scct) {{all gbl startupFile} {%res gbl userDefault} {%mod gbl interactive} {%mod %mod interactive}}	;#standard preference page types
    set cfig(gbl.flds) {}
    set cfig(sccu) {}
}

# Helper function to fix poorly parsed files (reconnects lines with newline characters in them)
#------------------------------------------
proc pref::clean {l} {
    set i 0
    while {$i < [expr [llength $l] - 1]} {
        set n 0
        set skip 0

        # recreate the list manually using '{' and '}' characters
        # current depth in tree is n
        foreach c [split [lindex $l $i] {}] {
            if {$skip == 1} {
                set skip 0
            } else {
                switch -- $c {
                    \\   { set skip 1 }
                    \{   { set n [expr $n + 1] }
                    \}   { set n [expr $n - 1] }
                }
            }
        }

        # tree broken?
        if {$n != 0} {
            # tree borked, combine with next in list
            set l [lreplace $l $i [expr $i + 1] "[lindex $l $i]\n[lindex $l [expr $i + 1]]"]
        } else {
            # tree clean, move on
            incr i
        }
    }
    return $l
}

# Save/restore automatic preferences for a widget in the current app
#------------------------------------------
proc pref::auto {wtag args} {
    variable cfig

    argnorm {{application 3 app}} args
    if {[set app [xswitchs app args]] == {}} {set app [lib::cfig appname]}
    
    set rcfile [file join [lib::cfig appdir] "$app.$wtag.rc"]
    if {$args == {}} {
#puts "Fetching prefs from: $rcfile"
        if {[file exists $rcfile]} {return [clean [split [read_file $rcfile] "\n"]]}
    } else {
#puts "Saving prefs to: $rcfile\n[join $args "\n"]"
        write_file $rcfile [join $args "\n"]
    }
}

# Apply saved module settings with error handling for use by modules' prefs functions
#------------------------------------------
proc pref::restore {args} {
    uplevel {
        foreach cmd $args {
            if {$cmd == {}} continue
#puts "Apply $w pref: $cmd"
#            eval $w $cmd		;#for debugging
            if {[catch {eval $w $cmd} msg]} {
                dia::err "While restoring module settings in module [namespace current].\nSome settings may have been lost.\nMessage: $msg"
            }
        }
    }
}

# Set all default values for a given scope (gbl or <module_name>)
#------------------------------------------
proc pref::defaults {scop} {
    variable cfig
    foreach tag $cfig($scop.flds) {
        if {$cfig($scop.$tag.textv) != {}} {
            if {[info exists cfig($scop.$tag.def)]} {
                uplevel #0 set $cfig($scop.$tag.textv) [list $cfig($scop.$tag.def)]
            } else {
                uplevel #0 set $cfig($scop.$tag.textv) \{\}
            }
        }
    }
}

# Record a field (settable item) for later use in prefs screen
#------------------------------------------
proc pref::f_add {args} {
    variable cfig
    argform {tag type title textv} args
    argnorm {{scope 2 scop} {type 2} {default 2 def} {title 2} {textvariable 5 textv} {resource 2 res} {geometry 2 geom}} args
    if {[set scop [xswitchs scop args]] == {}} {set scop [lib::cfig appname]}
    set tag [xswitchs tag args]
    lappend cfig($scop.flds) $tag

    foreach {s} {def type geom} {xswitchs $s args cfig($scop.$tag.$s)}
    foreach {s} {res textv} {set cfig($scop.$tag.$s) [xswitchs $s args]}
    set cfig($scop.$tag.args) $args
#puts "f_add:$scop tag:$tag res:$cfig($scop.$tag.res):"
}

# Load applicable rc file(s) and prepare for future calls to set prefs
#------------------------------------------
proc pref::init {args} {
    variable cfig

#    argform {} args
    argnorm {{module 2 mod} {apply 2} {field 1 f}} args
    if {[set m [xswitchs mod args]] == {}} {set m [lib::cfig appname]}
    array set cfig "$m.flds {}"
#puts "pref::init m:$m args:$args"
    foreach s {apply} {set cfig($m.$s) [xswitchs $s args]}
    
    if {$cfig(gbl.flds) == {}} {	;#init global options if not yet done
        foreach rec $cfig(all.defs) {eval f_add $rec -scope gbl}
    }

    while {[xswitch f args va] != {}} {eval f_add $va -scope $m}	;#init module options
    defaults gbl			;#set all options to their defaults
    defaults $m

#Form list of pref files and restore them if files exist
    set foundres 0			;#note when we find the current resolution
    foreach rec $cfig(scct) {		;#for each possible type of pref file
        lassign $rec vari scop prio	;#get variety and scope of option page
        if {$vari == {%res}} {		;#grab any already existing resolution files
            foreach f [glob -nocomplain "[lib::cfig appdir]/\[0-9\]*x\[0-9\]*.$scop.rc"] {
                regexp -- ".*/(\[0-9\]*x\[0-9\]*)\.${scop}\.rc" $f junk res
                lappend cfig(sccu) [list $res $scop $prio]
                if {$res == $cfig(sres)} {
                    load_cfg $res $scop $prio
                    incr foundres
                }
            }
            if {!$foundres} {lappend cfig(sccu) [list $cfig(sres) $scop $prio]}
        } else {
            if {$vari == {%mod}} {set vari $m}
            if {$scop == {%mod}} {set scop $m}
            load_cfg $vari $scop $prio
            lappend cfig(sccu) [list $vari $scop $prio]
        }
    }
#puts "sccu:$cfig(sccu)"
}

# Save all preferences to their respective files
#------------------------------------------
proc pref::save {mod} {
    variable cfig
    variable v
#puts "save mod:$mod"
    foreach rec $cfig(sccu) {		;#for each page of preferences
        lassign $rec vari scop prio
        set ptag ${scop}_${vari}	;#tag for this page
        set fname [file join [lib::cfig appdir] $vari.$scop.rc]
#puts " file: $fname"
        set olines {}
        foreach fld $cfig($scop.flds) {		;#for each field
            if {!$v($ptag.$fld.ck)} continue		;#skip if value not asserted
#puts "  fld:$fld"
            lappend olines [list $fld $v($ptag.$fld)]
        }
        write_file $fname [join $olines "\n"]
    }
}

# Load a configuration file
#------------------------------------------
proc pref::load_cfg {vari scop prio} {
    variable cfig
    variable v
    set fname [file join [lib::cfig appdir] $vari.$scop.rc]
#puts "load_cfg:$fname"
    if {![file exists $fname]} {return 0}
    set ptag ${scop}_${vari}				;#tag for this page
    set plist {}
    foreach ln [split [read_file $fname] "\n"] {	;#for each file line
        lassign $ln ftag fval			;#get tag/value pair
        if {$ftag == {}} continue
#puts " ftag:$ftag fval:$fval"
        if {![lcontain $cfig($scop.flds) $ftag]} {	;#if not a field we recognize
            dia::warn "Illegal preference field: $ftag in file: $fname\n\nYou should re-save your preferences to fix this."
            continue
        }
        set pref::v($ptag.$ftag.ck) 1			;#assert in prefs screen
        if {$prio != {0}} {
#puts "  apply_opt $scop $ftag $fval $prio"
            apply_opt $scop $ftag $fval $prio
        }
        lappend plist $ftag $fval
    }
    return $plist
}

# Apply a single option to the local environment
#------------------------------------------
proc pref::apply_opt {scop ftag fval {prio interactive}} {
    variable cfig
    variable v
    if {$cfig($scop.$ftag.res) != {}} {		;#if this is a resource
        lassign $cfig($scop.$ftag.res) rclass ropt rforce

        set ospec "*$rclass.$ropt"
        option add $ospec $fval $prio
#puts "option add $ospec {$fval} $prio"
        config_tree . $fval $rclass $ropt
    } elseif {[set vname $cfig($scop.$ftag.textv)] != {}} {	;#if a text variable given

#why did we do this after-idle thing:?
#        if {[info exists $vname]} {
#            set $vname $fval
#        } else {
#           after idle "set $vname $fval"
#        }
        uplevel #0 [list set $vname $fval]
    }
}

# Configure all currently open widgets under and including this one
#------------------------------------------
proc pref::config_tree {w fval rclass ropt} {
    set class [winfo class $w]
#puts "\nw:$w class:$class rclass:$rclass"

    set mlist [split $rclass .]		;#in case class has multiple path members
    set m0 [lindex $mlist 0]		;#toplevel class
    if {$class == $m0} {
        if {[llength $mlist] > 1} {
            set subwin [join [lreplace $mlist 0 0 $w] .]
#puts "  subwin:$subwin"
            if {[winfo exists $subwin]} {
#puts "  $subwin configure -$ropt $fval"
                $subwin configure -$ropt $fval
            }
        } else {
#puts "  $w configure -$ropt $fval"
            $w configure -$ropt $fval
        }
    }
    foreach child [winfo children $w] {config_tree $child $fval $rclass $ropt}
}

# Assert all selected values into their target variables and/or widgets
#------------------------------------------
proc pref::apply {mod} {
    variable cfig
    variable v

    set arglist {}
    foreach rec $cfig(sccu) {		;#for each page of preferences
        lassign $rec vari scop prio
        if {$scop == {gbl} && ![lcontain "all $cfig(sres) $mod" $vari]} continue	;#skip resolutions we're not running at
        set ptag ${scop}_${vari}	;#tag for this page
#puts "scop:$scop vari:$vari"
        foreach fld $cfig($scop.flds) {		;#for each field
            if {!$v($ptag.$fld.ck)} continue	;#skip if value not asserted
#puts " fld:$fld"
            apply_opt $scop $fld $v($ptag.$fld) $prio
        }
    }

    eval $cfig($mod.apply)			;#execute the user script
}

# Create a sample widget that fits a given option specification and extract 
# a default setting from it to see what it draws from the option database
#------------------------------------------
proc pref::widget_default {res} {
    lassign $res rclass ropt rforce	;#get parts of resource
#puts "res:$res"
    set mlist [split $rclass .]		;#in case class has multiple path members
    set m0 {}
    set path {}
    set i 1
    foreach pm $mlist {			;#for each element of path
        set p [string tolower $pm]	;#lower case version of element
        if {$i == [llength $mlist] && $rforce != {}} {set class $rforce} else {set class {Frame}}	;#if last element, use forced class if present
        if {$p == $pm} {		;#if not capitalized, create a named element
            append path .$pm		;#use literal name
            frame $path -class $class	;#and model it as a frame
#puts " frame $path -class $class"
        } else {			;#else make it a class element
            append path .__$pm
            if {[lcontain {button canvas checkbutton entry frame label listbox menubutton menu message radiobutton scale scrollbar text} $p]} {
                $p $path
#puts " $p $path"
            } else {
                frame $path -class $pm
#puts " frame $path -class $pm"
            }
            set class $pm
        }
        if {$m0 == {}} {set m0 $path}	;#remember base level widget
        incr i
    }
    if {[set opt [option get $path $ropt $class]] == {}} {	;#first try to fetch default from option database
        catch {set opt [$path cget -$ropt]}		;#next try from the sample widget itself
    }
#puts "  option get $path $ropt $class:$opt"
    destroy $m0				;#kill the sample widget when finished
    return $opt
}

# Edit Application Preferences
#------------------------------------------
proc pref::edit {{mod {}}} {
    variable cfig
    variable v
    if {$cfig(sccu) == {}} {dia::err "No preferences defined"; return}
    if {$mod == {}} {set mod [lib::cfig appname]}
#puts "pref::edit mod:$mod"
    set w .pref_$mod
    if {[catch {toplevel $w -class Pref}]} {raise $w; return}
    wm title $w {Edit User Preferences}

    mbar::mbar $w.mu -help {Main menu}
    $w.mu mb file -help {Functions for controlling user preferences settings}\
      -mi "ap Apply {pref::apply $mod} {Apply these values to the running program} -s Apply -hot C-a"\
      -mi "sv Save {pref::apply $mod; pref::save $mod} {Apply these values and save them to be used each time the program starts} -s Save -hot C-s"\
      -mi "he {Widget Help} {help::locate pref.html} -help {Instructions on using Preferences Settings}"\
      -mi "cl Close {destroy $w} {Close the preferences window} -s Close -hot C-w"

    tabs::tabs $w.t -relief flat -samewidth 1 -bd 0 -highlightthickness 0 -side left
    pack $w.mu -side top -exp 0 -fill x
    pack $w.t -side top -exp 1 -fill both

    foreach rec $cfig(sccu) {		;#for each page of preferences
        lassign $rec vari scop prio
        set ptag ${scop}_${vari}	;#tag for this page
        if {$scop == {gbl}} {
            set st {Global Settings}
            set sh {These options are common to all applications}
        } else {
            set st "[cap_first $mod] Settings"
            set sh {These settings are specific to this application or module only}
        }
        if {$vari == {all}} {
            set ct {All Apps}
            append sh { and when set here will affect all applications and modules}
        } elseif {$vari == [lib::cfig appname]} {
            set ct "[cap_first $vari] only"
            append sh { and when set here will only take effect when running this application}
        } else {
            set ct "$vari screen"
            append sh { but the settings selected here will only take effect when running at a screen resolution of } $vari
        }
#puts "scop:$scop vari:$vari"
        if {$cfig($scop.flds) == {}} continue		;#if no application prefs
        frame [set f $w.t.f_$ptag]
        $w.t insert 0 $ptag -text "$st\n$ct" -window $f -anchor n -help $sh

        label $f.ft -text {Preference Setting}
        label $f.fc -text {Enabled}
        grid $f.ft $f.fc
        foreach fld $cfig($scop.flds) {		;#for each field in this scope
#puts " scop:$scop fld:$fld"
            set args {}
            if {[info exists cfig($scop.$fld.def)]} {	;#if default given
#puts " def: $cfig($scop.$fld.def)"
                set v($ptag.$fld) $cfig($scop.$fld.def)
            } elseif {$cfig($scop.$fld.res) != {}} {	;#else if resource given
#puts " res:$cfig($scop.$fld.res)"
                set v($ptag.$fld) [widget_default $cfig($scop.$fld.res)]	;#create a widget and use its default
            } elseif {$cfig($scop.$fld.textv) != {}} {			;#else use current textvariable value
#puts " textv: $cfig($scop.$fld.textv)"
                set v($ptag.$fld) [subst \$$cfig($scop.$fld.textv)]
            }
            
#puts "dew::dew $f.$fld -style $cfig($scop.$fld.type) -textv pref::v($ptag.$fld) $args $cfig($scop.$fld.args)"
            eval dew::dew $f.$fld -style $cfig($scop.$fld.type) -textv pref::v($ptag.$fld) $args $cfig($scop.$fld.args)
            checkbutton $f.${fld}_ck -variable pref::v($ptag.$fld.ck) -help {Enable this preference value, overriding program defaults}
            grid $f.$fld $f.${fld}_ck -sticky e
        }
        foreach {fld val} [load_cfg $vari $scop 0] {	;#now overlay current rc file settings
#puts "set v($ptag.$fld) $val"
            set v($ptag.$fld) $val
        }
    }
}
