package provide wylib 0.30	;#Dec 2005
#Run custom reports in a text window
#------------------------------------------
# Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:
# 
# Free Software Foundation, Inc.
# 51 Franklin Street, Fifth Floor
# Boston, MA  02110-1301, USA

#TODO:
#X- how does print/spell/search get into proper menus
#X- how to store chunklets of report for running later
#X- how to automatically re-run report on master dbe reload
#X- how to include dbe at top of report
#X- make hyperlink for drilling (rather than parsing data line)
#- how to include a graph with the report?
#- why is etext::smiley still green after first report run?
#- 

option add *Report*Text.width 180 widgetDefault
option add *Report*Text.height 80 widgetDefault

namespace eval report {
    namespace export report
    variable cfig
    
    set cfig(swar) {{tag 2} {procedure 2 proc} {header 2} {text 2} {query 2} {menu 2} {passedarguments 2 pargs} {editarguments 2 eargs} {see 1} {run 1} {mode 2}}
    set cfig(sdef) {menu {Report:} run yes}
    set cfig(sblk) {pargs eargs see header mode}
    set cfig(workdir)        [lib::cfig workdir]
}

# Open a report toplevel window
# This is called indirectly by the application as the report procedure itself
#-----------------------------------------------------
proc report::new_win {tag name args} {
    variable cfig
#puts "new_win tag:$tag name:$name args:$args"
    if {$args == {w}} {			;#common error
        error "Report functions should have a tag different from the function name"
    }
    foreach sw {run} {xswitchs $sw args cfig($sw.$tag)}	;#override certain defined switch values
    
    set cfig(cargs.$tag) $args		;#arguments from calling program
    set w [top::top $tag -build "report::build_win %w $tag" -title {Report:} -reopen "$name $args"]
}

# Jump here when a hot link is pressed in the report
#-----------------------------------------------------
proc report::link {w tag idx} {
    variable cfig
#puts "link! w:$w tag:$tag idx:$idx next:[$w.edit tag nextrange link $idx] prev:[$w.edit tag prevrange link $idx]"
    lassign [split $idx .] y x
    lassign [$w.edit tag prevrange link $idx] idx1 idx2
    set linktext [$w.edit get $idx1 $idx2]
#puts "    idx1:$idx1 idx2:$idx2 linktext:$linktext"
    if {![string is integer $linktext]} {set linktext 1}
    event generate $w.edit <<Link>> -x $x -y $y -serial $linktext
}

# Populate a report toplevel window with its text widget and other optional items
# This is called by top after making a new window
#-----------------------------------------------------
proc report::build_win {w tag} {
    variable cfig

    set cfig(tag$w) $tag
#puts "header:$cfig(header.$tag)"
    if {$cfig(header.$tag) != {}} {
        top::add [eval mdew::mdew $w.head [translit "\n" { } $cfig(header.$tag)]]
        pack $w.head -side top -fill x
    }
    
    top::add [eval etext::etext $w.edit -menu $w.m $cfig(eargs.$tag) -mode txt]		;#eargs are any args to be applied to the editing window
    if {"$cfig(mode.$tag)" != "lout"} {
        pack $w.edit -side top -fill both -exp 1
    }

    #Provide a default tag for hyperlinks (user routine will have to bind it to something)
    set curs [$w.edit cget -cursor]
    $w.edit tag configure link -foreground blue
    $w.edit tag bind link <Enter> "$w.edit configure -cursor top_left_arrow"
    $w.edit tag bind link <Leave> "$w.edit configure -cursor $curs"
#    $w.edit tag bind link <1> "event generate $w.edit <<Link>> -detail \[$w.edit index @%x,%y\]"
    $w.edit tag bind link <1> "report::link $w $tag \[$w.edit index @%x,%y\]"

    top::add $w.obey -alias "report::obey $w"

    $w menu tools mi run	{Run Report}	"report::run $w"	-s {Run -bg lightgreen -bd 2 -gmc {-fill x -exp 1}}	{Re-execute the report}
    $w menu tools mi arun	{Auto Run}	-type checkbutton	-s Auto -variable report::cfig(run.$tag) -help {Automatically run the report each time this window is opened, or when the entry it is linked to changes its data.}
#    $w menu tools mi print	{Print Report}	"$w.edit menu invoke pr" -s {Print}	{Print the report}
    $w menu help mi rhelp	{Using Reports}	"help::locate report.html" -help {Get help using this window (reports)} -before app
    if {$cfig(run.$tag)} {after idle "report::run $w"}
}

# When a new value is loaded in a master dbe, re-run the report
#-----------------------------------------------------
proc report::obey {w args} {
    variable cfig
    if {$cfig(run.$cfig(tag$w))} {
#puts "report::obey w:$w args:$args"
        run $w		;#throw away the args from the master dbe (we already know its name)
    }
}

# Run the script to generate the report
#-----------------------------------------------------
proc report::run {w} {
    variable cfig

#puts "run $w tag:$cfig(tag$w)"
    set tag $cfig(tag$w)
    set textstate [$w.edit text cget -state]
    set yview [lindex [$w.edit yview] 0]
    $w.edit text configure -state normal
    $w.edit clear
    lib::cwatch [$w.edit w]
    foreach {type chunk} $cfig(chunks.$tag) {	;#load up the query chunklets
#puts "type:$type chunk:$chunk"
        if {"$cfig(mode.$tag)" != "lout"} {
            switch -- $type {
                {-text} {			;#insert a string (with substitution)
#puts "text:$chunk"
                    eval $w.edit text insert end $chunk
                
                }
                {-query} {			;#run a query
                    lassign $chunk query fmt
#puts "query:$query $fmt"
                    set pgres [sql::exe [subst $query]]
                    set cnt [pg_result $pgres -numTuples]
                    for {set i 0} {$i < $cnt} {incr i} {
                        set res [pg_result $pgres -getTuple $i]
                        $w.edit text insert end "[eval "format \{$fmt\} $res"]\n" ;#"
                    }
                    pg_result $pgres -clear
                }
                {-proc} {			;#call a procedure which returns text
#puts "pargs:$cfig(pargs.$tag) cargs:$cfig(cargs.$tag)"
                    set fargs [concat _tw _hw $cfig(pargs.$tag)]	;#add passed arguments so the function can know the name of the text widget and header widget
                    proc temp_proc $fargs $chunk			;#make a procedure from the code chunk
#puts "[list proc temp_proc $fargs [info body temp_proc]]"
                    $w.edit text insert end [eval temp_proc \$w.edit \$w.head $cfig(cargs.$tag)]	;#and execute it
                }
                default {dia::err "Unknown report chunk type: $type"}
            }
        } else {
            set fargs [concat _tw _hw $cfig(pargs.$tag)]        ;#add passed arguments so the function can know the name of the text widget and header widget
            proc temp_proc $fargs $chunk                        ;#make a procedure from the code chunk

            # create a lout file
            set lfile $cfig(workdir)/report$w.lout
            set pfile $cfig(workdir)/report$w.ps
            set fp [open $lfile w+]
            puts $fp [eval temp_proc \$w.edit \$w.head $cfig(cargs.$tag)]
            close $fp

            # display the lout file via ghostview
            lout::parse $lfile $pfile
            lout::preview -file $pfile
        }
    }
    
    lib::cnorm [$w.edit w]
    $w.edit yview moveto $yview
#        $w.edit text configure -state $textstate
    if {$cfig(see.$tag) != {}} {$w.edit text see $cfig(see.$tag)}
}

#Launch a command from the window
#------------------------------------------
proc report::launch {w} {
    variable cfig
    
    if {$cfig(launchcmd$w) == {}} return
    lassign [split [$w.t.text index insert] .] linenum col
    set line [$w.t.text get $linenum.0 $linenum.end]
#puts "linenum:$linenum line:$line"
    lib::cwatch $w.t.text
    eval $cfig(launchcmd$w) \{$line\}
    after 1000 "lib::cnorm $w.t.text"
}

# Define a procedure or a group of procedures/queries/code-bits for a report
#----------------------------------------------------
proc report::report {name args} {
    variable cfig

    argform {pargs proc} args
    argnorm $cfig(swar) args
    if {[set tag [xswitchs tag args]] == {}} {
        regsub -all {::} $name {_} tag
        if {$tag == $name} {set tag ${name}_tag}	;#make sure tag is different from name
    }
    foreach {s va} $cfig(sdef) {set cfig($s.$tag) $va; xswitchs $s args cfig($s.$tag)}
    foreach s $cfig(sblk) {set cfig($s.$tag) [xswitchs $s args]}

    set cfig(chunks.$tag) $args		;#any arguments left should constitute code chunks to produce the report
#puts "tag:$tag pargs:$cfig(pargs.$tag) chunks:$cfig(chunks.$tag)"

    uplevel #0 [list proc $name args "eval report::new_win $tag $name \$args"]		;#the procedure that opens the report window
#puts "name:$name body:[info body $name]:"
}

# Format a single line of a report with possible links
#----------------------------------------------------
proc report::line {rec fmtlist {links {}} {totals {}} {totvar {}}} {
    if {$totvar != {}} {upvar $totvar tots}

    for {set f 0} {$f < [llength $fmtlist]} {incr f} {	;#for each field
        set fmt [lindex $fmtlist $f]
        set val [string trim [lindex $rec $f]]
        if {$f != 0} {set value " [format $fmt $val]"} else {set value [format $fmt $val]}
        lappend elarr $value
        if {[lcontain $links $f]} {lappend elarr link} else {lappend elarr {}}

        if {[lcontain $totals $f]} {
            if {![info exists tots($f)]} {set tots($f) 0.00}
            if {$val != {}} {set tots($f) [rpn $tots($f) $val +]}
        }
    }
    lappend elarr "\n" {}
    return $elarr
}

# A helper function to format the results of a query and insert them into a report window
#----------------------------------------------------
proc report::query {tw hdrlist fmtlist query args} {

    argform {links totals} args
    argnorm {{links 1} {totals 1} {hyperlink 1 hyp} {balance 1 bal} {forward 1 fwd}} args
    foreach s {links totals hyp bal} {set $s [xswitchs $s args]}
    lassign {0.00} fwd
    foreach s {fwd} {xswitchs $s args $s}
#puts "query:$query"
    $tw insert end "[eval format \$fmtlist $hdrlist]\n"
    set elarr {}
    foreach rec [sql::qlist $query] {				;#for each record
        if {$bal != {}} {					;#if running balance field specified
            set fwd [rpn $fwd [lindex $rec $bal] +]
            set rec [lreplace $rec $bal $bal [comma_dollar $fwd]] ;#replace the list element with a running balance
        }
        eval lappend elarr [line $rec $fmtlist $links $totals tots]
    }
#puts "elarr:$elarr"
    if {[llength $elarr] > 0} {eval $tw insert end $elarr}	;#its faster to do a single insert
    if {[llength $totals] > 0 && [info exists tots([lindex $totals 0])]} {
        for {set f 0} {$f < [llength $fmtlist]} {incr f} {	;#for each field
            if {$f == 0} {
                set val {Totals}
            } elseif {![lcontain $totals $f]} {
                set val {}
            } else {
                set val [comma_dollar $tots($f)]
            }
            set fmt [lindex $fmtlist $f]
#puts "val:$val fmt:$fmt"
            if {$f != 0} {$tw insert end { }}
            $tw insert end [format $fmt $val] 
        }
        $tw insert end "\n"
    }
    if {$hyp != {}} {
        bind $tw <<Link>> "report::linkcall $tw %x %y $hyp"
    }
}

# A helper function to find the value of a hyperlink and call a procedure on it
#----------------------------------------------------
proc report::linkcall {tw x y args} {
#puts "linkcall tw:$tw x:$x y:$y args:$args"

    lassign [$tw tag prevrange link $y.$x] idx1 idx2
    set linktext [string trim [$tw get $idx1 $idx2]]
#puts "    idx1:$idx1 idx2:$idx2 linktext:$linktext"
    lib::cwait $tw
    eval $args \$linktext
    lib::cnorm $tw
}
