package provide wylib 0.30	;#Oct 2001
#Wyattized tabset widget, a wrapper around blt::tabset
#------------------------------------------
# Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:
# 
# Free Software Foundation, Inc.
# 51 Franklin Street, Fifth Floor
# Boston, MA  02110-1301, USA

#TODO:
#X- add modified routine
#- 

namespace eval tabs {
    namespace export tabs
    variable cfig
}

# Insert a new tab
#------------------------------------------
proc tabs::insert {w pos name args} {
    variable cfig

    argnorm {{help 2} {window} 2} args
    set help [xswitchs help args]	;#grab help parm
    set window [xswitchs window args]
    if {$help != {}} {help::init $window $help}
    $w bind $name <Motion> "+help::motion $window"
    $w bind $name <Leave> "+help::leave $window"

    return [eval ::tabs::_$w insert $pos $name -window $window $args]
}

# Create a tabset
#------------------------------------------
proc tabs::tabs {w args} {
    variable cfig
    eval blt::tabset $w $args
    widginit $w tabs *$w
    
    return $w
}

# Widget command
#------------------------------------------
proc tabs::wcmd {w cmd args} {
    variable cfig
#puts "w:$w cmd:$cmd args:$args"
    set cmd [unabbrev {{insert 2}} $cmd]
    if {[lcontain {insert} $cmd]} {
        return [eval $cmd $w $args]
    } elseif {$cmd == {w}} {
        return $w
    } 
    return [eval _$w $cmd $args]
}

#bind Tab <Leave>	{+help::leave %W}	;#doesn't seem to work
#bind Tab <Motion>	{+help::motion %W}
