package provide wylib 0.30	;#Sep 2005
# Communicate with various web interfaces
# These are dependent upon various providers' web sites and so are subject to change
#------------------------------------------
# Copyright (C) 1999-2005 Wyatt-ERP LLC.  All other rights reserved.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:
# 
# Free Software Foundation, Inc.
# 51 Franklin Street, Fifth Floor
# Boston, MA  02110-1301, USA

#TODO:
#- 

package require http 2.0

namespace eval web {
    namespace export web zip fetch view
    variable cfig
#    set cfig(zipurl)		{http://zip4.usps.com/zip4/zip_responseA.jsp}
#    set cfig(zipfield)		{zipcode}
    set cfig(zipurl)		{http://zip4.usps.com/zip4/zcl_3_results.jsp}
    set cfig(zipfield)		{zip5}
    set cfig(browser)		{/usr/bin/firefox %s}
    set cfig(lynx)		{/usr/bin/lynx -dump -width 10000}
}

# Fetch a URL with a POST query.  Return the HTML page as a string
#----------------------------------------------------
proc web::fetch {url query {timeout 5000} {chunk 4096}} {

    set token [http::geturl $url -query $query -blocksize $chunk -timeout $timeout]
    upvar #0 $token state
    
    foreach {name value} $state(meta) {
        if {[regexp -nocase ^location$ $name]} {	;# Handle URL redirects
            return [fetch [string trim $value] $query $timeout $chunk]
        }
    }
#puts "META:$state(meta)"
#puts "BODY:$state(body)"
    return $state(body)
}

# Get text from the USPS showing cities in a zip code area, select a city,state
# !!This must change if the web site format changes!!
# When the web site changes, uncomment the text: line and look for strings that reliably mark the beginning and end of the city data.
# Enter these strings on the [meat string begin end] line
# Then uncomment the meat: line and make sure the regexp lines correctly find the city, state and comment data
#----------------------------------------------------
proc web::zip {code} {
    variable cfig

    set code [lindex [split $code -] 0]			;#remove any suffix
    set query [http::formatQuery $cfig(zipfield) $code]
#puts "query:$query"

    set text [fetch $cfig(zipurl) $query]
#puts "text:$text"

    set fbase [file join [lib::cfig workdir] zip-lookup]
    write_file $fbase.html $text
    eval exec $cfig(lynx) $fbase.html >$fbase.txt	;#lynx will give us text
#puts "lynx:[read_file $fbase.txt]"

    set meat [meat [read_file $fbase.txt] {Cities in a ZIP Code} {Related Links}]
    regsub -all -- {\[[0-9]*\]} $meat {} meat		;#get rid of links
#puts "meat:\n$meat"

    set data {}
    set comment {test}
    foreach ln [split $meat "\n"] {
        if {[regexp {Actual} $ln]}			{set comment {Actual City Name}}
        if {[regexp {Acceptable City names in} $ln]}	{set comment {Acceptable}}
        if {[regexp {Not Acceptable} $ln]}		{set comment {Not Acceptable}}

#	Valid line: ...CITY NAME, ST...
        if {[regexp {([A-Z ]*), ([A-Z][A-Z])} $ln junk city state]} {
            set cnorm {}
            foreach word [string trim $city] {		;#remove spaces and all-caps
                lappend cnorm [cap_first [string tolower $word]]
            }
            lappend data [list [join $cnorm] $state $comment]
        }
    }
#puts "data:$data"
    if {[llength $data] <= 0} {dia::brief "Zip: $code not found"; return {}}

    if {[scm::dia {Please select from the following:} -dest citystate -data $data -tag web_zip_$code \
      -f {city		-wid 60		-help {The city this zip code should belong to}} \
      -f {state		-wid 60		-help {The state this city and zip are in}} \
      -f {comment	-wid 120	-help {Comments by the post office about using the zip code for this city and state}} \
    ] < 0} return {}
    
    return $citystate
}

# Read a file of lines.  After a start string is found in the file, start accumulating
# subsequent lines.  Continue until a line matches the stop string.  Discard that line
# and return the accumulated lines.
#----------------------------------------------------
proc web::meat {file start stop} {

    set accum {}
    set stage {pre}				;#state variable (pre, meat, post)
    foreach ln [split $file "\n"] {		;#for each line in file
#puts "LN:$ln"
        switch $stage {
            pre	{
                if {[regexp -- $start $ln]} {set stage meat}
            }
            meat    {
#puts "ln:$ln"
                if {[regexp -- $stop $ln]} break
                append accum $ln "\n"
            }
        }
    }
    return $accum
}

# View a URL in the default browser
#----------------------------------------------------
proc web::view {url} {
    variable cfig
    eval exec [format $cfig(browser) $url]
}

if {[info commands locawyze] != {}} {locawyze web}
