import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.map.DelegatingMapProperty;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.ui.common.ISortableByColumn;
import org.eclipse.riena.ui.core.marker.IMessageMarker;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.osgi.framework.BundleActivator;

/**
 * 'Hello World' using an {@link ILabelRidget}.
 */

public class RienaSnippet1 {

	public static void main(String[] args) {
		Display display = Display.getDefault();
		try {
			Shell shell = new Shell();
			GridLayoutFactory.fillDefaults().applyTo(shell);

			Label label = new Label(shell, SWT.BORDER);
			GridDataFactory.fillDefaults().grab(true, false).applyTo(label);

			ILabelRidget ridget = (ILabelRidget) SwtRidgetFactory
					.createRidget(label);
			
			Object pojo = new HelloModel(); 
			
			ridget.bindToModel(PojoObservables.observeValue(pojo, "text"));



	
			ridget.updateFromModel();

			shell.pack();
			shell.open();
			while (!shell.isDisposed()) {
				if (!display.readAndDispatch()) {
					display.sleep();
				}
			}
		} finally {
			display.dispose();
		}
	}

	private static final class HelloModel {
		private String text = "Hello Riena model !"; //$NON-NLS-1$

		@SuppressWarnings("unused")
		public String getText() {
			return text;
		}

		@SuppressWarnings("unused")
		public void setText(String text) {
			this.text = text;
		}
	}
}
