/*
 * Decompiled with CFR 0.152.
 */
package Install;

import Install.AdsInstall;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

class Progress
extends JFrame {
    private AdsInstall Owner;
    private JPanel contentPane;
    private int iMaxProgress = 10000;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JLabel jLabel1 = new JLabel();
    private JProgressBar jProgressBar1 = new JProgressBar(0, this.iMaxProgress);
    private JPanel jCenterPanel = new JPanel();
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private JPanel jPanel3 = new JPanel();
    private ZipFile Zip;

    public Progress(AdsInstall oOwner) {
        this.Owner = oOwner;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void CreateDirectory(String strDirectory) throws Exception {
        File CreateDir = new File(strDirectory);
        if (!CreateDir.exists() && !CreateDir.mkdirs()) {
            JOptionPane.showMessageDialog(this, "Could not create the directory:  " + strDirectory + "  Please choose another directory", "Error", 0);
            throw new Exception("Could not create directory");
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.jLabel1.setText("Installing:");
        this.contentPane.setLayout(this.borderLayout1);
        ((Component)this).setSize(new Dimension(300, 75));
        this.setTitle(this.Owner.strTitle);
        this.contentPane.add((Component)this.jPanel1, "West");
        this.contentPane.add((Component)this.jPanel2, "East");
        this.contentPane.add((Component)this.jPanel3, "South");
        this.contentPane.add((Component)this.jLabel1, "North");
        this.contentPane.add((Component)this.jProgressBar1, "Center");
    }

    private void DoHelpFileInstall() {
        this.ExpandFileFromJar("help.zip", "help/./help.zip", this.Owner.strDestination + File.separator + "help");
        this.ExpandZipFile("help.zip", this.Owner.strDestination + File.separator + "help");
    }

    private void ExpandZipFile(String strFile, String strPath) {
        File HelpArchive = new File(strPath, strFile);
        File DestinationDir = new File(strPath);
        byte[] bBuf = new byte[1024];
        ZipFile HelpZip = null;
        FileOutputStream StreamOut = null;
        InputStream StreamIn = null;
        try {
            HelpZip = new ZipFile(HelpArchive);
            int iSize = HelpZip.size();
            int iStep = (this.iMaxProgress - this.jProgressBar1.getValue()) / iSize;
            Enumeration<? extends ZipEntry> entries = HelpZip.entries();
            while (entries.hasMoreElements()) {
                int iRead;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    this.CreateDirectory(entry.getName());
                    continue;
                }
                StreamIn = HelpZip.getInputStream(entry);
                File DestinationFile = new File(DestinationDir, entry.getName());
                File FileParent = new File(DestinationFile.getParent());
                if (FileParent != null && !FileParent.exists()) {
                    FileParent.mkdirs();
                }
                StreamOut = new FileOutputStream(DestinationFile);
                while ((iRead = StreamIn.read(bBuf, 0, bBuf.length)) > 0) {
                    StreamOut.write(bBuf, 0, iRead);
                }
                StreamOut.close();
                this.StepIt(iStep);
                this.paintAll(((Component)this).getGraphics());
            }
            HelpZip.close();
        }
        catch (Exception e) {
            if (HelpZip != null) {
                try {
                    HelpZip.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (StreamOut != null) {
                try {
                    StreamOut.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (StreamIn != null) {
                try {
                    StreamIn.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            e.printStackTrace();
        }
        HelpArchive.delete();
    }

    private void ExpandFileFromJar(String strFile, String strJarName, String strDestination) {
        ZipEntry FileEntry = this.Owner.Jar.getEntry(strJarName);
        if (FileEntry == null) {
            JOptionPane.showMessageDialog(this, "Could not retrieve " + strFile + " from the archive");
        }
        InputStream StreamIn = null;
        FileOutputStream StreamOut = null;
        try {
            int iRead;
            byte[] bBuf = new byte[1024];
            StreamIn = this.Owner.Jar.getInputStream(FileEntry);
            File OutputFile = new File(strDestination, strFile);
            StreamOut = new FileOutputStream(OutputFile);
            while ((iRead = StreamIn.read(bBuf, 0, bBuf.length)) > 0) {
                StreamOut.write(bBuf, 0, iRead);
            }
            StreamOut.close();
            StreamIn.close();
        }
        catch (Exception e) {
            if (StreamIn != null) {
                try {
                    StreamIn.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (StreamOut != null) {
                try {
                    StreamOut.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            e.printStackTrace();
        }
    }

    private void DoDriverInstall() {
        this.ExpandFileFromJar("license.txt", "jdbc/./license.txt", this.Owner.strDestination + File.separator + "jdbc");
        this.ExpandFileFromJar("adsjdbc.jar", "jdbc/./adsjdbc.jar", this.Owner.strDestination + File.separator + "jdbc");
        this.ExpandFileFromJar("RegJBuilder.class", "jdbc/./RegJBuilder.class", this.Owner.strDestination + File.separator + "jdbc");
    }

    private void StepIt(int iStep) {
        this.jProgressBar1.setValue(this.jProgressBar1.getValue() + iStep);
    }

    public void DoInstall() {
        this.jLabel1.setText("Creating Directories");
        this.paintAll(((Component)this).getGraphics());
        try {
            this.CreateDirectory(this.Owner.strDestination);
            this.CreateDirectory(this.Owner.strDestination + File.separator + "jdbc");
            this.CreateDirectory(this.Owner.strDestination + File.separator + "help");
            this.StepIt(3300);
            this.jLabel1.setText("Installing JDBC Driver");
            this.paintAll(((Component)this).getGraphics());
            this.DoDriverInstall();
            this.StepIt(3300);
            this.jLabel1.setText("Installing Help Files");
            this.paintAll(((Component)this).getGraphics());
            this.DoHelpFileInstall();
            this.StepIt(this.iMaxProgress);
            this.jLabel1.setText("Finished Installing Files");
            this.paintAll(((Component)this).getGraphics());
            this.Owner.Next(AdsInstall.iProgress);
        }
        catch (Exception ex) {
            this.Owner.Back(AdsInstall.iProgress);
        }
    }
}

