#!/bin/sh
# ver 0.9.5  Apr 24, 2008, hernad@bring.out.ba

. /etc/functions.sh

config_cb() {

UCI_TYPE=$1
UCI_NAME=$2

if [ "$1" == "system" ] ; then
  SYS_SECT=$2
fi

if [ "$1" == "zone" ] ; then
  ZONE_SECT=$2
fi

}

mkdir_refresh_ip() {
if [ ! -d $TMP_DIR ] 
then
 mkdir $TMP_DIR
fi
}

inspect_ppp0_ip() {

IP=`ifconfig ppp0 | grep -o  "inet addr:\(.*\) P-t-P" | sed -e "s/inet addr://" | sed -e "s/ P-t-P//" | sed -e "s/ //g"`

LAST_IP=`cat last_ip.txt`

mv last_call.txt old_call.txt
if [ "${LAST_IP}" == "${IP}" ]
then
        echo "`date` :  no ip change ${IP}" > last_call.txt
	echo "no ip change"
	exit 0
else
        echo "`date` : IP CHANGE has happened - old ${LAST_IP}  new ${IP} !" > last_call.txt
fi

}


option_cb() {             

if [ "$UCI_TYPE" != "$SHOW" ] ; then
   return
fi 

#      MX              10 mail.sigma-com.net.
if [  "$SHOW" == "mx" ] ; then 
           config_get VAR $UCI_NAME $SHOW
           if [ -n "$VAR" ]; then 
            echo "$VAR" | sed -e "s/^/  MX     /"  >> tmp.zone
           fi 
fi

#      IN NS              ns.sigma-com.net.
if [  "$SHOW" == "ns" ] ; then 
           config_get VAR $UCI_NAME $SHOW
           if [ -n "$VAR" ]; then 
            echo "$VAR" | sed -e "s/^/  IN NS     /"  >> tmp.zone
           fi 
fi

#  host-1    IN A   1.2.3.4
if [  "$SHOW" == "ina" ] ; then 
           config_get VAR $UCI_NAME $SHOW
           if [ -n "$VAR" ]; then 
             echo "$VAR" | sed -e "s/ / IN A /" | sed -e "s/\${IP}/${IP}/" >> tmp.zone
           fi 
fi

#  host-2     CNAME   host-1
if [  "$SHOW" == "cn" ] ; then 
           config_get VAR $UCI_NAME $SHOW
           if [ -n "$VAR" ]; then 
            echo "$VAR" | sed -e "s/ / CNAME /"  >> tmp.zone
           fi 
fi

                                                           
}

reload_nameserver() {           
echo "restarting name server"
scp -o -y -i /etc/dropbear/${HOSTNAME}.key tmp.zone root@${NAMESERVER}:/var/named/${ZONE_NAME}.zone
FEEDBACK=`ssh -y -i /etc/dropbear/${HOSTNAME}.key root@${NAMESERVER} service named restart | grep -c "\[.*OK.*\]"`
# 2 => 2  x [ OK ]                                   
}                                                           


  
config_load system
config_get HOSTNAME $SYS_SECT hostname


                                                                                                                  
SHOW="xx"
config_load refresh_ip
config_get NAMESERVER general nameserver
if [ -z "$NAMESERVER" ]; then
  echo "refresh_ip nameserver not defined"
  exit 0
fi

SERIAL=`date +%y%m%d%H%M`
config_get REFRESH general refresh
config_get RETRY general retry
config_get EXPIRY general expiry
config_get MINIMUM general minimum


TMP_DIR=/tmp/refresh_ip
mkdir_refresh_ip
cd $TMP_DIR

inspect_ppp0_ip

(cat <<TEXT
\$TTL 60   
@       IN SOA     @   root (
                       ${SERIAL}
                       ${REFRESH}
                       ${RETRY}
                       ${EXPIRY}
                       ${MINIMUM} )
TEXT
) > tmp.zone

config_get ZONE_NAME $ZONE_SECT name

# show mx zone items
SHOW="mx"
config_load refresh_ip
# show ns zone items
SHOW="ns"
config_load refresh_ip
# show in a zone items
SHOW="ina"
config_load refresh_ip
# show cname zone items
SHOW="cn"
config_load refresh_ip


echo "ip  $ZONE_NAME = $IP"

FEEDBACK="0"                                                                                      
while [ "$FEEDBACK" != "2" ]                             
do                                   
   reload_nameserver         
   echo "feedback=_${FEEDBACK}_"      
   if [ "$FEEDBACK" == "2" ]
   then
      echo $IP>last_ip.txt  
      echo "ip change has finished">>last_call.txt
      exit 0
   else
     echo "error sleep 10sec"      
     echo "error10 " >> last_call.txt
     sleep 10                        
   fi                             
done                                                   
                                                       
echo "ip change unsucessfull (after while) ?!?">>last_call.txt
