#!/bin/sh
#
# L2TPns apply script
# Applies the uci configuration to l2tpns' configuration file /etc/l2tpns/startup-config
#
# Author: Liran Tal <liran@enginx.com>
#                   <liran.tal@gmail.com>
#
# Last edited: 27 Nov 2007 - added support for proper restart of l2tpns service
#

#==============================================================================
# Exporting the uci configuration settings to the startup-config file
#==============================================================================

. /etc/functions.sh

config_cb() {
	local cfg_type="$1"
	local cfg_name="$2"
	[ "$cfg_type" = "server" ] && server_cfg="$cfg_name" || unset server_cfg
}

option_cb() {
	local var_name="$1"; shift
	local var_value="$*"
	local tvalue
	[ -n "$server_cfg" ] && [ -n "$var_value" ] && {
		case "$var_name" in
			mode) ;;
			debug)
				let tvalue=var_value+1
				[ "$tvalue" -gt 1 ] && l2tpns_options="${l2tpns_options}set ${var_name} ${var_value}${_lf}"
			;;
			*) [ -n "$var_value" ] && l2tpns_options="${l2tpns_options}set ${var_name} ${var_value}${_lf}" ;;
		esac
	}
}

_lf="
"
l2tpns_config_dir="/etc/l2tpns"
l2tpns_config="$l2tpns_config_dir/startup-config"
l2tpns_options="# The L2TPns config file${_lf}# this file is automatically generated by webif^2${_lf}"
[ -d "$l2tpns_config_dir" ] && {
	config_load l2tpns
	echo "$l2tpns_options" > "$l2tpns_config"
}
