#!/usr/bin/webif-page
<?
. /usr/lib/webif/webif.sh

filter_temp="/tmp/.webif.status-conntrackread.tmp"
if [ -n "$FORM_clearfilter" ]; then
	rm -f "$filter_temp" 2>/dev/null
	unset FORM_filtext FORM_filtmode
fi
if [ -n "$FORM_newfilter" ]; then
	echo "# this file is automatically generated by webi^2 page" > "$filter_temp" 2>/dev/null
	echo "# for temporary processing; you are free to delete it" >> "$filter_temp" 2>/dev/null
	echo "filtext=$FORM_filtext" >> "$filter_temp" 2>/dev/null
	echo "filtmode=$FORM_filtmode" >> "$filter_temp" 2>/dev/null
else 
	if [ -e "$filter_temp" ]; then
		FORM_filtext=$(sed '/^filtext=/!d; s/^filtext=//' "$filter_temp" 2>/dev/null)
		FORM_filtmode=$(sed '/^filmode=/!d; s/^filtmode=//' "$filter_temp" 2>/dev/null)
	fi
fi
if [ "$FORM_filtmode" != "include" -a "$FORM_filtmode" != "exclude" ]; then
	FORM_filtmode="include"
fi
[ -n "$FORM_filtext" ] && filtered_title=" (@TR<<log_filter_filtered#filtered>>)"

header "Status" "Conntrack" "@TR<<Conntrack Table>>"

display_form <<EOF
formtag_begin|filterform|$SCRIPT_NAME
start_form|@TR<<log_filter_Text_Filter#Text Filter>>
field|@TR<<log_filter_Text_to_Filter#Text to Filter>>
text|filtext|$FORM_filtext
field|@TR<<log_filter_Filter_Mode#Filter Mode>>
select|filtmode|$FORM_filtmode
option|include|@TR<<log_filter_Include#Include>>
option|exclude|@TR<<log_filter_Exclude#Exclude>>
string|</td></tr><tr><td>
submit|clearfilter|@TR<<log_filter_Remove_Filter#Remove Filter>>
string|</td><td>
submit|newfilter|@TR<<conntrackread_filter_Filter_Records#Filter Records>>
helpitem|log_filter_Text_to_Filter#Text to Filter
helptext|log_filter_Text_to_Filter_helptext#Insert a string that covers what you would like to see or exclude. In fact you can use the reqular expression constants like: <code>00:[[:digit:]]{2}:[[:digit:]]{2}</code> or <code>.debug&#124;.err</code>.
helpitem|log_filter_Filter_Mode#Filter Mode
helptext|log_filter_Filter_Mode_helptext#You will see only messages containing the text in the Include mode while you will not see them in the Exclude mode.
end_form
formtag_end
EOF

cat <<EOF
<div class="settings">
<h3><strong>@TR<<Kernel Connection Tracking Table>>$filtered_title</strong></h3>
<div class="smalltext">
<pre>
EOF
[ -e /proc/net/nf_conntrack ] && cat /proc/net/nf_conntrack 2>/dev/null || cat /proc/net/ip_conntrack 2>/dev/null | awk -v "filtmode=$FORM_filtmode" -v "filtext=$FORM_filtext" '
BEGIN {
	msgcntr = 0
}
function print_sanitize(msg) {
	gsub(/&/, "\\&amp;", msg)
	gsub(/</, "\\&lt;", msg)
	gsub(/>/, "\\&gt;", msg)
	print msg
}
{
	if (filtmode == "include") {
		if ($0 ~ filtext) {
			print_sanitize($0)
			msgcntr++
		}
	} else {
		if ($0 !~ filtext) {
			print_sanitize($0)
			msgcntr++
		}
	}
}
END {
	if (msgcntr == 0) print "@TR<<status_conntrackread_no_messages#There are no connection tracker'\''s records.>>"
}'
cat <<EOF
 </pre>
</div>
<div class="clearfix">&nbsp;</div></div>
EOF

footer ?>
<!--
##WEBIF:name:Status:403:Conntrack
-->
